function vhud::TimeHud::create()
{
	if ( $vTimeHud::Loaded )
		return;
		
	$vTimeHud::Loaded = true;

	vhud::create( "ScriptGL::vTimeHud", "0% 0%", "0% 0%", vhud::TimeHud::render );
	HUD::New("ScriptGL::vTimeHud", 515, 0, 80, 25);
}

$pref::timehudformat = 1;

function vhud::TimeHud::render()
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
		
	if(!Control::getVisible("ScriptGL::vTimeHud"))
		return;
		
	%pos = Control::getposition("ScriptGL::vTimeHud");
	%x = getWord(%pos,0);
	%y = getWord(%pos,1);
	%size = Control::getExtent("ScriptGL::vTimeHud");
	%dx = getWord(%size,0);
	%dy = getWord(%size,1);
	
	
	
	%str = timestamp();
	%year = string::getsubstr(%str, 0, 4);
	%month = string::getsubstr(%str, 5, 2);
	%day = string::getsubstr(%str, 8, 2);
	%hour = string::getsubstr(%str, 11, 2);
	%minutes = string::getsubstr(%str, 14, 2);
	%seconds = string::getsubstr(%str, 17, 2);

	%TimeHud::Format[1] = %hour~":"~%minutes~":"~%seconds;
	%TimeHud::Format[2] = %hour~":"~%minutes;
	%TimeHud::Format[3] = %hour~":"~%minutes~":"~%seconds~" "~%month~"/"~%day~"/"~%year;
	%TimeHud::Format[4] = %hour~":"~%minutes~" "~%month~"/"~%day~"/"~%year;
	%TimeHud::Format[5] = %hour~":"~%minutes~":"~%seconds~" "~%day~"."~%month~"."~%year;
	%TimeHud::Format[6] = %hour~":"~%minutes~" "~%day~"."~%month~"."~%year;
	
	%format = %TimeHud::Format[$pref::timehudformat];
	
	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub( 0, 0, 0, 187 );
	
	glLoadIdentity();
	
	glBegin($GL_QUADS);
		glVertex2f(%x,%y);
		glVertex2f(%x + %dx, %y);
		glVertex2f(%x + %dx, %y + %dy);
		glVertex2f(%x, %y + %dy);
	glEnd();
	
	glColor4ub( 255,  255,  255,  255 );
	glSetFont( "verdana", 7, 0, 9 );
	glDrawString(%x + 5, %y + 8, %format);
	
}

vhud::TimeHud::create();