//for simplicity, this is here
$pref::ChatHud::Lines = 5;

$vChatHud::Width = "850";
$pref::vChatHud::NoDeathMsgs = true;
$vChatHUD::Lines = 0;
$vChatHud::Scroll = 0;

//that's where we get out messages, remember the text, the channel, the name (not just the id, in case the player drops)
//also we have that nifty feature where repeated text will increase the count, repeated messages will just be displayed once
//the taunt sound will still be played, so no worries, just less action in the chat
function vChatHud::DecideMessage( %cl, %msg, %type ) after onClientMessage 
{
	if(%msg != "" && !String::Starts(%msg,"~"))
	{
		if($pref::vChatHud::NoFlagMsgs)
			if(!%cl && String::FindSubStr(%msg, " flag") != -1 )
				return;
		
		if($pref::vChatHud::NoDeathMsgs)
			if(KillTrak::Parse(%msg, "check"))
				return;
		
		//for less buggyness, only filter server messages, channel 0
		if(%type < 2 )
			for(%i = 0; $Filter[%i] != ""; %i++)
			{
				if(String::findSubStr(%msg, $Filter[%i]) != -1)
				{
					return;
				}
			}

		%clName = Client::getName(%cl);
		%now = GetSimTime();
		
		//spam compare lastline, if it's a repeat, increase the count but don't add a line
		if(%now - $vChatHud::Lines[$vChatHUD::Lines, time] < 2.0)
			if(%clName == $vChatHud::Lines[$vChatHUD::Lines, cl])
				if(%msg == $vChatHud::Lines[$vChatHUD::Lines, msg])
					if(%type == $vChatHud::Lines[$vChatHUD::Lines, type])
					{
						$vChatHud::Lines[$vChatHUD::Lines, count]++;
						$vChatHud::Lines[$vChatHUD::Lines, time] = %now;
						return;
					}
		//spam compare last line by client, if it's a repeat, increase the count but don't add a line
		if(%now - $vChatHud::Lines[$vChatHud::LastMessage[%clName], time] < 2.0)
			if(%msg == $vChatHud::Lines[$vChatHud::LastMessage[%clName], msg])
				if(%type == $vChatHud::Lines[$vChatHud::LastMessage[%clName], type])
				{
					$vChatHud::Lines[$vChatHud::LastMessage[%clName], count]++;
					return;
				}
					
		$vChatHud::Lines++;
		$vChatHud::Lines[$vChatHUD::Lines, cl]  =  %clName;
		$vChatHud::Lines[$vChatHUD::Lines, msg]  =  %msg;
		$vChatHud::Lines[$vChatHUD::Lines, type] = %type;
		$vChatHud::Lines[$vChatHUD::Lines, count] = 1;
		$vChatHud::Lines[$vChatHUD::Lines, time] = %now;
		$vChatHud::LastMessage[%clName] = $vChatHUD::Lines;
		
	}
}

function vChatHud::Render()
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
		
	if(!Control::getVisible("ScriptGL::vChatHud"))
		return;
		
	%pos = control::getposition("ScriptGL::vChatHud");
	%x = getWord(%pos,0);
	%y = getWord(%pos,1);
	%dx = $vChatHud::Width;
	
	Control::setExtent("ScriptGL::vChatHud", getWord(Control::getExtent("ScriptGL::vChatHud"),0), -5 +($pref::ChatHud::Lines+1) * 11);
	
	//Control::SetVisible("chatdisplayhud", false);
	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub( 0, 0, 0, 187 );
	glLoadIdentity();
		
	//background
	glBegin($GL_QUADS);
		glVertex2f(%x,%y);			
		glVertex2f(%x + %dx, %y);
		glVertex2f(%x + %dx, %y - 5 + ($pref::ChatHud::Lines+1) * 11);
		glVertex2f(%x, %y - 5 + ($pref::ChatHud::Lines+1) * 11);
	glEnd();
	
	glSetFont( "verdana", 8, 0, 9 );
	
	glColor4ub( 255, 255, 255, 187 );
	// glEnable($GL_TEXTURE_2D);
	// glDrawTexture("lt.png", $GLEX_SCALED, %x, %y - 28, 0.5, -0.5);
	// glDrawTexture("l.png", $GLEX_SCALED, %x, %y - 28, 0.5, 20);
	// glDrawTexture("t.png", $GLEX_SCALED, %x + 6, %y - 28, 44, -0.5);
	// glDrawTexture("lb.png", $GLEX_SCALED, %x, %y - 2, 0.5, -0.5);
	// glDrawTexture("rt.png", $GLEX_SCALED, %x + 50, %y - 28, 0.5, -0.5);
	// glDrawTexture("r.png", $GLEX_SCALED, %x + 50, %y - 28, 0.5, 20);
	// glDrawTexture("rb.png", $GLEX_SCALED, %x + 50, %y - 2, 0.5, -0.5);
	// glDrawTexture("b.png", $GLEX_SCALED, %x + 6, %y - 2, 44, -0.5);
	vChatHud::renderInputField(%x, %y, %dx, %dy);
	
	//the actual text
	glEnable($GL_SCISSOR_TEST);
	glScissor(%x,0,%dx - 10, 1024);

	
	//for each we want displayed
	for(%i = 0; %i < $pref::ChatHud::Lines && %i < $vChatHUD::Lines; %i++)
	{
		//we need to display a scrolled version of the chathud
		if($vChatHud::Scroll > 0)
		{
			//the + 1 is because we want 1 overlapping row
			%displayline = $vChatHUD::Lines - ($vChatHud::Scroll*$pref::ChatHud::Lines) - %i + 1;
			%textslot = %i;
			%textpos[x] = %x + 3;
			%textpos[y] = %y + 5 + ($pref::ChatHud::Lines - %textslot - 1)*11;
		} 
		else 
		{
			%displayline = $vChatHUD::Lines-%i;
			%textslot = %i;
			%textpos[x] = %x + 3;
			%textpos[y] = %y + 5 + ($pref::ChatHud::Lines - %textslot - 1)*11;
		}
		//color desicion for that message
		switch($vChatHud::Lines[%displayline, type])
		{
			case 0:
				glColor4ub( 255, 255, 255, 255 ); break;					
			case 1:
				glColor4ub( 255, 0.0, 0.0, 255 ); break;					
			case 2:
				glColor4ub( 222, 166, 0.0, 255 ); break;					
			case 3:
				glColor4ub( 0.0, 255, 0.0, 255 ); break;					
			default:
				glColor4ub( 255, 255, 0.0, 255 ); break;
		}
		
		//get the message, client and count
		%msg = $vChatHud::Lines[%displayline, msg];
		%cl = $vChatHud::Lines[%displayline, cl];
		%count = $vChatHud::Lines[%displayline, count];
		
		//spam repeat reduction, adding the ammount of times
		if(%count > 1)
			%msg = %msg ~ "("~%count~"x)"; 
		
		//finally draw the string
		if(%cl != "")
			glDrawString( %textpos[x], %textpos[y], %cl ~": "~ %msg );
		else
			glDrawString( %textpos[x], %textpos[y], %msg );
	}
}

//render the area where input text is entered
function vChatHud::RenderInputField(%x,%y,%dx,%dy)
{
	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub( 0, 0, 0, 187 );
	
	//the entry field
	if($ScriptGL::ChatHUD::InputVisible)
	{
		%playgui_height = getword(Control::getExtent("playgui"),1);
		
		%input = "Say: " ~ ScriptGL::ChatHUD::getInput();
		%lines = 1+floor(getWord(glGetStringDimensions(%input),0) / (%dx - 10));

		//check if we have space to render the input field below the chat
		if(%y + 10 - 5 + ($pref::ChatHud::Lines+1+%lines) * 13 < %playgui_height)
		{
			glBegin($GL_QUADS);
				glVertex2f(%x, %y  + ($pref::ChatHud::Lines) * 13);
				glVertex2f(%x + %dx, %y  + ($pref::ChatHud::Lines) * 13);
				glVertex2f(%x + %dx, %y + 10 - 5 + ($pref::ChatHud::Lines+%lines) * 13);
				glVertex2f(%x, %y + 10 - 5 + ($pref::ChatHud::Lines+%lines) * 13);
			glEnd();
			
			if($pref::msgChannel == 0)
				glColor4f( 1.0, 1.0, 1.0, 1.0 );
			else
				glColor4f( 0.0, 1.0, 0.0, 1.0 );
			
			glDrawString( %x + 5, %y + 3  + ($pref::ChatHud::Lines) * 13, %input );
		}
		else //render above the chat 
		{
			glBegin($GL_QUADS);
				glVertex2f(%x, %y - 10 - (%lines) * 13);
				glVertex2f(%x + %dx, %y  - 10 - (%lines) * 13);
				glVertex2f(%x + %dx, %y - 5);
				glVertex2f(%x, %y - 5 );
			glEnd();
			
			if($pref::msgChannel == 0)
				glColor4f( 1.0, 1.0, 1.0, 1.0 );
			else
				glColor4f( 0.0, 1.0, 0.0, 1.0 );

			glDrawString( %x + 5, %y + 3 - 10 - (%lines) * 13, %input );
		}
	}
}
//for some reason several things don't go through onClientMessage() on 1.4
Event::Attach( eventClientJoin, 		vChatHud::onClientJoin );
Event::Attach( eventClientDrop, 		vChatHud::onClientDrop );
Event::Attach( eventClientChangeTeam, 	vChatHud::onClientChangeTeam );

function vChatHud::onClientJoin(%cl)
{
	onClientMessage(0,Client::GetName(%cl) ~ " connected to the game.", 0);
}
function vChatHud::onClientDrop(%cl)
{
	onClientMessage(0,Client::GetName(%cl) ~ " dropped.", 0);
}
function vChatHud::onClientChangeTeam(%cl, %team)
{
	if(%team >= 0)
		onClientMessage(0,Client::GetName(%cl) ~ " joined team " ~ $Team::Name[ %team ], 0);
}

//we create and empty hud via the interface and keep it's size up to date
//while rendering we get the position via control::getPosition();
//that instantly supports a hudmover
function vChatHud::Create()
{
	if ( $vChatHud::Loaded )
		return;
	
	$vChatHud::Loaded = true;
	
	vhud::create( "ScriptGL::vChatHud", "0% 0%", "0% 0%", vChatHud::Render );
	HUD::New("ScriptGL::vChatHud", 0, 25, $vChatHud::Width, 5+($pref::ChatHud::Lines-%i-1)*13);
}
function vChatHud::OnScroll(%direction)
{
	switch(%direction)
	{
		case "Up":
			$vChatHud::Scroll++;
		break;
		
		case "Down":
			if($vChatHud::Scroll > 0)
				$vChatHud::Scroll--;
		break;
	}
}

Event::Attach(eventChatHudScroll, vChatHud::OnScroll);

vChatHud::Create();