$vhud::ctf::Texture::Friendly[taken]	 = "flag.friend.taken.png";
$vhud::ctf::Texture::Friendly[home]		 = "flag.friend.png";
$vhud::ctf::Texture::Friendly[dropped]	 = "flag.dropped.png";

$vhud::ctf::Texture::Enemy[home]		 = "flag.nmy.png";
$vhud::ctf::Texture::Enemy[taken]		 = "flag.nmy.taken.png";
$vhud::ctf::Texture::Enemy[dropped]		 = "flag.dropped.png";


function vhud::ctf::create()
{
	if ( $vCtfHud::Loaded )
		return;
		
	$vCtfHud::Loaded = true;
	
	vhud::create( "ScriptGL::vCtfHud", "0% 0%", "0% 0%", vhud::ctf::onrender );
	HUD::New("ScriptGL::vCtfHud", 595, 0, 400, 25);
}

vhud::ctf::create( );
	
function vhud::ctf::onrender( ) 
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
		
	//we need to have it visible don't we?
	if(!Control::getVisible("ScriptGL::vCtfHud"))
		return;
		
	glDisable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	
	switch($vhud::ctf::style)
	{
		case "vertical":
			vhud::ctf::render::vertical(); break;
		case "horizontal":
			vhud::ctf::render::horizontal(); break;
		default:
			vhud::ctf::render::horizontal(); break;
			glDrawString(%x,%y, "CTF RENDERING STYLE UNDEFINED?"); break;
	}
}

function vhud::ctf::render::vertical()
{
	//get position the default tribes hud way
	$vhud::ctf::Position = Control::getposition("ScriptGL::vCtfHud");
	%x = getWord($vhud::ctf::Position,0);
	%y = getWord($vhud::ctf::Position,1);
	
	%dx = 200;
	%dy = 55;
	
	glColor4ub( 0, 0, 0, 187 );
	glBegin($GL_QUADS);
		glVertex2f(%x,%y);
		glVertex2f(%x + %dx, %y);
		glVertex2f(%x + %dx, %y + %dy);
		glVertex2f(%x, %y + %dy);
	glEnd();
	//width and height
	
	
	glSetFont( "verdana", 7, 0, 9 );
	glColor4ub( 255,  255,  255,  255 );
	
	glDisable($GL_SCISSOR_TEST);
	
	switch(Team::Flag::Location(Team::Friendly()))
	{
		case "field":
			glDrawString(%x + 65, %y + 8, "Dropped "@Team::Flag::Timer(Team::Friendly()));
			glDrawString(%x + 45, %y + 8, Team::Score(Team::Friendly()));
			glDrawTexture($vhud::ctf::Texture::Friendly[taken], $GLEX_SCALED, %x , %y - 5, 1.0, 1.0);
			break;
		case "home":
			glDrawString(%x+65, %y + 8, Team::Flag::Location(Team::Friendly()));
			glDrawString(%x+45, %y + 8, Team::Score(Team::Friendly()));
			glDrawTexture($vhud::ctf::Texture::Friendly[home], $GLEX_SCALED, %x , %y - 5, 1.0, 1.0);
			break;		
		default:
			glDrawString(%x+65, %y + 8, Client::getName(Team::Flag::Location(Team::Friendly())));
			glDrawString(%x+45, %y + 8, Team::Score(Team::Friendly()));
			glDrawTexture(%tex[Team::Friendly(), taken], $GLEX_SCALED, %x , %y - 5, 1.0, 1.0);
			break;
	}
	switch(Team::Flag::Location(Team::Enemy()))
	{
		case "field":
			glDrawString(%x+65,%y + 29, "Dropped "@Team::Flag::Timer(Team::Enemy()));
			glDrawString(%x+45,%y + 29, Team::Score(Team::Enemy()));
			glDrawTexture($vhud::ctf::Texture::Friendly[dropped], $GLEX_SCALED, %x, %y + 18, 1.0, 1.0);
			break;
		case "home":
			glDrawString(%x+65,%y + 29, Team::Flag::Location(Team::Enemy()));
			glDrawString(%x+45,%y + 29, Team::Score(Team::Enemy()));
			glDrawTexture($vhud::ctf::Texture::Enemy[home], $GLEX_SCALED, %x, %y + 18, 1.0, 1.0);
			break;		
		default:
			glDrawString(%x+65,%y + 29, Client::getName(Team::Flag::Location(Team::Enemy())));
			glDrawString(%x+45,%y + 29, Team::Score(Team::Enemy()));
			glDrawTexture($vhud::ctf::Texture::Enemy[taken], $GLEX_SCALED, %x, %y + 18, 1.0, 1.0);
			break;
	}
}

function vhud::ctf::render::horizontal()
{
	//get position the default tribes hud way
	$vhud::ctf::Position = Control::getposition("ScriptGL::vCtfHud");
	%x = getWord($vhud::ctf::Position,0);
	%y = getWord($vhud::ctf::Position,1);
	
	%dx = 2*200;
	%dy = 25;
	
	glColor4ub( 0, 0, 0, 187 );
	glBegin($GL_QUADS);
		glVertex2f(%x,%y);
		glVertex2f(%x + %dx, %y);
		glVertex2f(%x + %dx, %y + %dy);
		glVertex2f(%x, %y + %dy);
	glEnd();
	//width and height
	
	
	glSetFont( "verdana", 7, 0, 9 );
	glColor4ub( 255,  255,  255,  255 );
	switch(Team::Flag::Location(Team::Friendly()))
	{
		case "field":
			glDrawString(%x + 65, %y + 8, "Dropped "@Team::Flag::Timer(Team::Friendly()));
			glDrawString(%x + 45, %y + 8, Team::Score(Team::Friendly()));
			glDrawTexture($vhud::ctf::Texture::Friendly[taken], $GLEX_SCALED, %x , %y - 5, 0.8, 0.8);
			break;
		case "home":
			glDrawString(%x + 65, %y + 8, Team::Flag::Location(Team::Friendly()));
			glDrawString(%x + 45, %y + 8, Team::Score(Team::Friendly()));
			glDrawTexture($vhud::ctf::Texture::Friendly[home], $GLEX_SCALED, %x , %y - 5, 0.8, 0.8);
			break;		
		default:
			glDrawString(%x + 65, %y + 8, Client::getName(Team::Flag::Location(Team::Friendly())));
			glDrawString(%x + 45, %y + 8, Team::Score(Team::Friendly()));
			glDrawTexture(%tex[Team::Friendly(), taken], $GLEX_SCALED, %x , %y - 5, 0.8, 0.8);
			break;
	}
	switch(Team::Flag::Location(Team::Enemy()))
	{
		case "field":
			glDrawString(%x + 65 + 200, %y + 8, "Dropped "@Team::Flag::Timer(Team::Enemy()));
			glDrawString(%x + 45 + 200, %y + 8, Team::Score(Team::Enemy()));
			glDrawTexture($vhud::ctf::Texture::Friendly[dropped], $GLEX_SCALED, %x  + 200, %y - 5, 0.8, 0.8);
			break;
		case "home":
			glDrawString(%x + 65 + 200, %y + 8, Team::Flag::Location(Team::Enemy()));
			glDrawString(%x + 45 + 200, %y + 8, Team::Score(Team::Enemy()));
			glDrawTexture($vhud::ctf::Texture::Enemy[home], $GLEX_SCALED, %x + 200, %y -5, 0.8, 0.8);

			break;		
		default:
			glDrawString(%x + 65 + 200, %y + 8, Client::getName(Team::Flag::Location(Team::Enemy())));
			glDrawString(%x + 45 + 200, %y + 8, Team::Score(Team::Enemy()));
			glDrawTexture($vhud::ctf::Texture::Enemy[taken], $GLEX_SCALED, %x +200, %y -5, 0.8, 0.8);
			break;
	}
}

event::attach(eventFlagCaptured, CtfHUD::Cap);
event::attach(eventFlagTaken, CtfHUD::Change);
event::attach(eventFlagDropped, CtfHUD::Change);
event::attach(eventFlagReturned, CtfHUD::Change);

function CtfHUD::Cap(%flagid){
	$Flag::CapTimer[%flagid] = GetSimTime( );
	$Flag::ChangeTimer[%flagid] = GetSimTime( );
}

function CtfHUD::Change(%flagid){
	$Flag::ChangeTimer[%flagid] = GetSimTime( );
}