function vhud::Health::create()
{
	if ( $vhud::Health::Loaded )
		return;
		
	$vhud::Health::Loaded = true;
	
	vhud::create( "ScriptGL::Health", "0% 0%", "0% 0%", vhud::Health::onrender );
	HUD::New("ScriptGL::Health", 35, 0, 130, 25);
}



function vhud::Health::onrender()
{
	if($Scriptgl::CurrentGui != "playGui")
		return;
	
	if(!Control::getVisible("ScriptGL::Health"))
		return;

	%position = Control::GetPosition("ScriptGL::Health");
	%position[x] = getWord(%position,0);
	%position[y] = getWord(%position,1);
	
	%size = Control::GetExtent("ScriptGL::Health");
	%size[x] = getWord(%size,0);
	%size[y] = getWord(%size,1);
	
	glEnable($GL_BLEND);
	glDisable($GL_TEXTURE_2D);
	glEnable($GL_ALPHA_TEST);
	glDisable($GL_SCISSOR_TEST);
	
	glLoadIdentity();
	
	glTranslatef(%position[x],%position[y],0);
	
	//health frame
	glColor4ub(0,0,0,187);
	glBegin($GL_QUADS);
		glVertex2f(0,0);		
		glVertex2f(%size[x],0);		
		glVertex2f(%size[x],%size[y]);		
		glVertex2f(0,%size[y]);
	glEnd();
	
	
	//health
	glEnable($GL_TEXTURE_2D);
	glEnable($GL_SCISSOR_TEST);
	glBindTexture($GL_TEXTURE_2D, "healthhud.png");
	glScissor(getword(glgetTranslation(),0), getword(glgetTranslation(),1), $health*130/100, %size[y]);

	glColor3f(1.0,1.0,1.0,1.0);
	glBegin($GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex2f(0,0);
		glTexCoord2f(1.0,0.0);
		glVertex2f(%size[x],0);
		glTexCoord2f(1.0,1.0);
		glVertex2f(%size[x],%size[y]);
		glTexCoord2f(0.0, 1.0);
		glVertex2f(0,%size[y]);
	glEnd();

	glDisable($GL_SCISSOR_TEST);
}
vhud::Health::create();