// teammate hud for tribes 1.40

function TeammateHUD::Init() {
	
	Hud::New::Shaded( "Teammate_Hud", 0, 0, 1680, 36, TeammateHUD::Wake, TeammateHUD::Sleep );
	
	newObject("TeammateHUD::Slot1", FearGuiFormattedText, 10, 2, 140, 16);
	newObject("TeammateHUD::Slot2", FearGuiFormattedText, 150, 2, 140, 16);
	newObject("TeammateHUD::Slot3", FearGuiFormattedText, 300, 2, 140, 16);
	newObject("TeammateHUD::Slot4", FearGuiFormattedText, 450, 2, 140, 16);
	newObject("TeammateHUD::Slot5", FearGuiFormattedText, 600, 2, 140, 16);
	newObject("TeammateHUD::Slot6", FearGuiFormattedText, 750, 2, 140, 16);
	newObject("TeammateHUD::Slot7", FearGuiFormattedText, 800, 2, 140, 16);
	newObject("TeammateHUD::Slot8", FearGuiFormattedText, 850, 2, 140, 16);
	newObject("TeammateHUD::Slot9", FearGuiFormattedText, 900, 20, 140, 16);
	newObject("TeammateHUD::Slot10", FearGuiFormattedText, 10, 20, 140, 16);
	newObject("TeammateHUD::Slot11", FearGuiFormattedText, 150, 20, 140, 16);
	newObject("TeammateHUD::Slot12", FearGuiFormattedText, 300, 20, 140, 16);
	newObject("TeammateHUD::Slot13", FearGuiFormattedText, 450, 20, 140, 16);
	newObject("TeammateHUD::Slot14", FearGuiFormattedText, 600, 20, 140, 16);
	newObject("TeammateHUD::Slot15", FearGuiFormattedText, 750, 20, 140, 16);
	newObject("TeammateHUD::Slot16", FearGuiFormattedText, 900, 20, 140, 16);
	
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot1" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot2" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot3" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot4" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot5" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot6" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot7" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot8" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot9" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot10" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot11" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot12" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot13" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot14" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot15" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot16" );
}

function TeammateHUD::Wake() {
	TeammateHUD::Update();
}

function TeammateHUD::Sleep() {
	
}

function TeammateHUD::UpdateTeams() {

	$TeammateHUD::MyTeam = Team::Friendly();
	
	%myid = getManagerId();
	
	$TeammateHUD::Teammates = 0;
	
	for( %l = 1; %l <= $Team::Client::Count; %l++ ) {
		
		%team = $Team::Client::Team[ $Team::Client::List[ %l ] ];
				
		if( %team == $TeammateHUD::MyTeam && $Team::Client::List[ %l ] != %myid ) {
		
			$MyTeam::Name[ $TeammateHUD::Teammates++ ] = $Team::Client::Name[ $Team::Client::List[ %l ] ];
			$MyTeam::PlayerNumber[ $TeammateHUD::Teammates ] = %l;
			
			if( $TeammateHUD::Status[ $MyTeam::PlayerNumber[ $TeammateHUD::Teammates ] ] != "red" )
			
				$TeammateHUD::Status[ $MyTeam::PlayerNumber[ $TeammateHUD::Teammates ] ] = "green";
		}
	}
	TeammateHUD::Update();
}

function TeammateHUD::Update() {

	for( %slot = 1; %slot <= $TeammateHUD::Teammates; %slot++ ) {
	
		control::setValue( "TeammateHUD::Slot" @ %slot, "<b0,0:modules/TeammateHUD/" @ $TeammateHUD::Status[ $MyTeam::PlayerNumber[ %slot ] ] @ ".png>" @ String::escapeFormatting( $MyTeam::Name[ %slot ] ) );
		
	}
	for( %slot = $TeammateHUD::Teammates + 1; %slot <= 16; %slot++ )
		control::setValue( "TeammateHUD::Slot" @ %slot, "" );
	
}

// suicides
function TeammateHUD::SetS_Status( %v, %w ) {
	if( Client::GetTeam( %v ) != $TeammateHUD::MyTeam )
		return;
	$TeammateHUD::Status[ $Team::Client::Position[ %v ] ] = "red";
	TeammateHUD::Update();
	Schedule::Add( "TeammateHUD::ClearStatus(" @ %v @ ");", 5);
}

// deaths and team kills
function TeammateHUD::SetStatus( %k, %v, %w ) {
	if( Client::GetTeam( %v ) != $TeammateHUD::MyTeam )
		return;
	$TeammateHUD::Status[ $Team::Client::Position[ %v ] ] = "red";
	TeammateHUD::Update();
	Schedule::Add( "TeammateHUD::ClearStatus(" @ %v @ ");", 5);
}

function TeammateHUD::ClearStatus( %v ) {
	$TeammateHUD::Status[ $Team::Client::Position[ %v ] ]="green";
	TeammateHUD::Update();
}

TeammateHUD::Init();

Event::Attach( eventClientKilled, TeammateHUD::SetStatus );
Event::Attach( eventClientTeamKilled, TeammateHUD::SetStatus );
Event::Attach( eventClientSuicided, TeammateHUD::SetS_Status );
Event::Attach( eventClientsUpdated, TeammateHUD::UpdateTeams );