// teammate hud for tribes 1.40

function TeammateHUD::Init() {
	
	Hud::New( "Teammate_Hud", 0, 400, 140, 300, TeammateHUD::Wake, TeammateHUD::Sleep );

	// row 1
	newObject("TeammateHUD::Slot1", FearGuiFormattedText, 2, 0, 140, 16);
	newObject("TeammateHUD::Slot2", FearGuiFormattedText, 2, 16, 140, 16);
	newObject("TeammateHUD::Slot3", FearGuiFormattedText, 2, 32, 140, 16);
	newObject("TeammateHUD::Slot4", FearGuiFormattedText, 2, 48, 140, 16);
	newObject("TeammateHUD::Slot5", FearGuiFormattedText, 2, 64, 140, 16);
	newObject("TeammateHUD::Slot6", FearGuiFormattedText, 2, 80, 140, 16);
	newObject("TeammateHUD::Slot7", FearGuiFormattedText, 2, 96, 140, 16);
	newObject("TeammateHUD::Slot8", FearGuiFormattedText, 2, 112, 140, 16);

	// row 2
	newObject("TeammateHUD::Slot9", FearGuiFormattedText, 2, 128, 140, 16);
	newObject("TeammateHUD::Slot10", FearGuiFormattedText, 2, 144, 140, 16);
	newObject("TeammateHUD::Slot11", FearGuiFormattedText, 2, 160, 140, 16);
	newObject("TeammateHUD::Slot12", FearGuiFormattedText, 2, 176, 140, 16);
	newObject("TeammateHUD::Slot13", FearGuiFormattedText, 2, 192, 140, 16);
	newObject("TeammateHUD::Slot14", FearGuiFormattedText, 2, 208, 140, 16);
	newObject("TeammateHUD::Slot15", FearGuiFormattedText, 2, 224, 140, 16);
	newObject("TeammateHUD::Slot16", FearGuiFormattedText, 2, 240, 140, 16);
	
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot1" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot2" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot3" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot4" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot5" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot6" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot7" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot8" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot9" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot10" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot11" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot12" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot13" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot14" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot15" );
	Hud::Add( "Teammate_Hud", "TeammateHUD::Slot16" );
}

function TeammateHUD::Wake() {
	TeammateHUD::Update();
}

function TeammateHUD::Sleep() {
	
}

function TeammateHUD::UpdateTeams() {

	$TeammateHUD::MyTeam = Team::Friendly();
	
	%myid = getManagerId();
	
	$TeammateHUD::Teammates = 0;
	
	for( %l = 1; %l <= $Team::Client::Count; %l++ ) {
		
		%team = $Team::Client::Team[ $Team::Client::List[ %l ] ];
				
		if( %team == $TeammateHUD::MyTeam && $Team::Client::List[ %l ] != %myid ) {
		
			$MyTeam::Name[ $TeammateHUD::Teammates++ ] = $Team::Client::Name[ $Team::Client::List[ %l ] ];
			$MyTeam::PlayerNumber[ $TeammateHUD::Teammates ] = %l;
			
			if( $TeammateHUD::Status[ $MyTeam::PlayerNumber[ $TeammateHUD::Teammates ] ] != "red" )
			
				$TeammateHUD::Status[ $MyTeam::PlayerNumber[ $TeammateHUD::Teammates ] ] = "green";
		}
	}
	TeammateHUD::Update();
}

function TeammateHUD::Update() {

	for( %slot = 1; %slot <= $TeammateHUD::Teammates; %slot++ ) {
	
		control::setValue( "TeammateHUD::Slot" @ %slot, "<b0,0:modules/TeammateHUD/" @ $TeammateHUD::Status[ $MyTeam::PlayerNumber[ %slot ] ] @ ".png>" @ String::escapeFormatting( $MyTeam::Name[ %slot ] ) );
		
	}
	for( %slot = $TeammateHUD::Teammates + 1; %slot <= 16; %slot++ )
		control::setValue( "TeammateHUD::Slot" @ %slot, "" );
	
}

// suicides
function TeammateHUD::SetS_Status( %v, %w ) {
	if( Client::GetTeam( %v ) != $TeammateHUD::MyTeam )
		return;
	$TeammateHUD::Status[ $Team::Client::Position[ %v ] ] = "red";
	TeammateHUD::Update();
	Schedule::Add( "TeammateHUD::ClearStatus(" @ %v @ ");", 5);
}

// deaths and team kills
function TeammateHUD::SetStatus( %k, %v, %w ) {
	if( Client::GetTeam( %v ) != $TeammateHUD::MyTeam )
		return;
	$TeammateHUD::Status[ $Team::Client::Position[ %v ] ] = "red";
	TeammateHUD::Update();
	Schedule::Add( "TeammateHUD::ClearStatus(" @ %v @ ");", 5);
}

function TeammateHUD::ClearStatus( %v ) {
	$TeammateHUD::Status[ $Team::Client::Position[ %v ] ]="green";
	TeammateHUD::Update();
}

TeammateHUD::Init();

Event::Attach( eventClientKilled, TeammateHUD::SetStatus );
Event::Attach( eventClientTeamKilled, TeammateHUD::SetStatus );
Event::Attach( eventClientSuicided, TeammateHUD::SetS_Status );
Event::Attach( eventClientsUpdated, TeammateHUD::UpdateTeams );
