//HERing Created by Blooody
//Based off of vHealth.acs.cs/vEnergy.acs.cs by GreyHound
//Requires ScriptGL

function HERing::Create()
{
	if ( $vhud::HERing::Loaded )
		return;
		
	$vhud::HERing::Loaded = true;
	
	vhud::create( "HERing", "0% 0%", "0% 0%", HERing::Render );
	HUD::New("HERing", 0, 0, 0, 0);
}

function HERing::Render() {

	if($Scriptgl::CurrentGui != "playGui")
		return;
		
	if(!Control::getVisible("HERing"))
		return;
	
	%img = "hering.png";
	
	%pg = Control::getExtent("PlayGui");
	%pg[x] = getWord(%pg, 0);
	%pg[y] = getWord(%pg, 1);
	
	%size = glGetTextureDimensions(%img);
	%size[x] = getWord(%size,0);
	%size[y] = getWord(%size,1);

	%pos[x] = (%pg[x] - %size[x]) / 2;
	%pos[y] = (%pg[y] - %size[y]) / 2;
		
		
	glLoadIdentity();
	
	//Background
	glEnable($GL_TEXTURE_2D);
	glDisable($GL_SCISSOR_TEST);
	glEnable($GL_ALPHA_TEST);
	glEnable($GL_BLEND);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glAlphaFunc($GL_GREATER,$GL_ZERO);
	glColor4ub(0,0,0,200);
	glDrawTexture(%img, $GLEX_DRAW, %pos[x], %pos[y]);
	
	
	//Health & Energy 
	glEnable($GL_SCISSOR_TEST);
	glTranslatef(%pos[x],%pos[y],0);
	glBindTexture($GL_TEXTURE_2D, %img);
	%transx = getword(glgetTranslation(),0);
	%transy = getword(glgetTranslation(),1);
	
	
	//Health
	%hoffset = %transy - $health * %size[y]/100 + %size[y];
	glScissor(%transx, %hoffset, %size[x] / 2, %size[y]);
	
	if ($health > 66) {
		glColor4ub(140,255,110,255);
	}
	else if ($health <= 66 && $health > 32) {
		glColor4ub(255,255,110,255);
	}
	else if ($health <= 31) {
		glColor4ub(255,25,50,255);
	}
	
	glBegin($GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex2f(0,0);
		glTexCoord2f(1.0,0.0);
		glVertex2f(%size[x],0);
		glTexCoord2f(1.0,1.0);
		glVertex2f(%size[x],%size[y]);
		glTexCoord2f(0.0, 1.0);
		glVertex2f(0,%size[y]);
	glEnd();
	
	
	//Energy
	%eoffset = %transy - $energy * %size[y]/100 + %size[y];
	glScissor(%transx + (%size[x]/2),  %eoffset, %size[x], %size[y]);

	glColor4ub(100,220,240,255);
	glBegin($GL_QUADS);
		glTexCoord2f(0.0,0.0);
		glVertex2f(0,0);
		glTexCoord2f(1.0,0.0);
		glVertex2f(%size[x],0);
		glTexCoord2f(1.0,1.0);
		glVertex2f(%size[x],%size[y]);
		glTexCoord2f(0.0, 1.0);
		glVertex2f(0,%size[y]);
	glEnd();

	glDisable($GL_SCISSOR_TEST);
}

HERing::Create();