$MilkGreyHE::Health[right, green] = "H_green_r.png";
$MilkGreyHE::Health[right, orange] = "H_orange_r.png";
$MilkGreyHE::Health[right, red] = "H_red_r.png";

$MilkGreyHE::Health[left, green] = "H_green_l.png";
$MilkGreyHE::Health[left, orange] = "H_orange_l.png";
$MilkGreyHE::Health[left, red] = "H_red_l.png";

$MilkGreyHE::Health[center, green] = "H_green_mid.png";
$MilkGreyHE::Health[center, orange] = "H_orange_mid.png";
$MilkGreyHE::Health[center, red] = "H_red_mid.png";

$MilkGreyHE::Energy[right] = "Ener_r.png";
$MilkGreyHE::Energy[left] = "Ener_l.png";
$MilkGreyHE::Energy[center] = "E_mid.png";

$MilkGreyHE::Trans = "trans.png";
$MilkGreyHE::repairkit = "rkit.png";

$MilkGreyHE::updaterate = 0.1;

$MilkGreyHE::Energy[rkit] = "";

function MilkGreyHE::Init() 
{
	if ( $MilkGreyHE::Loaded )
		return;
	
	$MilkGreyHE::Loaded = true;
	
	HUD::New("MilkGreyHE::Container", 500, 8, 500, 55, MilkGreyHE::Wake, MilkGreyHE::Sleep);

	newObject("MilkGreyHE::Energy::rkit", FearGuiFormattedText, 239, 9, 40, 40); 
	
	
//energy
	for(%i = 0; %i < 10; %i++)
		newObject("MilkGreyHE::Energy::Image_Left_"~%i, FearGuiFormattedText, 14 + 205 - 2 - (%i + 1) * 21, 8, 40, 40); 
	
	for(%i = 0; %i < 10; %i++)
		newObject("MilkGreyHE::Energy::Image_Right_"~%i, FearGuiFormattedText, 14 + 205 + 42 + (%i) * 21, 8, 40, 40); 

	newObject("MilkGreyHE::Energy::Image_Center", FearGuiFormattedText, 14 +  205, 8, 40, 40); 

	//health
	for(%i = 0; %i < 10; %i++)
		newObject("MilkGreyHE::Health::Image_Left_"~%i, FearGuiFormattedText, 205 - 2 - (%i + 1) * 21, 0, 40, 40); 
	
	for(%i = 0; %i < 10; %i++)
		newObject("MilkGreyHE::Health::Image_Right_"~%i, FearGuiFormattedText, 20 + 205 + 42 + (%i) * 21, 0, 40, 40);

	newObject("MilkGreyHE::Health::Image_Center", FearGuiFormattedText, 205, 0, 40, 40); 
	
//add to container
	for(%i = 0; %i < 10; %i++)
	{
		HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Energy::Image_Left_"~%i);
		HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Health::Image_Left_"~%i);		
		
		HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Energy::Image_Right_"~%i);
		HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Health::Image_Right_"~%i);
	}
	
	
	
	HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Energy::Image_Center");
	HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Health::Image_Center");
	HUD::Add("MilkGreyHE::Container", "MilkGreyHE::Energy::rkit");

}

function MilkGreyHE::Wake()
{
	Schedule::Add("MilkGreyHE::Set();", $MilkGreyHE::updaterate);
}
function MilkGreyHE::Sleep()
{
	Schedule::Cancel("MilkGreyHE::Set();");
}

function MilkGreyHE::Set()
{
	if($health <= 100*(1/3))
		%color = "red";
	else if($health > 100*(1/3) && $health <= 100*(2/3))
		%color = "orange";
	else 
		%color = "green";
		
	
	%green_e = floor($energy / 10);
	%green_h = floor($health / 10);
	
	if($health == 0)
		%green_e = 0;
	
	if(getItemCount("Repair Kit") && $health != 0)
		Control::SetValue("MilkGreyHE::Energy::rkit", "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::repairkit~">");
	else
		Control::SetValue("MilkGreyHE::Energy::rkit", "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
	
	
	for(%i = 0; %i < %green_e; %i++)
	{
		Control::SetValue("MilkGreyHE::Energy::Image_Left_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Energy[left]~">");
		Control::SetValue("MilkGreyHE::Energy::Image_Right_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Energy[right]~">");
	}
	for(%i = %green_e; %i < 10; %i++)
	{
		Control::SetValue("MilkGreyHE::Energy::Image_Left_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
		Control::SetValue("MilkGreyHE::Energy::Image_Right_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
	}
	for(%i = 0; %i < %green_h; %i++)
	{
		Control::SetValue("MilkGreyHE::Health::Image_Left_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Health[left, %color]~">");
		Control::SetValue("MilkGreyHE::Health::Image_Right_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Health[right, %color]~">");
	}
	for(%i = %green_h; %i < 10; %i++)
	{
		Control::SetValue("MilkGreyHE::Health::Image_Left_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
		Control::SetValue("MilkGreyHE::Health::Image_Right_"~%i, "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
	}
	
	if($health < 5)
		Control::SetValue("MilkGreyHE::Health::Image_Center", "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
	else
		Control::SetValue("MilkGreyHE::Health::Image_Center", "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Health[center, %color]~">");
		
	if($energy < 5 || $health == 0)
		Control::SetValue("MilkGreyHE::Energy::Image_Center", "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Trans~">");
	else
		Control::SetValue("MilkGreyHE::Energy::Image_Center", "<b3,3:Modules/MilkGreyHE/img/"~$MilkGreyHE::Energy[center]~">");
	
	Schedule::Add("MilkGreyHE::Set();", $MilkGreyHE::updaterate);
}
MilkGreyHE::Init();