/*
	Health and Energy Hud
	Desing by Milkman
	Code by GreyHound
	2011
*/

function vhud::MilkGreyHE::create()
{
	if ( $vhud::MilkGreyHE::Loaded )
		return;
		
	$vhud::MilkGreyHE::Loaded = true;
	
	vhud::create( "ScriptGL::vMilkGreyHE", "0% 0%", "0% 0%", vhud::MilkGreyHE::onrender );
	
	HUD::New("ScriptGL::vMilkGreyHE", 0, 0, 500, 20);
}

function vhud::MilkGreyHE::onrender(){}


function vhud::MilkGreyHE::onrender()
{
	if($ScriptGL::CurrentGui != "playGui")
		return;
	
	if(!Control::getVisible("ScriptGL::vMilkGreyHE"))
		return;

	//get position from the dummy tribes hud (which is there to allow drag and drop moving thingy)
	%health::position = Control::GetPosition("ScriptGL::vMilkGreyHE");
	
	//explode to x and y coordinates
	%health::position[x] = getWord(%health::position,0);
	%health::position[y] = getWord(%health::position,1);
	
	//do the drawing
	glLoadIdentity();
	glTranslatef(%health::position[x], %health::position[y],0);
	
	glColor4f(1.0,1.0,1.0,1.0);
	//set tex env variables
	glEnable($GL_BLEND);
	glEnable($GL_TEXTURE_2D);
	glBlendFunc($GL_SRC_ALPHA,$GL_ONE_MINUS_SRC_ALPHA);	
	glDisable($GL_SCISSOR_TEST);	
	
	%green = floor($energy / 10);
	
	%down = 9;
	%bg = false;

	if(!$health)
		return;
		
	if(%bg)
		for(%i = %green; %i < 10; %i++)
			glDrawTexture("HE_BG.png", $GLEX_DRAW,  16 + 10*22 - %i*21, %down);
		
	for(%i = 0; %i < %green; %i++)
		glDrawTexture("Ener.png", $GLEX_DRAW,  16 + 10*21 - %i*21, %down);
	
	if(%bg)
		if($energy < 5)
			glDrawTexture("E_BG_mid.png", $GLEX_DRAW,  16 + 11*21, %down);
		
	if($energy >= 5)
		glDrawTexture("E_mid.png", $GLEX_DRAW,  16 + 11*21, %down);
	
	if(%bg)
		for(%i = %green; %i < 10; %i++)
			glDrawTexture("HE_BG.png", $GLEX_SCALED,  16 + 11*21 + 77 + %i*21, %down, -1, 1);
		
	for(%i = 0; %i < %green; %i++)
		glDrawTexture("Ener.png", $GLEX_SCALED,  16 + 11*21 + 77 + %i*21, %down, -1, 1);
	
	
	//health
	%green = floor($health / 10);
	
	if($health <= 100*(1/3))
		%color = "red";
	else if($health > 100*(1/3) && $health <= 100*(2/3))
		%color = "orange";
	else 
		%color = "green";
	
	
	if(%bg)
		for(%i = %green; %i < 10; %i++)
			glDrawTexture("HE_BG.png", $GLEX_DRAW,  10*21 - %i*21, 4);
		
	for(%i = 0; %i < %green; %i++)
		glDrawTexture("H_"~%color~".png", $GLEX_DRAW,  10*21 - %i*21, 1);
	
	if(%bg)
		if($health < 5)
			glDrawTexture("H_BG_mid.png", $GLEX_DRAW,  11*21, 4);
		
	if($health >= 5)
		glDrawTexture("H_"~%color~"_mid.png", $GLEX_DRAW,  11*21, 1);
	
	if(%bg)
		for(%i = %green; %i < 10; %i++)
			glDrawTexture("HE_BG.png", $GLEX_SCALED,  11*21 + 107 + %i*21, 4, -1, 1);
		
	for(%i = 0; %i < %green; %i++)
			glDrawTexture("H_"~%color~".png", $GLEX_SCALED,  11*21 + 107 + %i*21, 1, -1, 1);
			
	if(getItemCount("Repair Kit"))
		glDrawTexture("rkit.png", $GLEX_SCALED,  11*21 + 53, 10, -1, 1);
}
vhud::MilkGreyHE::create();