/////////////////////////////////////////////////////////// 
// File: ItemHUD.cs 
// Version: 1.0
// Author: Ernie ;) / daerid :) /  Zlex / Anubis
// Credits: Runar, Presto, Crunchy, Mr.Poop 
// Info: This HUD is practically Crunchy's ItemHUD 
// that was modified to work without Presto that was 
// modified again to work with 1.4
//
//////////////////////////////////////////////////////////// 

// Create HUD, if exists Update 
function ItemHUD::Init() 
{ 

	if ($ItemHUD::Loaded)
		return;
	$ItemHUD::Loaded = true;

	$ItemHUD::Awake = false;

	HUD::New( "ItemHUD::Container", 5, 13, 90, 114, ItemHUD::Wake, ItemHUD::Sleep );

	newObject( "ItemHUD::MineIcon", FearGuiFormattedText, 0, 8, 80, 37 );
	newObject( "ItemHUD::GrenIcon", FearGuiFormattedText, 0, 34, 210, 34 );
	newObject( "ItemHUD::BeacIcon", FearGuiFormattedText, 0, 64, 210, 34 );
	newObject( "ItemHUD::RKitIcon", FearGuiFormattedText, 0, 91, 210, 34 );

	newObject( "ItemHUD::MineText", FearGuiFormattedText, 40, 9, 60, 17 );
	newObject( "ItemHUD::GrenText", FearGuiFormattedText, 40, 37, 190, 14 );
	newObject( "ItemHUD::BeacText", FearGuiFormattedText, 40, 64, 190, 14 );
//	newObject( "ItemHUD::RKitText", FearGuiFormattedText, 40, 99, 190, 14 );

	HUD::Add( "ItemHUD::Container", "ItemHUD::MineIcon" );
	HUD::Add( "ItemHUD::Container", "ItemHUD::GrenIcon" );
	HUD::Add( "ItemHUD::Container", "ItemHUD::BeacIcon" );
	HUD::Add( "ItemHUD::Container", "ItemHUD::RKitIcon" );

	HUD::Add( "ItemHUD::Container", "ItemHUD::MineText" );
	HUD::Add( "ItemHUD::Container", "ItemHUD::GrenText" );
	HUD::Add( "ItemHUD::Container", "ItemHUD::BeacText" );
//	HUD::Add( "ItemHUD::Container", "ItemHUD::RKitText" );


} 

function ItemHUD::Wake() {
	$ItemHUD::Awake = true;
	ItemHUD::Update();
}

function ItemHUD::Sleep() {
	Schedule::Cancel("ItemHUD::Update();");
	$ItemHUD::Awake = false;
}


function ItemHUD::Update() 
{ 

	if ( !$ItemHUD::Awake )
		return;
	
	Schedule::Add("ItemHUD::Update();", 1);

	%Mine = getItemCount("Mine"); 
	%Gren = getItemCount("Grenade"); 
	%Beac = getItemCount("Beacon"); 
	%RKit = getItemCount("Repair Kit"); 

	if ( ( %RKit == $ItemHUD::RKit ) && ( %Mine == $ItemHUD::Mine ) && (%Gren == $ItemHud::Gren ) && (%Beac == $ItemHud::Beac ) )
		return;

	if(%RKit>0)
	{
		%Rkita="Y";
		control::SetValue("ItemHUD::RKitIcon"," <B0,0:modules\\itemhud\\rkiton.png> <f2>");
	}
	else
	{
		%Rkita="N";
		control::setValue("ItemHUD::RKitIcon"," <B0,0:modules\\itemhud\\rkitoff.png> <f2>");	
	}
	
	if(%Mine>0)
	{
		control::setValue("ItemHUD::MineIcon"," <B0,0:modules\\itemhud\\mineon.png>");
		control::setValue("ItemHUD::MineText","<f2>"@%Mine);
	}
	else
	{
		control::setValue("ItemHUD::MineIcon"," <B0,0:modules\\itemhud\\mineoff.png>");
		control::setValue("ItemHUD::MineText","<f2>");
	}

	if(%Gren>0)
	{
		control::setValue("ItemHUD::GrenIcon", " <B0,0:modules\\itemhud\\grenon.png>");
		control::setValue("ItemHUD::GrenText","<f2>"@%Gren);
	}
	else
	{
		control::setValue("ItemHUD::GrenIcon", " <B0,0:modules\\itemhud\\grenoff.png>");
		control::setValue("ItemHUD::GrenText","<f2>");
	}

	if(%Beac>0)
	{
		control::setValue("ItemHUD::BeacIcon", " <B0,0:modules\\itemhud\\beacon.png>");
		control::setValue("ItemHUD::BeacText","<f2>"@%Beac);
	}
	else
	{
		control::setValue("ItemHUD::BeacIcon", " <B0,0:modules\\itemhud\\beacoff.png>");
		control::setValue("ItemHUD::BeacText","<f2>");
	}

} 

ItemHUD::Init();


Event::Attach(eventItemReceived, "Schedule::Add(\"ItemHUD::Update();\", 0);");
Event::Attach(eventItemDropped, "Schedule::Add(\"ItemHUD::Update();\", 0);");
Event::Attach(eventItemUsed, "Schedule::Add(\"ItemHUD::Update();\", 0);");
