class TrCaHCapturePoint extends Actor
	ClassGroup(Tribes)
    native
	placeable;
 
 /** LDs name the capture points. */
var string m_sCapturePointName;

/** Base turrets belonging to this point. */
var() array<TrBaseTurret_Neutral> m_BaseTurrets;

/** Base sensors belonging to this point. */
var() array<TrRadarStation_Neutral> m_BaseSensors;

/** Inventory Stations. */
var() array<TrInventoryStation_Neutral> m_InventoryStations;

/** Repair Stations. */
var() array<TrRepairStation_Neutral> m_RepairStations;

/** Holograms */
var StaticMeshComponent m_GroundBloodEagleHologramMesh;
var StaticMeshComponent m_GroundDiamondSwordHologramMesh;
var StaticMeshComponent m_SkyBloodEagleHologramMesh;
var StaticMeshComponent m_SkyDiamondSwordHologramMesh;
var StaticMeshComponent m_SkyPreviewHologramMesh;

/** Used for changing the color of the holograms. -1 for Enemy, 0 for Held Transition, 1 for Friendly. */
var MaterialInstanceConstant m_BloodEagleHologramMIC;
var MaterialInstanceConstant m_DiamondSwordHologramMIC;

/** Distance to draw holograms in the sky. */
var() float m_fSkyHologramOffsetX;
var() float m_fSkyHologramOffsetY;
var() float m_fSkyHologramOffsetZ;
var Vector m_vSkyHologramOffsetBE;
var Vector m_vSkyHologramOffsetDS;

/** Scale of the sky holograms. */
var() float m_fSkyHologramScaleOffset;
var float m_fSkyHologramScaleBE;
var float m_fSkyHologramScaleDS;

/** Size of the radius that destroys enemy deployables, etc. */
var() float m_fInfluenceRadiusSize;

var vector  LastScreenLoc;
var vector  LastCameraDir;
var vector  LastCameraPos;

/** Size of the marker. */
var() editconst float m_MarkerSize;

/** How long a player must be at this point to get a Holding The Line accolade. */
var float m_HoldTheLineAccoladeTime;


DefaultProperties
{
    Begin Object Class=StaticMeshComponent Name=BaseMesh
        StaticMesh=StaticMesh'TA_BaseAssets.Meshes.CaH_TouchBase'
    End Object
    Components.Add(BaseMesh)
}
