// ActionHUD for 1.40/1.41
// Creates a generic transparent message hud with auto rotate based on a delay on a per line basis
// Bindable command in settings to toggle size of hud / number of lines. Suggest bind to Shift+U
// Preferences (to change defaults, edit in config/ClientPrefs.cs or in console):
//	$pref::ActionHUD::Delay = "5"; 		// Display each line for this number of seconds (Default: 5)
// Smokey 2023
// v1.1

// ActionHUD Font System
//
// FearGuiFormattedText Fonts:
// <f0>		sf_orange214_10.pft
// <f1>		sf_orange255_10.pft
// <f2>		sf_white_10.pft
//
// Custom Fonts (Loaded via BovExpansion_140.dll):
// <f3>		if_w_10b.pft
// <f4>		sf_red_10b.pft
// <f5>		sf_yellow_10b.pft
// <f6>		if_g_10b.pft
//
// ActionHUD will provide the following variables to tag fonts based on whether BovExpansion_140 is loaded:
//	Variable					DLL Loaded			DLL Not Loaded
//	$ActionHUD::WhiteFont		<f3>				<f2>
//	$ActionHUD::RedFont			<f4>				<f0>
//	$ActionHUD::YellowFont		<f5>				<f0>
//	$ActionHUD::GreenFont		<f6>				<f0>

// Preferences. Do not edit here - to change defaults, edit in config/ClientPrefs.cs or in console
$pref::ActionHUD::Delay = $pref::ActionHUD::Delay == "" ? "5" : $pref::ActionHUD::Delay;

// Use FearGuiChatDisplay fonts
$ActionHUD::SystemFont = "if_w_10b.pft"; // msgType: 0		<f3>
$ActionHUD::CommandFont = "sf_red_10b.pft"; // msgType: 1	<f4>
$ActionHUD::GameFont = $ActionHUD::CommandFont;
$ActionHUD::MsgFont = "sf_yellow_10b.pft"; // msgType: 2	<f5>
$ActionHUD::TeamMsgFont = "if_g_10b.pft"; // msgType: 3		<f6>

function ActionHUD::GameBinds::Init() after GameBinds::Init
{
	$GameBinds::CurrentMapHandle = GameBinds::GetActionMap2( "actionMap.sae");
	$GameBinds::CurrentMap = "actionMap.sae";
	GameBinds::addBindCommand( "ActionHUD Size", "ActionHUD::Resize();");
}

if ($pref::ActionHUD::Lines == "")
	$pref::ActionHUD::Lines = 10;

$ActionHUD::MaxLines = 10;

function ActionHUD::SetFont() {
	if ($ActionHUD::FontLoaded)
		return;

	if (isfunction(Bov::setTextFormatFont)) {
		Bov::setTextFormatFont(ActionHUD::Text, 3, $ActionHUD::SystemFont);
		Bov::setTextFormatFont(ActionHUD::Text, 4, $ActionHUD::CommandFont);
		Bov::setTextFormatFont(ActionHUD::Text, 5, $ActionHUD::MsgFont);
		Bov::setTextFormatFont(ActionHUD::Text, 6, $ActionHUD::TeamMsgFont);

		$ActionHUD::WhiteFont = "<f3>";
		$ActionHUD::RedFont = "<f4>";
		$ActionHUD::YellowFont = "<f5>";
		$ActionHUD::GreenFont = "<f6>";

		$ActionHUD::FontLoaded = true;
	} else {
		$ActionHUD::WhiteFont = "<f2>";
		$ActionHUD::RedFont = "<f0>";
		$ActionHUD::YellowFont = "<f0>";
		$ActionHUD::GreenFont = "<f0>";
	}

    ActionHUD::Clear();
}

function ActionHUD::Init() {
	if ($ActionHUD::Loaded)
		return;

	$ActionHUD::Loaded = true;

	HUD::New("ActionHUD::Container", 0, 0, 500, 150, ActionHUD::Wake, ActionHUD::Sleep);
    newObject("ActionHUD::Text", FearGuiFormattedText, 5, 5, 500, 20);
	HUD::Add("ActionHUD::Container", "ActionHUD::Text");
    ActionHUD::Clear();
}

function ActionHUD::Wake() { ActionHUD::Update(); }
function ActionHUD::Sleep() { }

function ActionHUD::Clear() {
	for(%i=0; %i < $ActionHUD::MaxLines; %i++) {
		$ActionHUD::Row[%i] = "";
		$ActionHUD::Time[%i] = "";
	}

	ActionHUD::Update();
}

function ActionHUD::Timer() {
	for(%i=0; %i < $pref::ActionHUD::Lines; %i++) {
		if ( (getSimTime() - $ActionHUD::Time[%i]) > $pref::ActionHUD::Delay) {
			$ActionHUD::Row[%i] = "";
			$ActionHUD::Time[%i] = "";
		}
	}

	ActionHUD::Update();
}

function ActionHUD::Update() {

	// Add padding
	if ($pref::ActionHUD::Lines < $ActionHUD::MaxLines) {
		%padding = $ActionHUD::MaxLines - $pref::ActionHUD::Lines;

		for (%i = 0; %i < %padding; %i++) {
			%display = %display @ "\n";
		}
	}

	for(%i=$pref::ActionHUD::Lines-1; %i >= 0; %i--)
		%display = %display @ $ActionHUD::Row[%i] @ "\n";

	Control::SetValue("ActionHUD::Text", %display);
    Schedule::Add("ActionHUD::Timer();", 0.5);
}

function ActionHUD::Add(%message) {
	for(%i=$pref::ActionHUD::Lines-1; %i > 0; %i--) {
		$ActionHUD::Row[%i] = $ActionHUD::Row[%i-1];
		$ActionHUD::Time[%i] = $ActionHUD::Time[%i-1];
	}

	$ActionHUD::Row[0] = "<f2>" @ %message;
	$ActionHUD::Time[0] = getSimTime();

	ActionHUD::Update();
}

function ActionHUD::Resize() {

	switch ($pref::ActionHUD::Lines) {
        case 3:
            $pref::ActionHUD::Lines = 5;
            break;
        case 5:
            $pref::ActionHUD::Lines = 10;
            break;
        case 10:
            $pref::ActionHUD::Lines = 3;
            break;
    }

    ActionHUD::Clear();

	remoteEP("<f2>ActionHUD Size: <f1>" @ $pref::ActionHUD::Lines, 3, 2, 2, 10, 300);
}

Event::Attach(eventConnectionAccepted, ActionHUD::Clear);
Event::Attach(eventChangeMission, ActionHUD::Clear);
Event::Attach(eventConnected, ActionHUD::SetFont);

ActionHUD::Init();
