//----------------------------------------------------------
// List of all items available to buy from inventory station
exec(combatStructures);

$InvList[Blaster] = 1;
$InvList[EDGun] = 1;
$InvList[GaussRifle] = 1;
$InvList[SilencedPistol] = 1;
$InvList[SniperRifle] = 1;
$InvList[AssaultRifle] = 1;
$InvList[Chaingun] = 1;
$InvList[AutoCannon] = 1;
$InvList[Disclauncher] = 1;
$InvList[GrenadeLauncher] = 1;
$InvList[Mortar] = 1;
$InvList[RocketLauncher] = 1;
$InvList[MissileLauncher] = 1;
$InvList[PlasmaGun] = 1;
$InvList[PlasmaRepeater] = 1;
$InvList[EnergyCannon] = 1;
$InvList[LaserRifle] = 1;
$InvList[EnergyRifle] = 1;
$InvList[TransferGun] = 1;
$InvList[FieldRepairGun] = 1;
$InvList[DemoCharge] = 1;
$InvList[TargetingLaser] = 1;
$InvList[NARCLauncher] = 1;
$InvList[MineAmmo] = 1;
$InvList[Grenade] = 1;
$InvList[Beacon] = 1;

$InvList[FusionPack] = 1;
$InvList[GaussAmmo] = 1;
$InvList[PistolAmmo] = 1;
$InvList[SniperAmmo] = 1;
$InvList[ARAmmo] = 1;
$InvList[HvyBulletAmmo] = 1;
$InvList[ACAmmo] = 1;
$InvList[PlasmaAmmo] = 1;
$InvList[FThrowerAmmo] = 1;
$InvList[DiscAmmo] = 1;
$InvList[GrenadeAmmo] = 1;
$InvList[MortarAmmo] = 1;
$InvList[RLAmmo] = 1;
$InvList[MLAmmo] = 1;
$InvList[NARCAmmo] = 1;
  
$InvList[EnergyPack] = 1;
$InvList[RepairPack] = 1;
$InvList[ShieldPack] = 1;
$InvList[SensorJammerPack] = 1;
$InvList[StealthPack] = 1;
$InvList[ComPack] = 1;
$InvList[TelePack] = 0;
$InvList[VehicleRepairPack] = 1;
$InvList[DetPack] = 0;
$InvList[DronePack] = 1;
$InvList[GuidedBombPack] = 1;
$InvList[SurveyDronePack] = 0;
$InvList[AttackDronePack] = 1;
$InvList[RelocatePack] = 1;
//$InvList[CoolantPack] = 1;

$InvList[MotionSensorPack] = 1;
$InvList[PulseSensorPack] = 1;
$InvList[DGNPack] = 1;
$InvList[DeployableSensorJammerPack] = 1;
$InvList[CameraPack] = 1;
$InvList[AmmoPack] = 1;
$InvList[RepairKit] = 1;
$InvList[DeployableInvPack] = 1;
$InvList[DeployableAmmoPack] = 1;
$InvList[ForceScreen] = 1;
$InvList[Barricade] = 1;
$InvList[TeleportField] = 1;
$InvList[TeleportPad] = 0;
$InvList[TurretPack] = 1;
$InvList[LaserTurretPack] = 1;
$InvList[ChaingunTurret] = 1;
$InvList[RemoteAutoCannon] = 1;
$InvList[RemoteAACannon] = 1;
$InvList[RemotePlasmaTurret] = 1;
$InvList[MissileTurret] = 1;
$InvList[MRL] = 1;
$InvList[LongTom] = 1;
$InvList[SniperNest] = 1;
$InvList[RemoteELF] = 1;
$InvList[StealthMine] = 1;
$InvList[AntiArmorMine] = 1;
$InvList[VehicleBaseControl] = 1;
$InvList[VehicleBasePad] = 1;
$InvList[FloatingPad] = 1;

$InvList[ShieldBeaconPack] = 0;
$InvList[EMPBeaconPack] = 1;
$InvList[PowerGeneratorPack] = 0;
$InvList[EmplacementPack] = 1;
$InvList[PortInvPack] = 0;

$RemoteInvList[Blaster] = 1;
$RemoteInvList[EDGun] = 1;
$RemoteInvList[GaussRifle] = 1;
$RemoteInvList[SilencedPistol] = 1;
$RemoteInvList[SniperRifle] = 1;
$RemoteInvList[AssaultRifle] = 1;
$RemoteInvList[Chaingun] = 1;
$RemoteInvList[AutoCannon] = 1;
$RemoteInvList[Disclauncher] = 1;
$RemoteInvList[GrenadeLauncher] = 1;
$RemoteInvList[Mortar] = 1;
$RemoteInvList[RocketLauncher] = 1;
$RemoteInvList[MissileLauncher] = 1;
$RemoteInvList[PlasmaGun] = 1;
$RemoteInvList[PlasmaRepeater] = 1;
$RemoteInvList[EnergyCannon] = 1;
$RemoteInvList[LaserRifle] = 1;
$RemoteInvList[EnergyRifle] = 1;
$RemoteInvList[TransferGun] = 1;
$RemoteInvList[FieldRepairGun] = 1;
$RemoteInvList[DemoCharge] = 1;
$RemoteInvList[TargetingLaser] = 1;
$RemoteInvList[NARCLauncher] = 1;
$RemoteInvList[MineAmmo] = 1;
$RemoteInvList[Grenade] = 1;
$RemoteInvList[Beacon] = 1;

$RemoteInvList[FusionPack] = 1;
$RemoteInvList[GaussAmmo] = 1;
$RemoteInvList[PistolAmmo] = 1;
$RemoteInvList[SniperAmmo] = 1;
$RemoteInvList[ARAmmo] = 1;
$RemoteInvList[HvyBulletAmmo] = 1;
$RemoteInvList[ACAmmo] = 1;
$RemoteInvList[PlasmaAmmo] = 1;
$RemoteInvList[FThrowerAmmo] = 1;
$RemoteInvList[DiscAmmo] = 1;
$RemoteInvList[GrenadeAmmo] = 1;
$RemoteInvList[MortarAmmo] = 1;
$RemoteInvList[RLAmmo] = 1;
$RemoteInvList[MLAmmo] = 1;
$RemoteInvList[NARCAmmo] = 1;
  
$RemoteInvList[EnergyPack] = 1;
$RemoteInvList[RepairPack] = 1;
$RemoteInvList[ShieldPack] = 1;
$RemoteInvList[SensorJammerPack] = 1;
$RemoteInvList[StealthPack] = 1;
$RemoteInvList[ComPack] = 1;
$RemoteInvList[TelePack] = 0;
$RemoteInvList[VehicleRepairPack] = 1;
$RemoteInvList[DetPack] = 0;
$RemoteInvList[DronePack] = 1;
$RemoteInvList[GuidedBombPack] = 1;
$RemoteInvList[SurveyDronePack] = 0;
$RemoteInvList[AttackDronePack] = 1;
$RemoteInvList[RelocatePack] = 1;
//$RemoteInvList[CoolantPack] = 1;
$RemoteInvList[MotionSensorPack] = 1;
$RemoteInvList[PulseSensorPack] = 1;
$RemoteInvList[DGNPack] = 1;
$RemoteInvList[DeployableSensorJammerPack] = 1;
$RemoteInvList[CameraPack] = 1;
$RemoteInvList[AmmoPack] = 1;
$RemoteInvList[RepairKit] = 1;
$RemoteInvList[ForceScreen] = 1;
$RemoteInvList[Barricade] = 1;
$RemoteInvList[TeleportField] = 0;
$RemoteInvList[TeleportPad] = 0;
$RemoteInvList[TurretPack] = 1;
$RemoteInvList[LaserTurretPack] = 1;
$RemoteInvList[ChaingunTurret] = 1;
$RemoteInvList[RemoteELF] = 1;
$RemoteInvList[SniperNest] = 1;
$RemoteInvList[StealthMine] = 1;
$RemoteInvList[AntiArmorMine] = 1;

$RemoteInvList[ShieldBeaconPack] = 0;
$RemoteInvList[EMPBeaconPack] = 0;
$RemoteInvList[PowerGeneratorPack] = 0;
$RemoteInvList[EmplacementPack] = 0;
$RemoteInvList[PortInvPack] = 0;

//----------------------------------------------------------------------------

// List of all items available to buy from Vehicle station
$VehicleInvList[ScoutVehicle] = 1;
$VehicleInvList[SpeederVehicle] = 1;
$VehicleInvList[HTVehicle] = 1;
$VehicleInvList[LAPCVehicle] = 1;
$VehicleInvList[HAPCVehicle] = 1;
$VehicleInvList[BomberVehicle] = 1;

//----------------------------------------------------------------------------

$DataBlockName[ScoutVehicle] = Scout;
$DatablockName[SpeederVehicle] = Speeder;
$DatablockName[HTVehicle] = HoverTank;
$DataBlockName[LAPCVehicle] = LAPC;
$DataBlockName[BomberVehicle] = Bomber;
$DataBlockName[HAPCVehicle] = HAPC;

$VehicleToItem[Scout] = ScoutVehicle;
$VehicleToItem[Speeder] = SpeederVehicle;
$VehicleToItem[HoverTank] = HTVehicle;
$VehicleToItem[LAPC] = LAPCVehicle;
$VehicleToItem[Bomber] = BomberVehicle;
$VehicleToItem[HAPC] = HAPCVehicle;

//*************
function ResetInvLists()
{
$InvList[Blaster] = 1;
$InvList[EDGun] = 1;
$InvList[GaussRifle] = 1;
$InvList[SilencedPistol] = 1;
$InvList[SniperRifle] = 1;
$InvList[AssaultRifle] = 1;
$InvList[Chaingun] = 1;
$InvList[AutoCannon] = 1;
$InvList[Disclauncher] = 1;
$InvList[KineticRifle] = 1;
$InvList[GrenadeLauncher] = 1;
$InvList[Mortar] = 1;
$InvList[RocketLauncher] = 1;
$InvList[MissileLauncher] = 1;
$InvList[PlasmaGun] = 1;
$InvList[PlasmaRepeater] = 1;
$InvList[EnergyCannon] = 1;
$InvList[LaserRifle] = 1;
$InvList[EnergyRifle] = 1;
$InvList[TransferGun] = 1;
$InvList[FieldRepairGun] = 1;
$InvList[DemoCharge] = 1;
$InvList[TargetingLaser] = 1;
$InvList[NARCLauncher] = 1;
$InvList[MineAmmo] = 1;
$InvList[Grenade] = 1;
$InvList[Beacon] = 1;

$InvList[FusionPack] = 1;
$InvList[GaussAmmo] = 1;
$InvList[PistolAmmo] = 1;
$InvList[SniperAmmo] = 1;
$InvList[ARAmmo] = 1;
$InvList[HvyBulletAmmo] = 1;
$InvList[ACAmmo] = 1;
$InvList[PlasmaAmmo] = 1;
$InvList[FThrowerAmmo] = 1;
$InvList[DiscAmmo] = 1;
$InvList[GrenadeAmmo] = 1;
$InvList[MortarAmmo] = 1;
$InvList[RLAmmo] = 1;
$InvList[MLAmmo] = 1;
$InvList[KineticAmmo] = 1;
$InvList[NARCAmmo] = 1;
  
$InvList[EnergyPack] = 1;
$InvList[RepairPack] = 1;
$InvList[ShieldPack] = 1;
$InvList[SensorJammerPack] = 1;
$InvList[StealthPack] = 1;
$InvList[ComPack] = 1;
$InvList[TelePack] = 0;
$InvList[VehicleRepairPack] = 1;
$InvList[DetPack] = 0;
$InvList[DronePack] = 1;
$InvList[GuidedBombPack] = 1;
$InvList[SurveyDronePack] = 0;
$InvList[AttackDronePack] = 1;
$InvList[RelocatePack] = 1;
//$InvList[CoolantPack] = 1;
$InvList[MotionSensorPack] = 1;
$InvList[PulseSensorPack] = 1;
$InvList[DGNPack] = 1;
$InvList[DeployableSensorJammerPack] = 1;
$InvList[CameraPack] = 1;
$InvList[AmmoPack] = 1;
$InvList[RepairKit] = 1;
$InvList[DeployableInvPack] = 1;
$InvList[DeployableAmmoPack] = 1;
$InvList[ForceScreen] = 1;
$InvList[Barricade] = 1;
$InvList[TeleportField] = 1;
$InvList[TeleportPad] = 0;
$InvList[TurretPack] = 1;
$InvList[LaserTurretPack] = 1;
$InvList[ChaingunTurret] = 1;
$InvList[RemoteAutoCannon] = 1;
$InvList[RemoteAACannon] = 1;
$InvList[RemotePlasmaTurret] = 1;
$InvList[MissileTurret] = 1;
$InvList[MRL] = 1;
$InvList[LongTom] = 1;
$InvList[SniperNest] = 1;
$InvList[RemoteELF] = 1;
$InvList[StealthMine] = 1;
$InvList[AntiArmorMine] = 1;

$InvList[VehicleBaseControl] = 1;
$InvList[VehicleBasePad] = 1;
$InvList[FloatingPad] = 1;

$InvList[ShieldBeaconPack] = 0;
$InvList[EMPBeaconPack] = 1;
$InvList[PowerGeneratorPack] = 0;
$InvList[EmplacementPack] = 1;
$InvList[PortInvPack] = 0;

$RemoteInvList[Blaster] = 1;
$RemoteInvList[EDGun] = 1;
$RemoteInvList[GaussRifle] = 1;
$RemoteInvList[SilencedPistol] = 1;
$RemoteInvList[SniperRifle] = 1;
$RemoteInvList[AssaultRifle] = 1;
$RemoteInvList[Chaingun] = 1;
$RemoteInvList[AutoCannon] = 1;
$RemoteInvList[Disclauncher] = 1;
$RemoteInvList[KineticRifle] = 1;
$RemoteInvList[GrenadeLauncher] = 1;
$RemoteInvList[Mortar] = 1;
$RemoteInvList[RocketLauncher] = 1;
$RemoteInvList[MissileLauncher] = 1;
$RemoteInvList[PlasmaGun] = 1;
$RemoteInvList[PlasmaRepeater] = 1;
$RemoteInvList[EnergyCannon] = 1;
$RemoteInvList[LaserRifle] = 1;
$RemoteInvList[EnergyRifle] = 1;
$RemoteInvList[TransferGun] = 1;
$RemoteInvList[FieldRepairGun] = 1;
$RemoteInvList[DemoCharge] = 1;
$RemoteInvList[TargetingLaser] = 1;
$RemoteInvList[NARCLauncher] = 1;
$RemoteInvList[MineAmmo] = 1;
$RemoteInvList[Grenade] = 1;
$RemoteInvList[Beacon] = 1;

$RemoteInvList[FusionPack] = 1;
$RemoteInvList[GaussAmmo] = 1;
$RemoteInvList[PistolAmmo] = 1;
$RemoteInvList[SniperAmmo] = 1;
$RemoteInvList[ARAmmo] = 1;
$RemoteInvList[HvyBulletAmmo] = 1;
$RemoteInvList[ACAmmo] = 1;
$RemoteInvList[FThrowerAmmo] = 1;
$RemoteInvList[PlasmaAmmo] = 1;
$RemoteInvList[DiscAmmo] = 1;
$RemoteInvList[GrenadeAmmo] = 1;
$RemoteInvList[MortarAmmo] = 1;
$RemoteInvList[RLAmmo] = 1;
$RemoteInvList[MLAmmo] = 1;
$RemoteInvList[KineticAmmo] = 1;
$RemoteInvList[NARCAmmo] = 1;
  
$RemoteInvList[EnergyPack] = 1;
$RemoteInvList[RepairPack] = 1;
$RemoteInvList[ShieldPack] = 1;
$RemoteInvList[SensorJammerPack] = 1;
$RemoteInvList[StealthPack] = 1;
$RemoteInvList[ComPack] = 1;
$RemoteInvList[TelePack] = 0;
$RemoteInvList[VehicleRepairPack] = 1;
$RemoteInvList[DetPack] = 0;
$RemoteInvList[DronePack] = 1;
$RemoteInvList[GuidedBombPack] = 1;
$RemoteInvList[SurveyDronePack] = 0;
$RemoteInvList[AttackDronePack] = 1;
$RemoteInvList[RelocatePack] = 1;
//$RemoteInvList[CoolantPack] = 1;
$RemoteInvList[MotionSensorPack] = 1;
$RemoteInvList[PulseSensorPack] = 1;
$RemoteInvList[DGNPack] = 1;
$RemoteInvList[DeployableSensorJammerPack] = 1;
$RemoteInvList[CameraPack] = 1;
$RemoteInvList[AmmoPack] = 1;
$RemoteInvList[RepairKit] = 1;
$RemoteInvList[ForceScreen] = 1;
$RemoteInvList[Barricade] = 1;
$RemoteInvList[TeleportField] = 0;
$RemoteInvList[TeleportPad] = 0;
$RemoteInvList[TurretPack] = 1;
$RemoteInvList[LaserTurretPack] = 1;
$RemoteInvList[ChaingunTurret] = 1;
$RemoteInvList[RemoteELF] = 1;
$RemoteInvList[SniperNest] = 1;
$RemoteInvList[StealthMine] = 1;
$RemoteInvList[AntiArmorMine] = 1;

$RemoteInvList[ShieldBeaconPack] = 0;
$RemoteInvList[EMPBeaconPack] = 0;
$RemoteInvList[PowerGeneratorPack] = 0;
$RemoteInvList[EmplacementPack] = 0;
$RemoteInvList[PortInvPack] = 0;

$VehicleInvList[ScoutVehicle] = 1;
$VehicleInvList[SpeederVehicle] = 1;
$VehicleInvList[HTVehicle] = 1;
$VehicleInvList[LAPCVehicle] = 1;
$VehicleInvList[HAPCVehicle] = 1;
$VehicleInvList[BomberVehicle] = 1;

}

//----------------------------------------------------------------------------
// Default station animations

function Station::onAdd(%this)
{
 %this.broadcastPower = false;
// StaticShape::onAdd(%this);
}

function Station::onActivate(%this)
{
	//echo("Activate " @ %this);
	%obj = Station::getTarget(%this);
	if (%obj != -1)
	{
		GameBase::playSequence(%this,1,"activate");
		GameBase::setSequenceDirection(%this,1,1);
		%this.lastPlayer = %obj;
		%obj.inStation = %this;

		%client = Player::getClient(%obj);
		%stationName = GameBase::getDataName(%this);
		schedule("bwadmin::isDeployableStationType(" @ %client @ "," @ %stationName@ ");",1);

		if($bwadmin::StationTime)
		{
			if($bwadmin::StationTime < 10)
				$bwadmin::StationTime = 10;
			else if($bwadmin::StationTime > 60)
				$bwadmin::StationTime = 60;
			%obj.stationAccess++;
			%dName = GameBase::getdataName(%this);
			if(%dName == InventoryStation)
				bwCheckStationEject(%obj,%this,%obj.stationAccess,($bwadmin::StationTime / 5));
		}
	}
	else
		GameBase::setActive(%this,false);
}

function Station::onDeactivate(%this)
{
	%obj = %this.lastPlayer;
	if(%this == %obj.inStation)
		%obj.inStation = false;
	GameBase::stopSequence(%this,2);
	GameBase::setSequenceDirection(%this,1,0);
}

function Station::onEndSequence(%this,%thread)
{
 	if (%thread == 1 && GameBase::isActive(%this)) 
	{
		GameBase::playSequence(%this,2,"use");
		return true;
	}
	%client = %this.target;
	if(%client == "") 
	{
		%player = Station::getTarget(%this);
		%client = Player::getClient(%player);
	}
	if(%client != "") 
	{
		if(Client::getGuiMode(%client) != 1) Client::setGuiMode(%client,1);
		
		%team = Client::getTeam(%client);
		if($TeamEnergy[%team] != "Infinite") 
		{
			if(%this.clTeamEnergy != %client.TeamEnergy) 
			{
				if(%client.teamEnergy < 0) Client::sendMessage(%client,0,"Your total mission purchases have come to " @ (%client.teamEnergy * -1) @ ".");
				else Client::sendMessage(%client,0,"You have increased the Team Energy by " @ %client.teamEnergy @ ".");
			}
			if((%client.teamEnergy -%client.EnergyWarning < $TeammateSpending) && ($TeammateSpending != 0) && !$TeamEnergyCheat) 
			{
				TeamMessages(0, %team, "Teammate " @ Client::getName(%client) @ " has spent " @ (%client.teamEnergy *-1) @ " of the TeamEnergy"); 
				%client.EnergyWarning = %client.teamEnergy;
			}
			if($TeamEnergy[%team] < $WarnEnergyLow) TeamMessages(0, %team, "TeamEnergy Low: " @ $TeamEnergy[%team]); 
		}
	}
	if(%this.target != "") 
	{
     %player = Client::getOwnedObject(%this.target);
	 %player.Station = "";
	 %player.stationBoot = "";
	 %this.target = "";
	}
	if(GameBase::getDataName(%this) == VehicleStation && %this.vehiclePad.busy < getSimTime()) VehiclePad::checkSeq(%this.vehiclePad, %this);
	%this.clTeamEnergy = "";
	return false;
}

function Station::onPower(%this,%power,%generator)
{
	if(%power || %this.broadcastPower) 
	{
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
	else 
	{
		GameBase::stopSequence(%this,0);
		GameBase::pauseSequence(%this,1);
		GameBase::pauseSequence(%this,2);
		Station::checkTarget(%this);
	}
}

function Station::onEnabled(%this)
{
	if(GameBase::isPowered(%this) || %this.broadcastPower)
	{
		GameBase::playSequence(%this,0,"power");
		GameBase::playSequence(%this,1);
	}
}

function Station::checkTarget(%this)
{
	if(%this.target) 
	{
		Client::setGuiMode(%this.target,1);
		GameBase::setActive(%this,false);
	}
}

function Station::onDisabled(%this)
{
	Station::weaponCheck(%this);
	GameBase::stopSequence(%this,0);
	GameBase::setSequenceDirection(%this,1,0);
	GameBase::pauseSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
}

function Station::onDestroyed(%this)
{
	Station::weaponCheck(%this);
	StaticShape::objectiveDestroyed(%this);
	GameBase::stopSequence(%this,0);
	GameBase::stopSequence(%this,1);
	GameBase::stopSequence(%this,2);
	Station::checkTarget(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.40, 0.1, 250, 100,%this); 
}

function Station::weaponCheck(%this)
{
	if(%this.lastPlayer != "") 
	{
		%player = %this.lastPlayer;
		%player.Station = "";
		if (!%player.invulnerable && Player::getMountedItem(%player,$WeaponSlot) == -1) {
			if (%player.lastWeapon != "") {
				Player::useItem(%player,%player.lastWeapon);		 	
				%player.lastWeapon = "";
	  		}
		}											
	 	%this.lastPlayer = "";
  	}
}

function Station::getTarget(%this)
{
	if(GameBase::getLOSInfo(%this,1.5,"0 0 3.14")) 
	{
	  	// GetLOSInfo sets the following globals:
	  	// 	los::position
	  	// 	los::normal
	  	// 	los::object
	  	%obj = getObjectType($los::object);
		dbecho(3, "STATION: LOS got " @ %obj);
	  	if (%obj == "Player") 
		{
         if( Player::isAiControlled( $los::object ) != "True" ) return $los::object;
		}
	}
	dbecho(3, "STATION: LOS Got None");
	return -1;
}	

function Station::onCollision(%this, %object)
{
	if(%this.target == "")
	{
		dbecho(3, "STATION: Collision (" @ %this @ "," @ %object @ ")");
		%obj = getObjectType(%object);
		if(%obj == "Player" && isPlayerBusy(%object) == 0) 
		{
  		 	%client = Player::getClient(%object);
 			if(GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1) 
			{
				if(GameBase::getDamageState(%this) == "Enabled") 
				{
				    %armor = Player::getArmor(%client);
					if(GameBase::isPowered(%this) || %this.broadcastPower) 
					{ 
					    %name = GameBase::getDataName(%this);
						if(%name == InventoryStation && $Combat::autoINVBoot)
						{
						 %object.stationBoot = true;
						 %object.stationBootTime = "";
						 Client::sendMessage(%client,0,"You will be ejected in "@$Combat::INVBootTime@" seconds~waccess_denied.wav");
						 schedule("InventoryStation::bootPlayer("@%this@","@%object@");",0,%this);
						}
						if(%this.enterTime == "") %this.enterTime = getSimTime();
						GameBase::setActive(%this,true);
						//%stationName = GameBase::getDataName(%this);
						//bwadmin::isDeployableStationType(%client, %stationName);
					}
					else Client::sendMessage(%client,0,"Unit is not powered");
				}
				else Client::sendMessage(%client,0,"Unit is disabled");
			}
			else if(Station::getTarget(%this) == %object)
   	        {
				%curTime = getSimTime();
				if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") 
				{
					Client::clearItemShopping(%client);
					Station::onDeactivate(%this);
					Station::onEndSequence(%this,1);
					if(Client::getGuiMode(%client) != 1) Client::setGuiMode(%client,1);
					%object.stationDeniedStamp = %curTime;
					Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
				}
			}
		}
	}
}

function Station::itemsToResupply(%player)
{
	%cnt = 0;
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairPatch,1);
	%cnt = %cnt + AmmoStation::resupply(%player,"",Grenade,2);
	%cnt = %cnt + AmmoStation::resupply(%player,"",MineAmmo,1);
	%cnt = %cnt + AmmoStation::resupply(%player,"",RepairKit,1);
      %cnt = %cnt + AmmoStation::resupply(%player,"",Beacon,1);	
	%cnt = %cnt + AmmoStation::resupply(%player,Blaster,FusionPack,100);
	%cnt = %cnt + AmmoStation::resupply(%player,AssaultRifle,ARAmmo,50);
	%cnt = %cnt + AmmoStation::resupply(%player,SniperRifle,SniperAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,PlasmaGun,PlasmaAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,GrenadeLauncher,GrenadeAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,DiscLauncher,DiscAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,KineticRifle,KineticAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,Mortar,MortarAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,GaussRifle,GaussAmmo,5);
	%cnt = %cnt + AmmoStation::resupply(%player,Chaingun,HvyBulletAmmo,20);
	%cnt = %cnt + AmmoStation::resupply(%player,AutoCannon,ACAmmo,10);
	%cnt = %cnt + AmmoStation::resupply(%player,RocketLauncher, RLAmmo,2);
	%cnt = %cnt + AmmoStation::resupply(%player,MissileLauncher, MLAmmo,1);
	%cnt = %cnt + AmmoStation::resupply(%player,SilencedPistol, PistolAmmo,10);
	%cnt = %cnt + AmmoStation::resupply(%player,PlasmaRepeater,FThrowerAmmo,20);
	%cnt = %cnt + AmmoStation::resupply(%player,NARCLauncher,NARCAmmo,5);
	return %cnt;
}

//----------------------------------------------------------------------------
// Deployable stations

function DeployableStation::onActivate(%this)
{
	%obj = Station::getTarget(%this);
	if (%obj != -1) 
	{
		GameBase::playSequence(%this,1,"activate");
		GameBase::setSequenceDirection(%this,1,1);
	}
	else GameBase::setActive(%this,false);
}


function DeployableStation::onEndSequence(%this,%thread)
{
   if(!%thread) 
   {
		%this.deployed = 1;
		GameBase::playSequence(%this,2,"power");
   }
}

function DeployableStation::deploy(%this)
{
	GameBase::playSequence(%this,0,"deploy");
}

function DeployableStation::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function DeployableStation::onEnabled(%this)
{
	GameBase::playSequence(%this,2,"power");
}

function DeployableStation::onDisabled(%this)
{
	GameBase::stopSequence(%this,2);
	GameBase::stopSequence(%this,1);
	Station::checkTarget(%this);
}

function DeployableStation::onDestroyed(%this)
{
	DeployableStation::onDisabled(%this);
	%stationName = GameBase::getDataName(%this);

	if(%stationName == DeployableInvStation) $TeamItemCount[GameBase::getTeam(%this) @ "DeployableInvPack"]--;
	else if( %stationName == DeployableAmmoStation) $TeamItemCount[GameBase::getTeam(%this) @ "DeployableAmmoPack"]--;
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 13, 2, 0.30, 0.1, 200, 100, %this); 
	Station::weaponCheck(%this);
}

function DeployableStation::onCollision(%this, %object)
{
	%obj = getObjectType(%object);
	if (%obj == "Player" && isPlayerBusy(%object) == 0) 
	{
  	 	%client = Player::getClient(%object);
		if(GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1) 
		{
			if (GameBase::getDamageState(%this) == "Enabled") 
			{
				if(%this.enterTime == "") %this.enterTime = getSimTime();
				GameBase::setActive(%this,true);
			}
			else Client::sendMessage(%client,0,"Unit is disabled");
		}
      else if(Station::getTarget(%this) == %object) 
	  {
			%curTime = getSimTime();
			if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") 
			{
				%object.stationDeniedStamp = %curTime;
				Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
			}
		}
	}
}

//-------------------------
StaticShapeData AmmoStation
{
    description = "Ammo Supply Unit";
	shapeFile = "ammounit";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateAmmoStation };
	sequenceSound[1] = { "power", SoundAmmoStationPower };
	sequenceSound[2] = { "use", SoundUseAmmoStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
    explosionId = flashExpLarge;
};

function AmmoStation::onEndSequence(%this,%thread)
{
	%player = Station::getTarget(%this);
	if(%this.clTeamEnergy == "") %this.clTeamEnergy = (Player::getClient(%player)).TeamEnergy;
	if (Station::onEndSequence(%this,%thread)) 
	{
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) 
		{
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
			%client = Player::getClient(%player);
			bwadmin::isWeaponChangeInfoActive(%client, "none");
		}
		%weapon = Player::getMountedItem(%player,$SecondWeaponSlot);
		if(%weapon != -1) 
		{
			Player::unMountItem(%player,$SecondWeaponSlot);
		}
		AmmoStation::onResupply(%this);
	}
}									
											
function AmmoStation::onResupply(%this)
{
	if(GameBase::isActive(%this)) 
	{
		%player = Station::getTarget(%this);

		if(%player != -1 && %this.lastPlayer == %player) 
		{
			// Hardcoded here for the ammo types
			%cnt = Station::itemsToResupply(%player);
			if(getSimTime() - %this.enterTime > 11) %cnt = 0;
			if (%cnt != 0) 
			{
				%player.waitThrowTime = getSimTime();
				schedule("AmmoStation::onResupply(" @ %this @ ");",0.5,%this);
				return;
			}
			%player.Station = "";
			%client = Player::getClient(%player);
			%this.target = "";
			Client::sendMessage(%client,0,"Resupply Complete");
			Client::setInventoryText(%client, "<f1><jc>TEAM ENERGY: " @ $TeamEnergy[Client::getTeam(%client)]);

			if(Player::getMountedItem(%player,$WeaponSlot) == -1)
			{
				if(!%player.invulnerable && %player.lastWeapon != "") 
				{
					Player::useItem(%player,%player.lastWeapon);		 	
					%player.lastWeapon = "";
	  			}
			}			
		}
		else if(%this.target != "") 
		{
			%player = Client::getOwnedObject(%this.target);
			%player.Station = "";
			if(Player::getMountedItem(%player,$WeaponSlot) == -1)
			{
				if(!%player.invulnerable && %player.lastWeapon != "") 
				{
					Player::useItem(%player,%player.lastWeapon);		 	
					%player.lastWeapon = "";
	  			}
			}		
			%this.target = "";
		}
		else 
		{
			%this.lastPlayer.Station = "";
			if(Player::getMountedItem(%this.lastPlayer,$WeaponSlot) == -1)
			{
				if(!%this.lastPlayer.invulnerable && %this.lastPlayer.lastWeapon != "") 
				{
					Player::useItem(%this.lastPlayer,%this.lastPlayer.lastWeapon);		 	
					%this.lastPlayer.lastWeapon = "";
	  			}
			}
			%this.target = "";
		}
		GameBase::setActive(%this,false);
		%this.enterTime="";
	}
}
		 											
function AmmoStation::resupply(%player,%weapon,%item,%delta)
{
	%delta = checkResources(%player,%item,%delta,1);		
	if(%delta > 0) 
	{						
		if(%item == RepairPatch) 
		{
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			GameBase::repairDamage(%player,0.06);
		 	return %delta;
		}
		else if (%item == MineAmmo || %item == Grenade || %item == RepairKit || %item == Beacon)
		{
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			Player::incItemCount(%player,%item,%delta);
		 	return %delta;
		}
		else if (Player::getItemCount(%player,%weapon)) 
		{
			teamEnergyBuySell(%player,%item.price * %delta * -1);
			Player::incItemCount(%player,%item,%delta);
		 	return %delta;
		}
	}
	return 0;
}

//-----------------------------------
StaticShapeData DeployableAmmoStation
{
   description = "Remote Ammo Unit";
	shapeFile = "ammounit_remote";
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundAmmoStationPower };

	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisSmall;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpMedium;
};


function DeployableAmmoStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if(GameBase::getMapName(%this) == "") GameBase::setMapName (%this, "R-Ammo Station");
	%this.Energy = $RemoteAmmoEnergy;
}

function DeployableAmmoStation::onActivate(%this)
{
	if(%this.deployed == 1) 
	{
		GameBase::playSequence(%this,1,"use");
		schedule("AmmoStation::onResupply(" @ %this @ ");",0.5,%this);
		%this.lastPlayer = Station::getTarget(%this);
		%player = %this.lastPlayer; 
		%player.Station = %this;
		%this.target = Player::getClient(Station::getTarget(%this));
		%weapon = Player::getMountedItem(%player,$WeaponSlot);
		if(%weapon != -1) 
		{
			%player.lastWeapon = %weapon;
			Player::unMountItem(%player,$WeaponSlot);
			%client = Player::getClient(%player);
			bwadmin::isWeaponChangeInfoActive(%client, "none");
		}
		%weapon = Player::getMountedItem(%player,$SecondWeaponSlot);
		if(%weapon != -1) 
		{
			Player::unMountItem(%player,$SecondWeaponSlot);
		}
	}
	else GameBase::setActive(%this,false);	
}


//----------------------------------------------------------------------------

StaticShapeData DeployableInvStation
{
	description = "Remote Inv Unit";
	shapeFile = "invent_remote";
	className = "DeployableStation";
	maxDamage = 0.25;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
	sequenceSound[1] = { "use", SoundUseAmmoStation };
	sequenceSound[2] = { "power", SoundInventoryStationPower };			
	visibleToSensor = true;
	shadowDetailMask = 4;
	castLOS = true;
	supression = false;
	supressable = false;
	mapFilter = 4;
	mapIcon = "M_station";
	debrisId = flashDebrisMedium;
	damageSkinData = "objectDamageSkins";
   explosionId = flashExpSmall;
//	triggerRadius = 1.5;
};


function DeployableInvStation::onAdd(%this)
{
	schedule("DeployableStation::deploy(" @ %this @ ");",1,%this);
	if(GameBase::getMapName(%this) == "") GameBase::setMapName (%this, "R-Inv Station");
	%this.Energy = $RemoteInvEnergy;
}

function DeployableInvStation::onActivate(%this)
{
	if(%this.deployed == 1) 
	{
		GameBase::playSequence(%this,1,"use");
 		InventoryStation::onResupply(%this,"RemoteInvList");
		%this.lastPlayer = Station::getTarget(%this);
	}
	else GameBase::setActive(%this,false);
}


//----------------------------------------------------------------------------

StaticShapeData InventoryStation
{
    description = "Station Supply Unit";
	shapeFile = "inventory_sta";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
    explosionId = flashExpLarge;
};

function InventoryStation::onEndSequence(%this,%thread)
{
	if(Station::onEndSequence(%this,%thread)) InventoryStation::onResupply(%this,"InvList");
}

function InventoryStation::onResupply(%this,%InvShopList)
{
	dbecho(3, "STATION::Resupply");
	if (GameBase::isActive(%this)) 
	{
		%player = Station::getTarget(%this);

		//*****************
		//Reset Global Vars
		//*****************
		if(%player != -1)
		 {
		  %client = Player::getClient(%player);
		  $Combat::timeOut[%client] = 0;
	      $assaultShield[%client] = false;
          %player.shieldStrength = 0;
		  $Combat::playerProne[%client] = false;

	 	  //*****************
		  // Reset Energy Level
          $Combat::GaussDrain[%client] = 0;
   		  if(!$Combat::BroadcastPower[%client]) GameBase::setRechargeRate(%player,8);
		  else GameBase::setEnergy(%client,0);
         } 

		if(%player != -1 && %this.lastPlayer == %player) 
		{
			%client = Player::getClient(%player);

			if (%this.target != %client) 
			{
				%player.Station = %this;
				setupShoppingList(%client,%this,%InvShopList);
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;

                if(!%client.noEnterInventory) Client::setGuiMode(%client,$GuiModeInventory);
				Client::sendMessage(%client,0,"Station Access On");
				%player.ResupplyFlag = 1;
				%weapon = Player::getMountedItem(%player,$WeaponSlot);

				if(%weapon != -1) 
				{
					%player.lastWeapon = %weapon;
					Player::unMountItem(%player,$WeaponSlot);
					%client = Player::getClient(%player);
					bwadmin::isWeaponChangeInfoActive(%client, "none");
				}
				%weapon = Player::getMountedItem(%player,$SecondWeaponSlot);
				if(%weapon != -1) 
				{
					Player::unMountItem(%player,$SecondWeaponSlot);
				}
			}

			%player.waitThrowTime = getSimTime();
			schedule("InventoryStation::onResupply(" @ %this @ ");",0.5,%this);
			if(%player.ResupplyFlag) %player.ResupplyFlag = resupply(%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if(%this.target != "") 
	{	   
		%player = Client::getOwnedObject(%this.target);
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
		if(GameBase::getDataName(%player.Station) == DeployableInvStation) 
		{
			Client::setInventoryText(%this.target, "<f1><jc>TEAM ENERGY: " @ $TeamEnergy[Client::getTeam(%this.target)]);
			if(Client::getGuiMode(%this.target) != 1) Client::setGuiMode(%this.target,1);
			%player.Station = "";
  			%this.target = "";
		}
		if(Player::getMountedItem(%player,$WeaponSlot) == -1)
		{
			if(!%player.invulnerable && %player.lastWeapon != "") 
			{
				Player::useItem(%player,%player.lastWeapon);		 	
				%player.lastWeapon = "";
	  		}
		}
	}
	%this.enterTime="";
}

function InventoryStation::bootPlayer(%this,%player)
{
 %client = Player::getClient(%player);
 if(Player::isDead(%player) || !%player.stationBoot) return;
 else if(%player.stationBootTime < $Combat::INVBootTime)
 {
  %player.stationBootTime += 1;
  schedule("InventoryStation::bootPlayer("@%this@","@%player@");",1,%this);
  return;
 }

 if(!%player.station) return;
echo("INV auto boot: "@%player);
 %armor = Player::getArmor(%player);
 %rot = GameBase::getRotation(%this);
 %rot = adjustRot(%rot,3);
 if(%armor == harmor || %armor == darmor) %vect = Vector::getFromRot(%rot,130,110);
 else %vect = Vector::getFromRot(%rot,80,60);
 Player::applyImpulse(%player,%vect);
 Client::sendMessage(%client,0,"You have been ejected from the station.");
}

function resupply(%this)
{
	if(GameBase::isActive(%this)) 
	{
		%player = Station::getTarget(%this);
		if (%player != -1) 
		{
			%cnt = Station::itemsToResupply(%player);
			if(getSimTime() - %this.enterTime > 11) %cnt = 0;
			%client = Player::getClient(%player);
			if (%cnt != 0) 
			{
				updateBuyingList(%client);
				return 1;
			}
			Client::sendMessage(%client,0,"Resupply Complete");
			return 0;
		}
	}
	return 0;
}


//----------------------------------------------------------------------------
function setupShoppingList(%client,%station,%ListType)
{
	%max = getNumItems();
	%armor = Player::getArmor(%client);
	if(%ListType == "InvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {
			%item = getItemData(%i);
			if ($InvList[%item] != "" && $InvList[%item] && !%station.dontSell[%item] &&
				 $ItemMax[%armor, %item] != 0) Client::setItemShopping(%client, %item);
			else if(%item.className == Armor && !%station.dontSell[%item]) Client::setItemShopping(%client, %item);
		}
	} else if(%ListType == "RemoteInvList") {
		for (%i = 0; %i < %max; %i = %i + 1) {
			%item = getItemData(%i);
			if($RemoteInvList[%item] != "" && $RemoteInvList[%item] && !%station.dontSell[%item] &&
				 $ItemMax[%armor, %item] != 0) Client::setItemShopping(%client, %item);
		}
	} else {
		for (%i = 0; %i < %max; %i = %i + 1) {
			%item = getItemData(%i);
			if($VehicleInvList[%item] != "" && $VehicleInvList[%item] && !%station.dontSell[%item]) Client::setItemShopping(%client, %item);
		}
	}
}

function updateBuyingList(%client)
{
	Client::clearItemBuying(%client);
	%station = (Client::getOwnedObject(%client)).Station;
	%stationName = GameBase::getDataName(%station); 
	%listType = "";

	if (%stationName == DeployableInvStation || %stationName == DeployableAmmoStation) {
		%energy = %station.Energy;
		Client::setInventoryText(%client, "<f1><jc>STATION ENERGY: " @ %energy );
	} else {
		%energy = $TeamEnergy[Client::getTeam(%client)];
		Client::setInventoryText(%client, "<f1><jc>TEAM ENERGY: " @ %energy);
	}

	%armor = Player::getArmor(%client);
	%max = getNumItems();
	for (%i = 0; %i < %max; %i++) {
		%item = getItemData(%i);

		if(!%item.showInventory) continue;

		if($ItemMax[%armor, %item] != "" && Client::isItemShoppingOn(%client,%i)) {
			%extraAmmo = 0;
			if(Player::getMountedItem(%client,$BackpackSlot) == ammopack) %extraAmmo = $AmmoPackMax[%item];
			if($ItemMax[%armor, %item] + %extraAmmo > Player::getItemCount(%client,%item)) {
				if(%energy >= %item.price ) {
					if(%item.className == Weapon) {
						if(Player::getItemClassCount(%client,"Weapon") < $MaxWeapons[%armor]) Client::setItemBuying(%client, %item);
					} else {
						if($TeamItemMax[%item] != "") {
							if($TeamItemCount[GameBase::getTeam(%client) @ %item] < $TeamItemMax[%item]) Client::setItemBuying(%client, %item);
						}
						else Client::setItemBuying(%client, %item);
					}
				}
			}
		} else if(%item.className == Armor && 
				%item != $ArmorName[%armor] && 
				Client::isItemShoppingOn(%client,%i)) Client::setItemBuying(%client, %item);
		else if(%item.className == Vehicle && 
		         $TeamItemCount[client::getTeam(%client) @ %item] < $TeamItemMax[%item] && 
				 Client::isItemShoppingOn(%client,%i)) Client::setItemBuying(%client, %item);
	}
}

//----------------------------------------------------------------------------
StaticShapeData CommandStation
{
    description = "Command Station";
	shapeFile = "cmdpnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateCommandStation };
	sequenceSound[1] = { "power", SoundCommandStationPower };
	sequenceSound[2] = { "use", SoundUseCommandStation };
	maxDamage = 1.0;
	debrisId = flashDebrisMedium;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
    explosionId = flashExpLarge;
};

function CommandStation::onEndSequence(%this,%thread)
{
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
	if(Station::onEndSequence(%this,%thread)) CommandStation::onResupply(%this);
}

function CommandStation::onResupply(%this)
{
	if (GameBase::isActive(%this)) 
	{
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) 
		{
			%client = Player::getClient(%player);
			if(%this.target != %client) 
			{
				%this.target = %client;
				%player.CommandTag = 1;
				Client::setGuiMode(%client,2);
				Client::sendMessage(%client,0,"Command Access On");
				%player.station = %this;
			}
			schedule("CommandStation::onResupply(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if(%this.target) 
	{
		Client::sendMessage(%this.target,0,"Command Access Off");
		(Client::getOwnedObject(%this.target)).CommandTag = "";
		checkControlUnmount(%this.target);
	}
	(Client::getOwnedObject(%this.target)).Station = "";
	%this.target = "";
}


//----------------------------------------------------------------------------
StaticShapeData VehicleStation
{
   description = "Station Vehicle Unit";
	shapeFile = "vehi_pur_pnl";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 16;
	triggerRadius = 1.5;
    explosionId = flashExpLarge;
};

function VehicleStation::onEndSequence(%this,%thread)
{
	if (Station::onEndSequence(%this,%thread)) VehicleStation::onBuyingVechicle(%this);
}

function VehicleStation::onBuyingVechicle(%this)
{
	if (GameBase::isActive(%this)) 
	{
		%player = Station::getTarget(%this);
		if (%player != -1 && %this.lastPlayer == %player) 
		{
			%client = Player::getClient(%player);
			if (%this.target != %client) 
			{
				setupShoppingList(%client,%this,"VehicleInvList");
				updateBuyingList(%client);
				%this.target = %client;
				%this.clTeamEnergy = %client.TeamEnergy;
				Client::setGuiMode(%client,4);
				Client::sendMessage(%client,0,"Station Access On");
				%player.Station = %this;
			 	%numItems = Group::objectCount(GetGroup(%this));
				for(%i = 0 ; %i<%numItems ; %i++) 
				{ 
					%obj = Group::getObject(GetGroup(%this), %i);
					%name = GameBase::getDataName(%obj); 
					if(%name == VehiclePad) 
					{ 
						%this.vehiclePad = %obj;
						GameBase::setActive(%this.vehiclePad,true);
						%i = %numItems;
					}
				}
			}
			schedule("VehicleStation::onBuyingVechicle(" @ %this @ ");",0.5,%this);
			return;
		}
		GameBase::setActive(%this,false);
	}
	if (%this.target) 
	{	   
		Client::clearItemShopping(%this.target);
		Client::sendMessage(%this.target,0,"Station Access Off");
		Station::onEndSequence(%this);
	}
}


function VehicleStation::checkBuying(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%obj = %player.Station.vehiclePad;

echo("Vehicle Station "@%obj@" "@GameBase::getDataName(%obj));

	if(GameBase::getDataName(%obj) == ssVehicleBasePad) return(ssVehicleBaseControl::checkBuying(%client,%item));

	if(GameBase::isPowered(%obj) && GameBase::getDamageState(%obj) == "Enabled") 
	{
		%markerPos = GameBase::getPosition(%obj);
  		%set = newObject("set",SimSet);
		%mask = $VehicleObjectType | $SimPlayerObjectType | $ItemObjectType;
		%objInWay = containerBoxFillSet(%set,%mask,%markerPos,6,5,14,1);
		%station = %player.Station;
		if(%objInWay == 1) 
		{
			%object = Group::getObject(%set, 0);	
			%sName = GameBase::getDataName(%object);
			if(%sName.className == Vehicle) 
			{
				if(GameBase::getControlClient(%object) == -1) 
				{
					if(%station.fadeOut == "") 
					{
						if(%item != $VehicleToItem[%sname]) 
						{
							%object.fading = 1;
							%station.fadeOut=1;
							teamEnergyBuySell(%player,$VehicleToItem[%sName].price);
							$TeamItemCount[Client::getTeam(%client) @ ($VehicleToItem[%sName])]--;
							GameBase::startFadeOut(%object);
							schedule("deleteObject(" @ %object @ ");",2.5,%object);
							schedule(%object @ ".fading = \"\";",2.5,%object);
							schedule(%station @ ".fadeOut = \"\";",2.5,%station);
							%objInWay--;
						}
						else return 2;
					}
					else 
					{
						Client::SendMessage(%client,0,"ERROR - Vehicle creation pad busy"); 
						return 0;
					}
				}
				else 
				{ 
					Client::SendMessage(%client,0,"ERROR - Vehicle in creation area is mounted");
					return 0;
				}
			} 
		}
		if(!%objInWay) 
		{
			if (checkResources(%player,%item,1)) 
			{
	    		%vehicle = newObject("",flier,$DataBlockName[%item],true);
				%vehicle.deployer = %client;
				Gamebase::setMapName(%vehicle,%item.description);
                %vehicle.clLastMount = %client;
				addToSet("MissionCleanup", %vehicle);
			  	%vehicle.fading = 1;
				GameBase::setTeam(%vehicle,Client::getTeam(%client));
				if(%object.fading) 
				{ 
					schedule("GameBase::startFadeIn(" @ %vehicle @ ");",2.5,%vehicle);
					schedule("GameBase::setPosition(" @ %vehicle @ ",\"" @ %markerPos @ "\");",2.5,%vehicle);
					schedule("GameBase::setRotation(" @ %vehicle @ ",\"" @ GameBase::getRotation(%obj) @ "\");",2.5,%vehicle);
					schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",5,%vehicle);
					%obj.busy = getSimTime() + 5;
				}
				else 
				{
					GameBase::startFadeIn(%vehicle);
					GameBase::setPosition(%vehicle,%markerPos);
					GameBase::setRotation(%vehicle,GameBase::getRotation(%obj));
				 	schedule(%vehicle @ ".fading = \"\"; VehiclePad::checkSeq(" @ %obj @ "," @ %player.Station @ ");",3,%vehicle);
					%obj.busy = getSimTime() + 3;
				}
				deleteObject(%set);
				$TeamItemCount[Client::getTeam(%client) @ %item]++;
				return 1;
			}
		}
		else Client::SendMessage(%client,0,"ERROR - Object in vehicle creation area");
		deleteObject(%set);
	}	
	else Client::SendMessage(%client,0,"ERROR - Vehicle Pad Disabled");
	return 0;
}


StaticShapeData VehiclePad
{
    description = "Vehicle Pad";
	shapeFile = "vehi_pur_poles";
	className = "Station";
	visibleToSensor = true;
	sequenceSound[0] = { "activate", SoundActivateInventoryStation };
	sequenceSound[1] = { "power", SoundInventoryStationPower };
	sequenceSound[2] = { "use", SoundUseInventoryStation };
	maxDamage = 1.0;
	debrisId = flashDebrisLarge;
	mapFilter = 4;
	mapIcon = "M_station";
    explosionId = flashExpLarge;
	damageSkinData = "objectDamageSkins";
};



function VehiclePad::onActivate(%this)
{
	GameBase::playSequence(%this,1,"use");
}

function VehiclePad::onDeactivate(%this)
{
	GameBase::stopSequence(%this,1);
}

function VehiclePad::onEnabled(%this)
{
}

function VehiclePad::onAdd(%this)
{
}

function VehiclePad::onCollision(%this, %object)
{
}

function VehiclePad::onPower(%this,%power,%generator)
{
	if(!%power) GameBase::setActive(%this,false);
}

function VehiclePad::checkSeq(%this, %station)
{
	if(%station.target == "") GameBase::setActive(%this,false);
}
