// Items cannot be damaged (use a static shape for that)

$InvList[ItemData_Test] = 1;
$RemoteInvList[ItemData_Test] = 1;

$ItemMax[armormEngineer, ItemData_Test] = 1;

// If ammoType, projectileType and weaponType are all included
// and all match up, then the following Image events will be called:
//
// weaponType = 1    spinup will take place and then onFire will be called
//                   repeatedly without a reload.
// weaponType = 2    onActivate and onDeactivate will be called only
//                   if no projectileType is specified
// weaponType = 3    onFire will be called for each shot with a
//                   reload in between

ItemImageData ItemImageData_Test
{
// accuFire = True; // (Valid Nil)
// ammoType = DiscAmmo; // (Valid Nil)
// fireTime = 0.05; // (Valid Nil)
  firstPerson = false; // Appears in first person view (default false)
  lightType = 2; // Valid Nil
  lightRadius = 4; // Valid Nil
  lightTime = 1.5; // Valid Nil
  lightColor = {1, 1, 1}; // Valid Nil
  mass = 0.5; // Makes the player heavier (Valid Nil)
  maxEnergy = 9;
  minEnergy = 4; // Valid Nil
  mountPoint = $FlagSlot;
  mountOffset = { 0, -0.03, 0 }; // Valid Nil
  mountRotation = { 0, 0, 0 }; // Valid Nil
// projectileType = DiscShell; // RepairBolt, etc (Valid Nil)
// reloadTime = 0.1; // (Valid Nil)
  sfxFire = SoundJammerOn; // Played onActivate or onFire (Valid Nil)
  sfxActivate = SoundPickUpWeapon; // Probably onMount (Valid Nil)
  sfxReady = SoundDiscSpin; // (Valid Nil)
  sfxReload = SoundDiscReload; // onDeactivate (Valid Nil)
  sfxSpinUp = SoundSpinUp; // On SpinUp (Valid Nil)
  sfxSpinDown = SoundSpinDown; // On SpinDown (Valid Nil)
  shapeFile = "ammopack"; // On player
// spinUpTime = 0.5; // (Valid Nil)
// spinDownTime = 3; // (Valid Nil)
  weaponType = 2;
};

function ItemImageData_Test::onActivate(%player, %imageSlot) // Executed by trigger
{
   // Called by trigger for weapon type 2
  messageAll(1, "ItemImageData_Test::onActivate(" @ %player @ ", " @ %imageSlot @ ")");
}

function ItemImageData_Test::onDeactivate(%player, %imageSlot) // Executed by trigger (when active)
{
   // Called by trigger for weapon type 2
  messageAll(1, "ItemImageData_Test::onDeactivate(" @ %player @ ", " @ %imageSlot @ ")");
}

function ItemImageData_Test::OnFire(%player,%slot)
{
   // Called by trigger for weapon type 1 and 3
  messageAll(1, "ItemImageData_Test::onFire(" @ %player @ ", " @ %slot @ ")");
}

ItemData ItemData_Test
{
  classname = "backpack";
  description = "Test Item";
  heading = $InvHead[ihBac];
  hiliteOnActive = true;
  hudIcon = "energypack";
  imageType = ItemImageData_Test;
  lightType = 2; // Valid Nil
  lightRadius = 4; // Valid Nil
  lightTime = 1.5; // Valid Nil
  lightColor = { 1, 1, 1 }; // Valid Nil
  price = 650;
  shadowDetailMask = 4;
  shapeFile = "ammounit_remote"; // Inventory station image and thrown item image
  showWeaponBar = true; // Appears as an icon on the play screen
};

function ItemData_Test::onUse(%player, %item)
{
   // Called when...
   // * Use is clicked from the inventory menu
   // * If classname="backpack" then when item is bought
   // * If classname="backpack" and P is pressed
  messageAll(1, "ItemData_Test::onUse");

   // Operations...
   // * If the item is not mounted, then mount it (see Block 1).
   // * If the item is mounted and it should be activated or deactivated,
   //   then do so (see Block 2).
   // * If the item is going to be deployed, then call deploy code.

   // Sample backpack code
   // * The code below could just as easily be made with a call to:
   //     Backpack:onUse(%player, %item)
   //   The only reason for coding it manually is if the item is not a pack
   //   or it is a deployable.

   // Block 1
  if (Player::getMountedItem(%player,$BackpackSlot) != %item)
    Player::mountItem(%player,%item,$BackpackSlot);
   // Block 2
  else
    Player::trigger(%player,$BackpackSlot);
}

function ItemData_Test::onMount(%player, %item) // Executed by mountItem (usually from onUse)
{
   // * mountItem is called for this item
   // ! NOT CALLED for incItemCount
  messageAll(1, "ItemData_Test::onMount");
}

function ItemData_Test::onUnMount(%player, %item) // Executed by unmountItem (usually from onDrop)
{
   // * unmountItem is called for this item
   // * Mounted object has decItemCount called on it
  messageAll(1, "ItemData_Test::onUnMount");
}

function ItemData_Test::onDrop(%player, %item)
{
   // * Drop is clicked from the inventory menu
   // * If classname="backpack" and Ctrl-P is pressed
  messageAll(1, "ItemData_Test::onDrop");

   // Sample code
   // * Pretty much all drops are the same.  See Item.cs for more info.
  Item::onDrop(%player, %item);
}

function ItemData_Test::onDeploy(%player, %item, %pos)
{
   // * deployItem is called
  messageAll(1, "ItemData_Test::onDeploy");
}

function ItemData_Test::onCollision(%this, %object)
{
   // * This item collides with %object
  messageAll(1, "ItemData_Test::onCollision");

   // Sample code
   // * The code below will allow the item to be picked up by a player.  If
   //   isRotating is set for the item, it will respawn it.
  Item::onCollision(%this, %object);
}

function ItemData_Test::onEnabled(%this)
{
   // Not sure.  Called sometime in the Drop sequence.
  messageAll(1, "ItemData_Test::onEnabled");
}

function ItemData_Test::onDisabled(%this)
{
   // Not sure.  Never had this one called.
  messageAll(1, "ItemData_Test::onDisabled");
}

function ItemData_Test::onAdd(%this)
{
   // * Run by newObject

   // This function is less useful than it seems.  Apparently when
   // buying from an inv station, newObject is not called.  It is called
   // primarily when the item is thrown (since a thrown item is created).
  messageAll(1, "ItemData_Test::onAdd");
}

function ItemData_Test::onRemove(%this)
{
   // * Run by deleteObject

   // Like onAdd, this function too is less useful than it seems.  It
   // is usually called when an item is picked up (since the thrown item
   // is deleted).
  messageAll(1, "ItemData_Test::onRemove");
}

