////////////////////////////////////////////////////////////
// File:	AmmoHUD.cs
// Version:	1.1
// Author:	Runar
// Credits:	Presto, Crunchy, Mr.Poop
// Info:	AmmoHud.. currently only for 1024x768
//
//
////////////////////////////////////////////////////////////

$Viking::BMPdir = "Viking\\BMP\\";
$AmmoHUD::Exist = "False";

Event::Attach(eventLoadPlayGui, AmmoHUD::Create);
Event::Attach(eventGuiOpen, AmmoHUD::playGuiOpen);
Event::Attach(eventGuiClose, AmmoHUD::playGuiClose);
Event::Attach(eventExit, AmmoHUD::Destroy);

////////////////////////////////////////////////////////////

$Ammo::Descr[13] = "Chaingun Bullets";
$Ammo::Descr[15] = "Plasma Cell";
$Ammo::Descr[17] = "Grenade Rounds";
$Ammo::Descr[19] = "Mortar Ammo";
$Ammo::Descr[21] = "Disc Ammo";
$Ammo::Descr[23] = "Minigun Ammo";
$Ammo::Descr[25] = "Laser Cell";
$Ammo::Descr[27] = "FireStorm Cell";
$Ammo::Descr[29] = "Shockwave Cell";
$Ammo::Descr[31] = "FEB Bullets";
$Ammo::Descr[33] = "Shockwave Cell";
$Ammo::Descr[35] = "Frag Rounds";
$Ammo::Descr[37] = "Flamer Ammo";
$Ammo::Descr[39] = "Fusion Ammo";
$Ammo::Descr[41] = "Napalm Gel";
$Ammo::Descr[43] = "IX-Bullets";
$Ammo::Descr[45] = "IX-Shotgun Shells";
$Ammo::Descr[47] = "IX-Sniper Rounds";
$Ammo::Descr[49] = "Mine Rounds";
$Ammo::Descr[51] = "Missiles";
$Ammo::Descr[53] = "Mortar Rounds";
$Ammo::Descr[55] = "Pulse Cell";
$Ammo::Descr[57] = "Rails";
$Ammo::Descr[59] = "Raptor Bullets";
$Ammo::Descr[61] = "Reaper Cell";
$Ammo::Descr[63] = "FBW Rockets";
$Ammo::Descr[65] = "Trojax Cell";

////////////////////////////////////////////////////////////
// Create HUD, if exists Update
function AmmoHUD::Create()
{
	if($AmmoHUD::Exist)
	{
		AmmoHUD::Update();
		return;
	}

	// Get resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Just to make sure we delete any stale objects
	AmmoHUD::Destroy();
	
	// Make sure we don't double it!
	$AmmoHUD::Exist = "True";

	// Here's the main container
	%hudContainer=newObject("AmmoHUD_Container", SimGui::Control, %x / 2 - 24, %y / 2 + 24, 16, 16);

	// Here's the FPS-icon
	%AmmoCount=newObject("AmmoHUD_Text", FearGuiFormattedText, 0, 0, 16, 16);

	addToSet("AmmoHUD_Container", %AmmoCount);
	
	// Add the whole container to PlayGui
	addToSet(PlayGui, %hudContainer);
	
	// Update the HUD to set values
	AmmoHUD::Update();

}

function AmmoCount(%weaponId)
{
	%ammo = getItemCount($Ammo::Descr[%weaponId]);

	if(%ammo)
	{
		return("<F2>" @ %ammo);
	}
	else
	{
		return("<F0>~");
	}
}

function AmmoHUD::Update()
{
	Control::setValue("AmmoHUD_Text", AmmoCount(getMountedItem(0)));
	Schedule::Add("AmmoHUD::Update();", 0.5, "AmmoHUD");
}

function AmmoHUD::playGuiOpen(%gui)
{
	if(%gui == "playGui")
		AmmoHUD::Update();

}

function AmmoHUD::playGuiClose(%gui)
{
	if(%gui == "playGui")
		Schedule::Cancel("AmmoHUD");
}

function AmmoHUD::Destroy()
{
	HUD::Destroy("AmmoHUD_");
	HUD::Destroy("AmmoHUD_");
	$AmmoHUD::Exist = "False";
}
