////////////////////////////////////////////////////////////
// File: BWclient.cs
// Version: 2.2
// Author: Runar 
// Credits:
// Info: 
//
////////////////////////////////////////////////////////////

Event::Attach(eventConnectionAccepted, BWclient::Init);
Event::Attach(eventEndGame, BWclient::Reset);
Event::Attach(eventConnectionLost, BWclient::Reset);
Event::Attach(eventConnectionTimeout, BWclient::Reset);
Event::Attach(eventConnectionRejected, BWclient::Reset);

////////////////////////////////////////////////////////////

// Always assume it's not an BWadmin server
$BWclient = False;

function BWclient::Init()
{
	// Always assume it's not an BWadmin server
	$BWclient = False;

       // Request support for BWclient
       remoteEval(2048, BWadmin::isCompatible, getManagerId());
}

function BWclient::Reset()
{
	$BWclient = False;
}

function remoteBWadmin::Compatible(%client, %version)
{
	// Only if it's version 5 or above
	if(%version >= 5)
	{
  		$BWclient = True;

  		// Request the scorelist
		remoteEval(2048, BWadmin::teamScoreList);

  		// Enable the all the stuff we want..
  		remoteEval(2048, BWadmin::EnableSupport, getManagerId(), "ObjectiveInfo");
  		remoteEval(2048, BWadmin::EnableSupport, getManagerId(), "KillInfo");
  		//remoteEval(2048, BWadmin::EnableSupport, getManagerId(), "StationType");
 	}
}

function remoteBWadmin::setTeamScoreList(%server, %teamId, %teamName, %players, %scoreLimit, %teamScore )
{
 	// Set the score
 	$TT::Team::Score[%teamId] = %teamScore;
    
    	// Update the HUD
    	FlagHUD::Update();
}

function remoteBWadmin::SupportVerify(%client, %type, %enable)
{
 	if(%enable)
 	{
        	echo("BWadmin client support for " @ %type @ " enabled!");
 	}
 	else
 	{
  		echo("BWadmin client support for " @ %type @ " requested but NOT enabled!");
 	}
}

function remoteBWadmin::setObjList(%server, %objId, %totalNumObjectives, %objName, %objType, %objStatus)
{
	if(%objType == "flag")
 	{
		if (%objStatus != "home")
			$TT::Flag::Location[%objId] = %objStatus;

		TrakHUD::Update();
 	}
}

function remotebwadmin::KillInfo(%client, %killerId, %victimId, %weapon)
{
	if(%weapon == "")
		%weapon = "Suicide";

	Event::Trigger(eventKillTrak, %client, %victimId, %killerId, %weapon);
}

function remotebwadmin::StationInfo(%client, %type, %noofkits)
{
	if(%type == InventoryStation)
  		Event::Trigger(eventEnterStation, %station, "True", "True");

 	if(%type == DeployableInvStation)
  		Event::Trigger(eventEnterStation, %station, "False", "False");
}

function remotebwadmin::PilotingInfo(%client, %active)
{
// 	echo("BW PilotingInfo:" @%client  @%active);
}
