////////////////////////////////////////////////////////////
// File:	CmdView.cs 1.4Beta
// Author:	Runar/Freaky
// Credits:	Freaky, and Coca-Cola for keeping me awake..
// Info:	Places a mini-commander on your screen.
//
// History: 1.4 Added autoposition for 1024x768 and 800x600.
//
// 		1.3 Totally new approach, ONLY use the PlayGui.
//		Features BOTH the normal and the mini commander.
//		Now this of course also has some drawbacks:
//
//		IMPORTANT!!!
//
//		-You MUST open the commander once to get the
//		 guis in place after a new mission has been
//		 started.
//		-Will NOT work on bad connections, if you have
//		 problems changing weapons or fireing, just
//		 toggle the cmdview off. This is feature is NOT
//		 for HPB's, sorry about that.
//		-Pressing "c" (the commander key) will cause a
//		 slight delay or lag before and after accessing
//		 the original commander.
//		-You need to toggle the CmdView ON after every
//		 death/inventory/objective screen.
//		-Messes up the tab-menu a bit, Toggle CmdView
//		 off before looking at tab-menu. Or if you
//		 already pressed Tab and cant close it, just
//		 close the CmdView and Tab again.
//		-If something crashes, you may end up with a
//		 broken PlayGui, in that case just delete
//		 Tribes\Config\play.gui. Should not be very
//		 likely to happen now though.
//		-Still does NOT work on BWadmin servers :\
//		 Really need to talk to Wizard or poker.
//
////////////////////////////////////////////////////////////

// This may need to be raised for HPB's
$CmdView::Delay = "0.3";

////////////////////////////////////////////////////////////

// Need this..
$CmdView::Active = "False";
$CmdView::Exist = "False";

// Attach our events
Event::Attach(eventLoadPlayGui, CmdView::Create);
Event::Attach(eventGuiOpen, CmdView::onGuiOpen);
Event::Attach(eventExit, CmdView::Destroy);

function CmdView::Create()
{
	// Make sure we dont make 2
	if($CmdView::Exist)
		return;

	// Get resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Delete old objects
	CmdView::Destroy();

	// Delete the entire CommandGui
//	if(isObject(CommandGui))
//		deleteobject(CommandGui);

	// Here's the main container
	%hudContainer=newObject("CmdView_Container", SimGui::Control, %x - 260, %y - 280, 250, 220);

	// Heres the background
	//%mapbg = newObject("CmdView_BG", FearGui::FearGuiMenu, 0, 0, 250, 220);

	// Create the new CommanderMap object TS_140201 IDCTG_CMD_TS
	%mapgui = newobject("CmdView_Gui", Feargui::TScommander, 3, 2, 244, 216);

	// Add our controls to the container
	//addToSet("CmdView_Container", %mapbg);
	addToSet("CmdView_Container", %mapgui);
	
	// Add the whole container to PlayGui
	addToSet(PlayGui, %hudContainer);

	// Init our map prefs	
	$pref::mapsensorrange = $CmdView::mapsensorrange;
	$pref::mapSensorTranslucent = $CmdView::mapSensorTranslucent;
	$pref::mapnames = $CmdView::mapnames;
	$pref::mapfilter = $CmdView::mapfilter;

	// Re-build the commandermap
	rebuildCommandMap();

	// Re-size and re-position
	CmdView::Resize();

	// We don't want it visible yet
	Control::setVisible(CmdView_Container, "False");

	// Now the objects are there
	$CmdView::Exist = "True";

	return;
}

// Triggered onGuiOpen
function CmdView::onGuiOpen(%gui)
{
	if(%gui == "playGui" && $CmdView::Active)
	{
		CmdView::PlayMode();
	}

	return;
}

// This is our Toggle Off function
function CmdView::PlayMode()
{
	// Make it un-visible
	Control::setVisible(CmdView_Container, "False");

	// Go to playmode
	remoteEval(2048, PlayMode);

	// CmdView is NOT active now
	$CmdView::Active = "False";

	return;
}

// This is our Toggle On function
function CmdView::CommandMode()
{
	if(isObject(CommandGui))
		deleteobject(CommandGui);

	// Make it visible
	Control::setVisible(CmdView_Container, True);

	// Go to CommandMode
	remoteEval(2048, CommandMode);

	// Force full bandwidth
	Schedule("remoteEval(2048, SCOM, -1);", $CmdView::Delay);

	// Turn off the cursor
	Schedule("CursorOff(mainwindow);", $CmdView::Delay);

	// CmdView IS active now
	$CmdView::Active = "True";

	return;
}

// The actual toggle function
function CmdView::Toggle()
{
	if($CmdView::Active)
	{
		// Go to PlayMode
		CmdView::PlayMode();
	}
	else
	{
		// Go to CommandMode
		CmdView::CommandMode();
	}
	
	return;
}

// The function to switch between large/small commander
function CmdView::Change()
{
	if($CmdView::Exist)
	{
		// Recreate Commander
		CmdView::Restore();

		// Go to CommandMode
		schedule("remoteEval(2048, CommandMode);", 0.5);
	}
	else
	{
		// Go to playmode
		remoteEval(2048, PlayMode);

		// Create CmdView
		schedule("CmdView::Create();", 0.5);
	}

	return;
}

// Re-size and re-position totally strange that I need this at all..
function CmdView::Resize()
{
	Control::SetPosition("CmdView_Gui", 3, 2);	
	Control::SetExtent("CmdView_Gui", 244, 216);

	return;
}

// Restore Original Commander
function CmdView::Restore()
{
	// Delete all traces of CmdView
	CmdView::Destroy();

	// Load a brand new CommandGui
	if(!isObject(CommandGui))
		loadObject("CommandGui", "gui\\command.gui");

	// Re-build the commandermap
	rebuildCommandMap();
	return;
}

// Delete all "CmdView_*" objects
function CmdView::Destroy()
{
	// Delete all objects
	HUD::Destroy("CmdView_");
	HUD::Destroy("CmdView_");

	// Now the objects are gone
	$CmdView::Exist = "False";

	return;
}