////////////////////////////////////////////////////////////
// File:	Rfinder.cs
// Version:	1.0
// Author:	Runar
// Credits:	Cowboy
// Info:	
//
//
////////////////////////////////////////////////////////////

// This is were we keep our bitmaps
$Viking::BMPdir = "Viking\\BMP\\";

////////////////////////////////////////////////////////////

Event::Attach(eventLoadPlayGui, RangeFinder::Create);
Event::Attach(eventExit, RangeFinder::Destroy);
Event::Attach(eventGuiOpen, RangeFinder::playGuiOpen);
Event::Attach(eventGuiClose, RangeFinder::playGuiClose);

////////////////////////////////////////////////////////////

function RangeFinder::Create()
{
	if($RangeFinder::Exist)
		return;

	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	RangeFinder::Destroy();

	%HudContainer=newObject("RF_Container", SimGui::Control, %x / 2 - 31, %y / 2 + 10, 63, 256);
	%HudBitmapCtrl=newObject("RF_Bitmap", FearGuiFormattedText, 0, 0, 63, 256);

	addToSet("RF_Container", %HudBitmapCtrl);
	addToSet(PlayGui, %HudContainer);

	$RangeFinder::Exist = "True";
}

function RangeFinder::Update()
{
	%itemId = getMountedItem(0);

	if(%itemId == 17)
	{
		control::setValue("RF_Bitmap", "<B0,0:"@$Viking::BMPdir@"GRF_"@RangeFinder::GetX()@".bmp>");
		control::setVisible("RF_Container", "True");
	}
	else if(%itemId == 19)
	{
		control::setValue("RF_Bitmap", "<B0,0:"@$Viking::BMPdir@"MRF_"@RangeFinder::GetX()@".bmp>");
		control::setVisible("RF_Container", "True");	}
	else
	{
		control::setVisible("RF_Container", "False");
	}

	schedule::add("RangeFinder::Update();", 1, "RangeFinder");
}

function RangeFinder::GetX()
{
	%x = getWord(Control::getExtent(playGui), 0);
	
	if(%x > 1024)
		return 1024;
	else
		return %x;
}

function RangeFinder::playGuiOpen(%gui)
{
	if(%gui == "playGui")
		RangeFinder::Update();

}

function RangeFinder::playGuiClose(%gui)
{
	if(%gui == "playGui")
		Schedule::Cancel("RangeFinder");
}

function RangeFinder::Destroy()
{
	HUD::Destroy("RF_");
	HUD::Destroy("RF_");
	$RangeFinder::Exist = "False";
}

