////////////////////////////////////////////////////////////
// File:	Support.cs
// Version	2.2
// Author:	Runar
// Credits:	Presto, BigBunny, Crunchy, Mr.Poop
// Info:	Different support functions.
//		New event handling from Mr.Poop!
//		Schedule functions are from Presto.
//		TargetClientByname is Crunchys. (I think..)
//		HUD::Destroy is from MentalTrouser. (who i
//		believe copied it from Labrat??)
//		
////////////////////////////////////////////////////////////


// Over-ride different Tribes functions we need to hook in to..
function onConnection(%message)
{
   	$dataFinished = false;

   	if(%message == "Accepted")
   	{
		Event::Trigger(eventConnectionAccepted);

		// Demo bug fix start
		deleteObject(ConsoleScheduler);
		newObject(ConsoleScheduler, SimConsoleScheduler);
		// Demo bug fix end

	      	resetSimTime();

		//execute the custom script
		if ($PCFG::Script != "")
		{
			exec($PCFG::Script);
		}

		resetPlayDelegate();
		remoteEval(2048, "SetCLInfo", $PCFG::SkinBase, $PCFG::RealName, $PCFG::EMail, $PCFG::Tribe, $PCFG::URL, $PCFG::Info, $pref::autoWaypoint, $pref::noEnterInvStation, $pref::messageMask);

		if ($Pref::PlayGameMode == "JOIN")
		{
			cursorOn(MainWindow);
			GuiLoadContentCtrl(MainWindow, "gui\\Loading.gui");
			renderCanvas(MainWindow);
		}
	}
   	else if(%message == "Rejected")
   	{
		Quickstart();
		$errorString = "Connection to server rejected:\n" @ $errorString;
		GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);

		Event::Trigger(eventConnectionRejected);

   	}
   	else
	{
		//startMainMenuScreen();
		Quickstart();

		if(%message == "Dropped")
		{
         		if($errorString == "")
            			$errorString = "Connection to server lost:\nServer went down.";
        		else
            			$errorString = "Connection to server lost:\n" @ $errorString;

			Event::Trigger(eventConnectionLost, $errorString);

       			GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
	   		schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
      		}
      		else if(%message == "TimedOut")
      		{
      			$errorString = "Connection to server timed out.";

			Event::Trigger(eventConnectionTimeout);

			GuiPushDialog(MainWindow, "gui\\MessageDialog.gui");
			schedule("Control::setValue(MessageDialogTextFormat, $errorString);", 0);
      		}
	}
}

function dataFinished()
{
   	// called on client when all the dynamic data has
   	// finished transfer.

	if ($cdMusic && !$pref::userCDOverride)
	{
		rbSetPlayMode (CD, 0);
		rbStop (CD);
	}

   	Control::setValue(ProgressText, "<jc><f0>Get ready to rock n' roll!");
   	Control::setValue(ProgressSlider, 0.9);

   	$dataFinished = true;
   	remoteEval(2048, dataFinished);

	Event::Trigger(eventConnected);

   	echo("Flushing Texture Cache");
   	flushTextureCache();
}

function loadPlayGui()
{
	if(File::FindFirst("play.gui") != "")
	{
		GuiLoadContentCtrl(MainWindow, "play.gui");
	}
	else
	{
		GuiLoadContentCtrl(MainWindow, "gui\\play.gui");
	}

	if($PlayGUI::isLoaded == 0)
	{
		Event::Trigger(eventLoadPlayGui);
     		$PlayGUI::isLoaded = 1;
	}
}

function PlayGui::onOpen()
{
	Event::Trigger(eventGuiOpen, PlayGui);
}
function PlayGui::onClose()
{
	Event::Trigger(eventGuiClose, PlayGui);
}

function CommandGui::onOpen()
{
	Event::Trigger(eventGuiOpen, CommandGui);
}

function CommandGui::onClose()
{
	Event::Trigger(eventGuiClose, CommandGui);
}


function remoteMissionChangeNotify(%serverManagerId, %nextMission)
{
   if(%serverManagerId == 2048)
   {
	Event::Trigger(eventChangeMission, %nextMission);
	cls();
	echo("Server mission complete - changing to mission: ", %nextMission);
	echo("Flushing Texture Cache");
	flushTextureCache();
	schedule("purgeResources(true);", 3);
   }
}

// Support function to get MissionInfo on connect/change
function remoteMInfo(%server, %missionName)
{
	if(%server == 2048)
	{
		%file = "missions\\" @ %missionName @ ".dsc";
		$MDESC::Type = "";
		$MDESC::Text = "";

		if(File::findFirst(%file) != "")
			exec(%file);

		$ServerMission = %missionName;
		$ServerText = $MDESC::Text;
		$ServerMissionType = $MDESC::Type;

		if(isObject(LobbyGui))
			LobbyGui::onOpen();  // update lobby screen text.

		Event::Trigger(eventMissionInfo, %server, $ServerMission, $ServerMissionType);
	}
}

function onExit()
{
	Event::Trigger(eventExit);

   	if(isObject(playGui))
      	storeObject(playGui, "config\\play.gui");

   	saveActionMap("config\\config.cs", "actionMap.sae", "playMap.sae", "pdaMap.sae");

	//update the video mode - since it can be changed with alt-enter
	$pref::VideoFullScreen = isFullScreenMode(MainWindow);

   	checkMasterTranslation();
	echo("exporting pref::* to prefs.cs");
   	export("pref::*", "config\\ClientPrefs.cs", False);
   	export("Server::*", "config\\ServerPrefs.cs", False);
   	export("pref::lastMission", "config\\ServerPrefs.cs", True);
   	BanList::export("config\\banlist.cs");
}

function onClientGhostAlwaysDone()
{
	// preload the commander gui if it's not already loaded
	if(!isObject("commandGui"))
		loadObject("commandGui", "gui\\command.gui");

	rebuildCommandMap();
	flushTextureCache();
	purgeResources(true);
	remoteEval(2048, "CGADone");

	//echo("Registering Static Textures");
	//RegisterStaticTextures(MainWindow);

	Event::Trigger(eventStartGame);
}

function EndGame()
{
	Event::Trigger(eventEndGame);

	$ConnectedToServer = FALSE;
	setCursor(MainWindow, "Cur_Arrow.bmp");
	disconnect();

	if($SinglePlayer)
		TrainingEndGameCallback();

	if($pref::userCDOverride == False)
	{
		rbSetPlayMode (CD, 0);
		rbStop (CD);
		$cdTrack = "";
	}

	$recordDemo = FALSE;

	startMainMenuScreen();
	deleteServer();
	QuickStart();
	deleteObject(ConsoleScheduler);
	newObject(ConsoleScheduler, SimConsoleScheduler);

	if($quitOnDisconnect)
		schedule("quit();", 0);
}

function onPlaybackFinished()
{
	Event::Trigger(eventEndGame);

	// called when a recording is done with playback.
	cursorOn(MainWindow);
	GuiLoadContentCtrl(MainWindow, "gui\\Recordings.gui");
}

function ELM()
{
	if($playingDemo)
	{
		Event::Trigger(eventEndGame);

		setCursor(MainWindow, "Cur_Arrow.bmp");
		disconnect();
		startMainMenuScreen();
		GuiLoadContentCtrl(MainWindow, "gui\\Recordings.gui");
	}
	else
	{
		$InLobbyMode = true;
		GuiLoadContentCtrl(MainWindow, "gui\\Lobby.gui");
		CursorOn(MainWindow);
	}
}

function onTeamAdd(%team, %name)
{
	Event::Trigger(eventOnTeamAdd, %team, %name);
}

function onClientJoin(%client)
{
	Event::Trigger(eventClientJoin, %client);
}

function onClientDrop(%client)
{
	Event::Trigger(eventClientDrop, %client);
}

function onClientChangeTeam(%client, %team)
{
	Event::Trigger(eventClientChangeTeam, %client, %team);
}

// Straight rip-off from Presto's Schedule.cs, respect Dude!!
function Schedule::Add(%eval, %time, %tag)
{
	if(%tag == "")
		%tag = %eval;	// Use function as tag if none provided.

	$Schedule::ID[%tag]++;
	$Schedule::eval[%tag] = %eval;
	schedule("Schedule::Exec(\""@escapestring(%tag)@"\", "@$Schedule::ID[%tag]@");", %time);
}

function Schedule::Exec(%tag, %id)
{
	if($Schedule::ID[%tag] != %id)
		return;

	%eval = $Schedule::eval[%tag];
	Schedule::Cancel(%tag);
	eval(%eval);
}

function Schedule::Cancel(%tag)
{
	$Schedule::ID[%tag]++;
	$Schedule::eval[%tag] = "";
}

function HUD::setVisibility(%object, %visible)
{
	control::setVisible(%object, %visible);
	return;
}

// This is copied from MentalTrousers web-site.
function HUD::Destroy(%hudstring)
{
	%ngs = nameToId(NamedGuiSet);
	%len = Group::objectCount(%ngs);
	for(%i = 0; %i < %len; %i++)
	{
		%obj = Group::getObject(%ngs, %i);
		%objectName=Object::getName(%obj);
  
  		if(String::findSubStr(%objectname, %hudstring) != -1 )
			deleteObject(%obj);
	}
	return;
}

function getTeamByClientName(%client)
{
	%teamId = Client::GetTeam(getClientByName(%client));
	return %teamId;
}

function targetClientById(%clientId, %msg)
{
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
	return;
}

// Rip-off from |HH|Crunchy, respect!!
function targetClientByName(%name, %msg)
{
	%clientId = getClientByName(%name);
	remoteEval(2048, "IssueTargCommand", 0, %msg, %clientID - 2048, getManagerId());
}


//Event Queing and Triggering by Mr.Poop
function Event::Attach(%event, %returnFunction)
{
	if(%event != "" && %returnfunction != "")
	{
		for(%i = 1; %i <= $Event::[%event@"Num"]; %i++)
		{
			if($Event::[%event@%i] == %returnFunction)
			{
				echo("Script Already Registered: "@%returnFunction);
				return;
			}
		}

		$Event::[%event@"Num"]++;
		$Event::[%event@%i] = %returnfunction;
	}
}

function Event::Trigger(%event, %p1, %p2, %p3, %p4, %p5, %p6, %p7, %p8, %p9, %p10)
{
	for(%i = 1; %i <= $Event::[%event@"Num"]; %i++)
	{
		%tmp = eval($Event::[%event@%i]@"(%p1,%p2,%p3,%p4,%p5,%p6,%p7,%p8,%p9,%p10);" );

		if(%return != "FALSE")
		{
			%return = %tmp;
		}
	}

	return %return;
}

function Viking::ScreenSize(%val)
{
	if(%val == "x")
	{
		return getWord(Control::getExtent(playGui), 0);
	}
	else
	{
		return getWord(Control::getExtent(playGui), 1);
	}
}

function Viking::Sense(%sense)
{
	if(Client::getMouseXaxisFlip("playMap.sae"))
	{
		editActionmap("playmap.sae");
		bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %sense);
	}
	else
	{
		editActionmap("playmap.sae");
		bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sense);
	}

	if(Client::getMouseYaxisFlip("playMap.sae"))
	{
		editActionmap("playmap.sae");
		bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %sense);
	}
	else
	{
		editActionmap("playmap.sae");
		bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sense);
	}
}
