////////////////////////////////////////////////////////////
// File:	TV.cs
// Version:	1.3
// Author:	Runar
// Credits:	Freaky, Gold for beta-tests.
// Info:	Observe your flag-carrier in fullscreen with
//		a keypress.
//
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

$TV::Key[10] = a;
$TV::Key[11] = b;
$TV::Key[12] = c;
$TV::Key[13] = d;
$TV::Key[14] = e;
$TV::Key[15] = f;
$TV::Key[16] = g;
$TV::Key[17] = h;
$TV::Key[18] = i;
$TV::Key[19] = j;
$TV::Key[20] = k;

Event::Attach(eventFlagTaken, TV::Flag::Taken);

function TV::Menu()
{
	%menu = "<JL><F1>TV Select player:\n";
	%count = 0;

	// New keymap
	NewActionMap("TV.sae");

	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
		if($TT::Client::Name[%clientId] != "" && $TT::Client::Team[%clientId] == $TT::Client::Team[$myId])
		{
			%count++;

			if(%count > 9)
				%key = $TV::Key[%count];
			else
				%key = %count;
				
			%menu = %menu @ "\n<JL><F0>" @ %key @ " : <F2>" @ $TT::Client::Name[%clientId];

			bindCommand(keyboard0, make, %key, TO, "TV::Select(" @ %clientId @ ");");
			bindCommand(keyboard0, break, %key, TO, "TV::DeActivate();");
		}
	}

	// Load keymap
	PushActionMap("TV.sae");

	// CP the menu
	remoteCP(2048, %menu, 999);
}

function TV::Select(%clientId)
{
	// Clear CP
	remoteCP(2048, "", 0.1);

	$TV::Selected = %clientId;
	TV::Activate($TV::Selected);
}

function TV::Selected()
{
	TV::Activate($TV::Selected);
}

function TV::Carrier()
{
	TV::Activate($TV::FlagCarrier);
}

function TV::Activate(%clientId)
{
	// Can't obs if there's no carrier..
	if($TT::Client::Name[%clientId] == "")
	{
		$TV::Active = "False";
		remoteBP(2048, "<JC><F0>Illegal clientId, unable to observe!", 2);
		return;
	}

	// Delete the entire CommandGui
	if(isObject("CommandGui"))
		renameObject("CommandGui", "_CommandGui");

	// Add CMDObserve if it isn't there..
	if(!isObject("PlayGui/ObsTV"))
	{
		addToSet(PlayGui, newObject("ObsTV", FearGui::CMDObserve, 0, 0, 1, 1));
	}

	// Go to CommandMode
	remoteEval(2048, CommandMode);

	// Turn off the cursor
	Schedule("CursorOff(mainwindow);", 0.3);

	// Enable observer mode
	Client::ToggleCmdObserver("True");

	// Observe flag-carrier
	Client::cmdObservePlayer(%clientId);

	// Show who we are obsing
	remoteBP(2048, "<JC><F2>Observing: <F1>" @ $TT::Client::Name[%clientId], 999);

	// Just to make sure..
	$TV::Active = "True";
}

function TV::DeActivate()
{
	// Unload keymap
	PopActionMap("TV.sae");

	Client::ToggleCmdObserver("False");

	remoteEval(2048, PlayMode);

	if($TV::Active)
		deleteObject("PlayGui/ObsTV");

	renameObject("_CommandGui", "CommandGui");

	remoteBP(2048, "", 0.1);

	$TV::Active = "False";
}

function TV::Flag::Taken(%flagId, %clientId, %client)
{
	if(%flagId != $TT::Client::Team[$myId])
		$TV::FlagCarrier = %clientId;
}
