////////////////////////////////////////////////////////////
// File:	TurretHud.cs
// Version:	0.1 Beta
// Author:	Runar
// Credits:	
// Info:	Shows turrets and items status.
//		Should work with Stripped also.
//
////////////////////////////////////////////////////////////
// Don't touch this line
editActionmap("playmap.sae");

// Keybind: Toggle the TurretHud on/off
bindCommand(keyboard0, make, "f6", TO, "TurretHud::Toggle();");
bindCommand(keyboard0, break, "f6", TO, "");


////////////////////////////////////////////////////////////
Event::Attach(eventLoadPlayGui, TurretHud::Create);
Event::Attach(eventPlayGuiCreated, TurretHud::Create);
Event::Attach(eventExit, TurretHud::Destroy);
Event::Attach(eventGuiOpen, TurretHud::onGuiOpen);

////////////////////////////////////////////////////////////

function TurretHud::Create()
{
	if($TurretHud::Exist)
		return;

	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	TurretHud::Destroy();

	%HudContainer=newObject("TurretHud_Container", SimGui::Control, 0, %y / 2 , 256, 256);
	%HudItemCtrl=newObject("TurretHud_ItemCtrl", FearGui::CommandItemCtrl, 0, 0, 128, 256);
	%HudTurretCtrl=newObject("TurretHud_TurretCtrl", FearGui::CommandTurretCtrl, 0, 129, 128, 256);

	addToSet("TurretHud_Container", %HudItemCtrl);
	addToSet("TurretHud_Container", %HudTurretCtrl);
	addToSet(PlayGui, %HudContainer);

	$TurretHud::Exist = "True";

	// We don't want it visible yet
	Control::setVisible(TurretHud_Container, "False");
}

function TurretHud::Toggle()
{
	if(Control::GetVisible("TurretHud_Container"))
	{
		// Make it not visible
		Control::SetVisible("TurretHud_Container", "False");

		// Return to normal playmode
		remoteEval(2048, PlayMode);

		// Restore CommandGui
		if(isObject("_THudCommandGui"))
			renameObject("_THudCommandGui", "CommandGui");
	}
	else
	{
		// Rename CommandGui to force playscreen
		if(isObject("CommandGui"))
			renameObject("CommandGui", "_THudCommandGui");

		// Go to CommandMode
		remoteEval(2048, CommandMode);

		// Force full bandwidth
		RemoteEval(2048, "scom", -1);

		// Turn off the cursor
		Schedule("CursorOff(mainwindow);", 0.3);

		// Make it visible
		Control::SetVisible("TurretHud_Container", "True");

		// Align the ItemCtrl with the TurretCtrl
		Control::SetPosition("TurretHud_TurretCtrl", 0, getWord(Control::GetExtent("TurretHud_ItemCtrl"), 1));
	}
}

function TurretHud::onGuiOpen(%gui)
{
	if(%gui == "playGui")
	{
		// Make it not visible
		Control::SetVisible("TurretHud_Container", "False");

		// Return to normal playmode
		remoteEval(2048, PlayMode);

		// Restore CommandGui
		if(isObject("_THudCommandGui"))
			renameObject("_THudCommandGui", "CommandGui");
	}
}

function TurretHud::Destroy()
{
	HUD::Destroy("TurretHud_");
	HUD::Destroy("TurretHud_");
	$TurretHud::Exist = "False";
}

function Viking::ScreenSize(%val)
{
	if(%val == "x")
	{
		return getWord(Control::getExtent(playGui), 0);
	}
	else
	{
		return getWord(Control::getExtent(playGui), 1);
	}
}
