
//================================================================
//Inferno
//================================================================
$AutoUse[Inferno] = False;
//================================================================
$InvList[Inferno] = 1;
$InvList[InfernoAmmo] = 1;
$RemoteInvList[Inferno] = 1;
$RemoteInvList[InfernoAmmo] = 1;
//================================================================
$DamageScale[larmor, $InfernoDamageType] = 1.0;
$DamageScale[lfemale, $InfernoDamageType] = 1.0;
$DamageScale[marmor, $InfernoDamageType] = 1.0;
$DamageScale[mfemale, $InfernoDamageType] = 1.0;
$DamageScale[harmor, $InfernoDamageType] = 1.0;

$ItemMax[larmor, Inferno] = 1;
$ItemMax[lfemale, Inferno] = 1;
$ItemMax[marmor, Inferno] = 1;
$ItemMax[mfemale, Inferno] = 1;
$ItemMax[harmor, Inferno] = 1;

$ItemMax[larmor, InfernoAmmo] = 150;
$ItemMax[lfemale, InfernoAmmo] = 150;
$ItemMax[marmor, InfernoAmmo] = 350;
$ItemMax[mfemale, InfernoAmmo] = 350;
$ItemMax[harmor, InfernoAmmo] = 500;
//================================================================
SoundData SoundWhizInferno
{
   wavFileName = "whiz_inferno.wav";
   profile = Profile3dNear;
};
SoundData InfernoExplosion
{
   wavFileName = "exp_inferno.wav";
   profile = Profile3dMedium;
};
//================================================================
ExplosionData InfernoExp
{
   shapeName = "plasmaex.dts";
   soundId   = InfernoExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 10.0;

   timeScale = 10.0;

   timeZero = 0.150;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};
//================================================================
GrenadeData Infernoproj
{
   bulletShapeName    = "breath.dts";
   explosionTag       = InfernoExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.25;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.75;
   damageType         = $InfernoDamageType;

   explosionRadius    = 5.0;
   kickBackStrength   = 0.0;
   maxLevelFlightDist = 125;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 0.5; // grenade time live after contact
   projSpecialTime    = 0.09;
   inheritedVelocityScale = 0.5;

   smokeName              = "plasmaex.dts";
		soundId = SoundWhizInferno;
};
//================================================================
ItemData InfernoAmmo
{
        description = "Napalm Gel";
        className = "Ammo";
        shapeFile = "plasammo";
   heading = "xAmmunition";
        shadowDetailMask = 4;
        price = 0;
};


ItemImageData InfernoImage 
{ 
        shapeFile = "wpn_Inferno";
        mountPoint = 0;
        weaponType = 0;
        ammoType = InfernoAmmo;
        projectileType = Infernoproj;
        accuFire = false;
        reloadTime = 0.0;
        fireTime = 0.07;
        lightType = 3;
        lightRadius = 3;
        lightTime = 1;
        lightColor = { 3.0, 2.0, 0.0 };
        sfxFire = SoundWhizInferno;
        sfxActivate = SoundPickUpWeapon;	
};
ItemData Inferno
{ 
        description = "Inferno";
        className = "Weapon";
        shapeFile = "wpn_Inferno";
        hudIcon = "Inferno";
        heading = "bWeapons";
        shadowDetailMask = 4;
        imageType = InfernoImage;
        price = 0;
        showWeaponBar = true;
  // validateShape = true;
  // validateMaterials = true;
};

//================================================================
//echo("Inferno Loaded");