////////////////////////////////////////////////////////////
// File:	Active.cs
// Version:	3.2
// Author:	Runar/Freaky	
// Credits:	Freaky
// Info:	Active client support
//		only for fstat servers.
//
// History:	3.2 Using TeamTrack a bit better on hitEvent
//		
//
////////////////////////////////////////////////////////////

// Damagetypes. For kill/death info type scripts
$DamageType = "Suicide";
$DamageType[-1] = "Impact";
$DamageType[0] = "Landing";
$DamageType[1] = "Chaingun";
$DamageType[2] = "Turret";
$DamageType[3] = "Plasma Gun";
$DamageType[4] = "Disc Launcher";
$DamageType[5] = "Explosives";
$DamageType[6] = "Laser Rifle";
$DamageType[7] = "Mortar Gun";
$DamageType[8] = "Blaster";
$DamageType[9] = "ELF Gun";
$DamageType[10] = "Crushed";
$DamageType[11] = "Debris";
$DamageType[12] = "Missile";
$DamageType[13] = "Explosives";

////////////////////////////////////////////////////////////

Event::Attach(eventConnectionAccepted, Activemode::Init);
Event::Attach(eventEndGame, Activemode::Reset);
Event::Attach(eventConnectionLost, Activemode::Reset);
Event::Attach(eventConnectionTimeout, Activemode::Reset);
Event::Attach(eventConnectionRejected, Activemode::Reset);

////////////////////////////////////////////////////////////

// Always assume it's not an Fstat server
$Activemode = False;

function Activemode::Init()
{
       // Always assume it's not an Fstat server
       $Activemode = False;
       
       // Request active mode on the server
       remoteEval(2048, ActiveMode, True, "Viking-Pack 3.3");
}

function Activemode::Update()
{
	// Double check...
	if($Activemode)
	{
		// Get the current score
		remoteEval(2048, ScoreUpdate);
	
		// Get the current Flag status
		remoteEval(2048, UpdateFlagstatus);
	
		// Get the missioninfo
		remoteEval(2048, GetMissioninfo);
		
		// Get object-list
		remoteeval(2048, Getobjectlist);
	}
}

function ActiveMode::Reset()
{
	$ActiveMode = "False";
}

// Answer back (Remoteevals from the server)
function remoteActiceMove_Result(%serverId, %mode)
{
	if(%serverId != 2048)
   		return;

	$Activemode = %mode;
	
	if($Activemode)
	{
		echo("Fstat Active Mode: Enabled");
		Activemode::Update();
	}
}

// Duplicate function, without the typo :)
function remoteActiveMode_Result(%serverId, %mode)
{
	if(%serverId != 2048)
   		return;

	$Activemode = %mode;
	
	if($Activemode)
	{
		echo("Fstat Active Mode: Enabled");
		Activemode::Update();
	}
}

// 0 = Exit, 1 = Inventory, 2 = Remote-Inv 
function remoteStationUpdate(%serverId, %station)
{
	if(%serverId != 2048)
   		return;

	// We need to wait a second, since we get the station access on/off before the gui ;)
	if(%station == 0)
	{
		echo("Station Exit, type = " @ %station );		
     		Event::Trigger(eventExitStation);
	}
	else if(%station == 1)
	{
		echo("Station Enter, type = " @ %station );
		Event::Trigger(eventEnterStation, %station, "True", "True");
	}
	else if(%station == 2)
	{
		echo("Station Enter, type = " @ %station );
		Event::Trigger(eventEnterStation, %station, "False", "False");
	}
}

function remoteFlagTrackUpdate(%serverId, %flag, %flagId, %clientId, %clientteam, %type)
{
	if(%serverId != 2048)
   		return;
  	
   	// Here's the different Flag-events from the server	
	if(%type == "GRAB")
		Event::Trigger(eventFlagTaken, %flagId, %clientId, client::getname(%clientId));

	else if(%type == "DROP")
		Event::Trigger(eventFlagDropped, %flagId, %clientId, client::getname(%clientId));
				 
	else if(%type == "CAPTURE")
		Event::Trigger(eventFlagCaptured, %flagId, %clientId, client::getname(%clientId));
		
	else if(%type == "RETURN" || %type == "LEFT" || %type == "TIMEOUT")
		Event::Trigger(eventFlagReturned, %flagId, %clientId, client::getname(%clientId));
}

function remoteScoreUpdate(%serverId, %teamId, %score)
{
	if(%serverId != 2048)
		return;
		
	// Set the score
	$TT::Team::Score[%teamId] = %score;
   	
   	// Update the HUD
   	FlagHUD::Update();
}

function remoteFlagstatus(%serverId, %flagId, %type, %team, %clientid, %time)
{
	if(%serverId != 2048)
		return;

	if(%type == "HOME")
		$TT:Flag::Location[%flagId] = "Home";
		
	else if(%type == "DROPPED")
	{
        	$TT::Flag::Location[%flagId] = "Dropped";
        	$TT::Flag::Timer[%flagId] = "True";
        	$TT::Flag::Time[%flagId] = %time;
		TT::Flag::Timer(%flagId);
	}

	else if(%type == "CARRIED")
		$TT::Flag::Location[%flagId] = $TT::Client::Name[%clientId];

	TrakHUD::Update();
}

function remotePlayerTracking(%serverId, %type)
{
	if(%serverId != 2048)
		return;

	if(%type == 0)
	{
		Event::Trigger(eventRespawn);
		drop("blaster");
		use("Disc Launcher");
	}
}

function remoteKillUpdate(%serverId, %victimId, %killerId, %weapon)
{
	Event::Trigger(eventKillTrak, %serverId, %victimId, %killerId, $DamageType[%weapon]);
}

function remoteHitReport(%serverId, %victimId, %weaponId)
{
	if($TT::Client::Team[%victimId] != $TT::Client::Team[$myId])
	{
		Reticle::Active("True");
		Schedule("Reticle::Active();", 0.3);
		remoteTP(2048, "<JC><F2>You just hit: <F0>" @ $TT::Client::Name[%victimId], 3);
		localMessage(bhit);
	}
}

function remoteMaHitReport(%serverId, %distance, %targetId)
{
	if(%serverId != 2048)
		return;

	// Take screenshot if enabled
	if($Viking::MAscreen)
		schedule("screenShot(MainWindow);", $Viking::ScreenDelay);
}

function remoteReceiveMessage(%serverId, %count, %item, %itemId)
{
	Event::Trigger(eventReceivedItem, %item, %itemId);
}

// Functions below are not used, they are only decleared to avoid invalid calls
function remoteNewMission(%serverid)
{
	//ObjHUD::remoteNewMission(%serverid);
}

function remoteSwitchUpdate(%serverId, %switchId, %teamId , %client, %oldteamId)
{
	//ObjHUD::remoteSwitchUpdate(%serverId, %switchId, %teamId , %client, %oldteamId);
}

function remoteFRFlagUpdate(%serverId, %flagId, %teamId, %client, %oldteamId, %type, %timeleft)
{
	//ObjHUD::remoteFRFlagUpdate(%serverId, %flagId, %teamId, %client, %oldteamId, %type, %timeleft);
}

function remoteObjectUpdate(%ServerId, %objectId, %teamId, %client)
{
	//ObjHUD::remoteObjectUpdate(%ServerId, %objectId, %teamId, %client);
}

function remoteMissionInfo(%serverId, %missionName, %missionType, %scoreLimit, %timeLimit)
{
	//ObjHUD::remoteMissionInfo(%serverId, %missionName, %missionType, %scoreLimit, %timeLimit);
}

function remoteObjectHolder(%serverId, %objectId, %teamId)
{
	//ObjHUD::remoteObjectHolder(%serverId, %objectId, %teamId);
}

function remoteNewObject(%serverId, %objectId, %objectType, %objectName)
{
	//ObjHUD::remoteNewObject(%serverId, %objectId, %objectType, %objectName);
}
