////////////////////////////////////////////////////////////
// File:	FlagPopUp.cs
// Version:	3.2
// Author:	Runar
// Credits:	
// Info:	Pop-up notices for flag events.
//
// History: 	3.2 Initial version
//
////////////////////////////////////////////////////////////

Event::Attach(eventFlagTaken, FlagPOP::FlagTaken);
Event::Attach(eventFlagDropped, FlagPOP::FlagDropped);
Event::Attach(eventFlagReturned, FlagPOP::FlagReturned);
Event::Attach(eventFlagCaptured, FlagPOP::FlagCaptured);

function FlagPOP::FlagTaken(%flagId, %clientId, %client)
{
	if(%flagId == $TT::Client::Team[$myId])
		remoteCP(2048, "<JC><F1>YOUR<F2> flag was grabbed by <F0>" @ $TT::Client::Name[%clientId], 3);
	else
		remoteCP(2048, "<JC><F0>ENEMY<F2> flag was grabbed by <F1>" @ $TT::Client::Name[%clientId], 3);
}

function FlagPOP::FlagDropped(%flagId, %clientId, %client)
{
	if(%flagId == $TT::Client::Team[$myId])
		remoteCP(2048, "<JC><F1>YOUR<F2> flag was dropped by <F0>" @ $TT::Client::Name[%clientId], 3);
	else
		remoteCP(2048, "<JC><F0>ENEMY<F2> flag was dropped by <F1>" @ $TT::Client::Name[%clientId], 3);
}

function FlagPOP::FlagReturned(%flagId, %clientId, %client)
{
	if(%clientId == 0)
	{
		if(%flagId == $TT::Client::Team[$myId])
			remoteCP(2048, "<JC><F1>YOUR<F2> flag was returned.", 3);
		else
			remoteCP(2048, "<JC><F0>ENEMY<F2> flag was returned.", 3);
	}
	else
	{
		if(%flagId == $TT::Client::Team[$myId])
			remoteCP(2048, "<JC><F1>YOUR<F2> flag was returned by <F1>" @ $TT::Client::Name[%clientId], 3);
		else
			remoteCP(2048, "<JC><F0>ENEMY<F2> flag was returned by <F0>" @ $TT::Client::Name[%clientId], 3);
	}
}

function FlagPOP::FlagCaptured(%flagId, %clientId, %client)
{
	if(%flagId == $TT::Client::Team[$myId])
		remoteCP(2048, "<JC><F1>YOUR<F2> flag was captured by <F0>" @ $TT::Client::Name[%clientId], 3);
	else
		remoteCP(2048, "<JC><F0>ENEMY<F2> flag was captured by <F1>" @ $TT::Client::Name[%clientId], 3);
}