////////////////////////////////////////////////////////////
// File:	Incoming.cs
// Version:	1.1
// Author:	Runar
// Credits:	Writer for the original idea
// Info:	Incoming Enemy help
//
//
////////////////////////////////////////////////////////////

// DONT TOUCH THIS LINE
EditActionMap("PlayMap.sae");

// This is the key to activate "Incoming enemy!"
bindCommand(keyboard0, make, "NumpadEnter", TO, "Incoming::Activate();");
bindCommand(keyboard0, break, "NumpadEnter", TO, "");

function Incoming::Activate()
{
	$Incoming::Type = "";
	$Incoming::Direction = "";
	$Incoming::Number = 0;

	NewActionMap("Incoming.sae");
	bindCommand(keyboard0, make, "numpad-", TO, "Incoming::Type(\"Light(s)\");");
	bindCommand(keyboard0, make, "numpad+", TO, "Incoming::Type(\"Heavy(s)\");");

	// Some prefer this
	//bindCommand(keyboard0, make, "numpad1", TO, "Incoming::Direction(\"South-West\");");
	//bindCommand(keyboard0, make, "numpad2", TO, "Incoming::Direction(\"South\");");
	//bindCommand(keyboard0, make, "numpad3", TO, "Incoming::Direction(\"South-East\");");
	//bindCommand(keyboard0, make, "numpad4", TO, "Incoming::Direction(\"West\");");
	//bindCommand(keyboard0, make, "numpad5", TO, "Incoming::Direction(\"Below\");");
	//bindCommand(keyboard0, make, "numpad6", TO, "Incoming::Direction(\"East\");");
	//bindCommand(keyboard0, make, "numpad7", TO, "Incoming::Direction(\"North-West\");");
	//bindCommand(keyboard0, make, "numpad8", TO, "Incoming::Direction(\"North\");");
	//bindCommand(keyboard0, make, "numpad9", TO, "Incoming::Direction(\"North-East\");");


	// Some may prefer directions
	bindCommand(keyboard0, make, "numpad1", TO, "Incoming::Direction(\"Back-Left\");");
	bindCommand(keyboard0, make, "numpad2", TO, "Incoming::Direction(\"Behind\");");
	bindCommand(keyboard0, make, "numpad3", TO, "Incoming::Direction(\"Back-Right\");");
	bindCommand(keyboard0, make, "numpad4", TO, "Incoming::Direction(\"Left\");");
	bindCommand(keyboard0, make, "numpad5", TO, "Incoming::Direction(\"Below\");");
	bindCommand(keyboard0, make, "numpad6", TO, "Incoming::Direction(\"Right\");");
	bindCommand(keyboard0, make, "numpad7", TO, "Incoming::Direction(\"Front-Left\");");
	bindCommand(keyboard0, make, "numpad8", TO, "Incoming::Direction(\"Front\");");
	bindCommand(keyboard0, make, "numpad9", TO, "Incoming::Direction(\"Front-Right\");");


	PushActionMap("Incoming.sae");
	Incoming::PopUp();
}

function Incoming::Type(%Type)
{
	$Incoming::Type = %Type;
	$Incoming::Number++;
	Incoming::PopUp();
}

function Incoming::Direction(%Direction)
{
	$Incoming::Direction = %Direction;
	Incoming::PopUp();
}

function Incoming::PopUp()
{
	Schedule::Cancel("Incoming");
	remoteBP(2048, "<JC><F3>Use your numpad for directions, + for Lights and - for Heavys.\nPress multiple times for the number of incoming enemies\n\n<F1>" @ $Incoming::Number @ "<F2> incoming <F1>" @ $Incoming::Type @ "<F2> from the <F1>" @ $Incoming::Direction @ "\n", 3);
	Schedule::Add("Incoming::Say();", 2, "Incoming");
}

function Incoming::Say()
{
	PopActionMap("Incoming.sae");

	if($Incoming::Direction == "")
		return;

	if($Incoming::Number == 0)
	{
		$Incoming::Number = 1;
		$Incoming::Type = "enemy";
	}

	say(1, "ll " @ $Incoming::Number @ " Incoming " @ $Incoming::Type @ " from the " @ $Incoming::Direction @ " ll ~wincom2");
}
