////////////////////////////////////////////////////////////
// File:	PingHUD.cs
// Version:	4.0
// Author:	Runar
// Credits:	
// Info:	Neato little Ping and FPS hud
//
////////////////////////////////////////////////////////////

$PingHUD::Exist = "False";

Event::Attach(eventLoadPlayGui, PingHUD::Create);
Event::Attach(eventGuiOpen, PingHUD::playGuiOpen);
Event::Attach(eventGuiClose, PingHUD::playGuiClose);
Event::Attach(eventExit, PingHUD::Destroy);

////////////////////////////////////////////////////////////

// Create HUD, if exists Update
function PingHUD::Create()
{
	if($PingHUD::Exist)
	{
		return;
	}

	// Just to make sure we delete any stale objects
	PingHUD::Destroy();

	// Calculate the position with the chathud
	%xp = getWord(Control::GetPosition("ChatHudBG_Container"), 0);
	%yp = getWord(Control::GetPosition("ChatHudBG_Container"), 1);
	%xs = getWord(Control::GetExtent("ChatHudBG_Container"), 0);
	%ys = getWord(Control::GetExtent("ChatHudBG_Container"), 1);
	%x = %xp + %xs - 45;
	%y = %yp;

	// Screen resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Make sure we don't double it!
	$PingHUD::Exist = "True";

	// Here's the container
	%hudContainer=newObject("PingHUD_Container", SimGui::Control, %x - 260, 5, 64, 30);

	// Here's the new blue background
	%hudBG=newObject("PingHUD_BG", FearGuiFormattedText, 0, 0, 64, 28);

	// Here's text object
	%hudFPS=newObject("PingHUD_FPS", FearGuiFormattedText, 41, -3, 24, 13);
	%hudPing=newObject("PingHUD_Ping", FearGuiFormattedText, 41, 12, 24, 13);

	// Add text to container
	addToSet(%hudContainer, %hudBG);
	addToSet(%hudContainer, %hudFPS);
	addToSet(%hudContainer, %hudPing);
	
	// Add the container to PlayGui
	addToSet(PlayGui, %hudContainer);

	// Add the blue bitmap
	control::setValue("PingHUD_BG", "<B0,0:"@$Viking::BMPdir@"PingHudBG.bmp>");

	PingHUD::Update();
}

function PingHUD::Update()
{
	%fps = floor($ConsoleWorld::FrameRate);

	Control::setValue("PingHUD_FPS", "<F2>" @ %fps);

	remoteEval(2048, eval, PingResponse, getsimtime());
	Schedule::Add("PingHUD::Update();", 1, "PingHUD");
}

function remotePingResponse(%client, %time)
{
	%ping = floor((getsimtime() - %time) * 500);

	$PingHud::Ping = $PingHud::Ping + %ping;
	$PingHud::Count++;

	if($PingHud::Count == 5)
	{
		%ping = floor($PingHud::Ping / 5);

		Control::setValue("PingHUD_Ping", "<F2>" @ %ping);

		$PingHud::Count = 0;
		$PingHud::Ping = 0;
	}
}

function PingHUD::playGuiOpen(%gui)
{
	if(%gui == "playGui")
		PingHUD::Update();

}

function PingHUD::playGuiClose(%gui)
{
	if(%gui == "playGui")
		Schedule::Cancel("PingHUD");

}

function PingHUD::Destroy()
{
	HUD::Destroy("PingHUD_");
	HUD::Destroy("PingHUD_");
	$PingHUD::Exist = "False";
}

// Tribes function override
function remoteSetTime(%serverId, %time)
{
	if(%serverId != 2048)
		return;

	setHudTimer(%time);
		
	Event::Trigger(eventUpdateTime, Time::GetMinutes((%time + 1) * -1), Time::GetSeconds((%time + 1) * -1));
}

