////////////////////////////////////////////////////////////
// File:	Reticle.cs
// Version:	3.2
// Author:	Runar
// Credits:	Cowboy
// Info:	
//
//
////////////////////////////////////////////////////////////

// This is were we keep our bitmaps
$Viking::BMPdir = "Viking\\BMP\\";

if($pref::ReticleIndex == "")
	$pref::ReticleIndex = 0;

$Reticle[0] = 11;
$Reticle[1] = 13;
$Reticle[2] = 15;
$Reticle[3] = 17;
$Reticle[4] = 19;
$Reticle[5] = 21;
$Reticle[6] = 22;
$Reticle[7] = 23;
$Reticle[8] = 24;
$Reticle[9] = 25;
$Reticle[10] = 0;
$Reticle[11] = 1;

////////////////////////////////////////////////////////////

Event::Attach(eventLoadPlayGui, Reticle::Create);
Event::Attach(eventExit, Reticle::Destroy);

////////////////////////////////////////////////////////////

function Reticle::Create()
{
	if($Reticle::Exist)
		return;

	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	Reticle::Destroy();

	%HudContainer=newObject("Reticle_Container", SimGui::Control, %x / 2 - 15, %y / 2 - 15, 31, 31);
	%HudBitmapCtrl=newObject("Reticle_Bitmap", FearGuiFormattedText, 0, 0, 31, 31);

	addToSet("Reticle_Container", %HudBitmapCtrl);
	addToSet(PlayGui, %HudContainer);

	$Reticle::Exist = "True";

	if($Viking::AutoRet)
		Reticle::Update();
	else if($Viking::ActiveRet)
		Reticle::Active();
	else
		Control::setValue("Reticle_Bitmap", "<B0,0:"@$Viking::BMPdir@"RET_"@$Reticle[$pref::ReticleIndex]@".bmp>");
}

function Reticle::Update()
{
	%itemId = getMountedItem(0);

	Control::setValue("Reticle_Bitmap", "<B0,0:"@$Viking::BMPdir@"RET_"@getMountedItem(0)@".bmp>");

	Schedule::Add("Reticle::Update();", 0.5, "Reticle");
}

function Reticle::Change()
{
	Schedule::Cancel("Reticle");

	$pref::ReticleIndex++;

	if($pref::ReticleIndex > 11)
		$pref::ReticleIndex = 0;

	Control::setValue("Reticle_Bitmap", "<B0,0:"@$Viking::BMPdir@"RET_"@$Reticle[$pref::ReticleIndex]@".bmp>");
}

function Reticle::Active(%hit)
{
	if(%hit)
		Control::setValue("Reticle_Bitmap", "<B0,0:"@$Viking::BMPdir@"RET_1.bmp>");
	else
		Control::setValue("Reticle_Bitmap", "<B0,0:"@$Viking::BMPdir@"RET_0.bmp>");
}

function Reticle::Destroy()
{
	HUD::Destroy("Reticle_");
	HUD::Destroy("Reticle_");
	$Reticle::Exist = "False";
}
