////////////////////////////////////////////////////////////
// File:	TeamTrack.cs
// Version:	3.2
// Author:	Runar
// Credits:	
// Info:	Keeps track of clients, teams, kills/deaths and
//		all the flag-tracking stuff. Objective support
//		is planned for :)
//
// History: 1.0 Initial version
//
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// TeamTrack Team/Client events
////////////////////////////////////////////////////////////

Event::Attach(eventOnTeamAdd, TT::Team::Add);
Event::Attach(eventClientJoin, TT::Client::Join);
Event::Attach(eventClientDrop, TT::Client::Drop);
Event::Attach(eventClientChangeTeam, TT::Client::ChangeTeam);
Event::Attach(eventKillTrak, TT::Client::Death);
Event::Attach(eventMissionInfo, TT::Mission::Change);
Event::Attach(eventEndGame, TT::Client::DeleteAll);
Event::Attach(eventConnectionLost, TT::Client::DeleteAll);
Event::Attach(eventConnectionTimeout, TT::Client::DeleteAll);
Event::Attach(eventConnectionRejected, TT::Client::DeleteAll);

////////////////////////////////////////////////////////////
// TeamTrack Flag events
////////////////////////////////////////////////////////////

Event::Attach(eventFlagTaken, TT::Flag::Taken);
Event::Attach(eventFlagDropped, TT::Flag::Dropped);
Event::Attach(eventFlagReturned, TT::Flag::Returned);
Event::Attach(eventFlagCaptured, TT::Flag::Captured);

////////////////////////////////////////////////////////////
// TeamTrack Team functions
////////////////////////////////////////////////////////////

function TT::Team::Add(%team, %teamName)
{
	%teamId = %team - 1;

	$TT::Team::Id[%teamId] = %teamId;

	if(%teamId != -1)
	{
		$TT::Team::Name[%teamId] = %teamName;
	}
	else
	{
		$TT::Team::Name[%teamId] = "Observers";
	}
	
	$TT::Team::Score[%teamId] = 0;
	$TT::Team::Deaths[%teamId] = 0;
	$TT::Team::Kills[%teamId] = 0;

	if($TT::Team::Count[%teamId] == "")
		$TT::Team::Count[%teamId] = "0";

	$TT::Flag::Location[%teamId] = "Home";
	$TT::Flag::ClientId[%teamId] = "";
	$TT::Flag::Timer[%teamId] = "False";
	$TT::Flag::Time[%teamId] = "";

	return;
}

function TT::Team::Count(%teamId)
{
	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
		if($TT::Client::Team[%clientId] == %teamId)
		{
			$TT::Team::Count[%teamId]++;
		}
	}

	return $TT::Team::Count[%teamId];
}

////////////////////////////////////////////////////////////
// TeamTrack Mission functions
////////////////////////////////////////////////////////////

function TT::Mission::Change(%serverId, %missionName)
{
	TT::Client::ResetAll();
	return;
}

////////////////////////////////////////////////////////////
// TeamTrack Client functions
////////////////////////////////////////////////////////////

function TT::Client::Join(%clientId)
{
	$TT::Client::Name[%clientId] = Client::GetName(%clientId);
	$TT::Client::Team[%clientId] = Client::GetTeam(%clientId);
	$TT::Client::Kills[%clientId] = 0;
	$TT::Client::Deaths[%clientId] = 0;

	$TT::Team::Count[$TT::Client::Team[%clientId]]++;

	if(%clientId = getManagerId())
		$myId = %clientId;

	return;
}

function TT::Client::Drop(%clientId)
{
	TT::Client::Delete(%clientId);

	return;
}

function TT::Client::ChangeTeam(%clientId, %teamId)
{
	%oldTeam = $TT::Client::Team[%clientId];
	$TT::Team::Count[%oldTeam]--;
	$TT::Team::Count[%teamId]++;

	$TT::Client::Team[%clientId] = %teamId;

	return;
}

function TT::Client::GetAll()
{
	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
		if(Client::GetName(%clientId) != "")
		{
			$TT::Client::Name[%clientId] = Client::GetName(%clientId);
			$TT::Client::Team[%clientId] = Client::GetTeam(%clientId);
			$TT::Client::Kills[%clientId] = 0;
			$TT::Client::Deaths[%clientId] = 0;

			$TT::Team::Count[$TT::Client::Team[%clientId]]++;
		}
	}

	return;
}

function TT::Client::Delete(%clientId)
{
	$TT::Team::Count[$TT::Client::Team[%clientId]]--;

	deleteVariables("$TT::Client::Name*" @ %clientId);
	deleteVariables("$TT::Client::Team*" @ %clientId);
	deleteVariables("$TT::Client::Kills*" @ %clientId);
	deleteVariables("$TT::Client::Deaths*" @ %clientId);
	
	if($TT::Client::Name[%clientId] != "")
		echo("TT::Client::Delete: " @ $TT::Client::Name[%clientId] @ " FAILED!!");

	return;
}

function TT::Client::DeleteAll()
{
	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
		if($TT::Client::Name[%clientId] != "")
		{
			TT::Client::Delete(%clientId);
		}
	}

	return;
}

function TT::Client::Reset(%clientId)
{

	$TT::Client::Kills[%clientId] = 0;
	$TT::Client::Deaths[%clientId] = 0;

	return;
}

function TT::Client::ResetAll()
{
	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
		if($TT::Client::Name[%clientId] != "")
		{
			TT::Client::Reset(%clientId);
		}
	}

	return;
}

function TT::Client::Death(%serverId, %victimId, %killerId, %weapon)
{
	if(%serverid != 2048)
		return;

	// Suicide or other death, turret, fall etc.
	if(%killerId == "" || %killerId == %victimId)
	{
		$TT::Client::Deaths[%victimId]++;
		$TT::Team::Deaths[$TT::Client::Team[%victimId]]++;
	}
	else
	{
		$TT::Client::Deaths[%victimId]++;
		$TT::Client::Kills[%killerId]++;
		
		$TT::Team::Deaths[$TT::Client::Team[%victimId]]++;
		$TT::Team::Kills[$TT::Client::Team[%killerId]]++;
	}

	return;
}

////////////////////////////////////////////////////////////
// TeamTrack Flag functions
////////////////////////////////////////////////////////////

function TT::Flag::Taken(%flagId, %clientId, %client)
{
	$TT::Flag::Location[%flagId] = %client;
	$TT::Flag::ClientId[%flagId] = %clientId;
	$TT::Flag::Timer[%flagId] = "False";
	$TT::Flag::Time[%flagId] = "";

	return;
}

function TT::Flag::Dropped(%flagId, %clientId, %client)
{
	$TT::Flag::Location[%flagId] = "Dropped";
	$TT::Flag::ClientId[%flagId] = "";
	$TT::Flag::Timer[%flagId] = "True";
	$TT::Flag::Time[%flagId] = 48;

	TT::Flag::Timer(%flagId);

	return;
}

function TT::Flag::Returned(%flagId, %clientId, %client)
{
	$TT::Flag::Location[%flagId] = "Home";
	$TT::Flag::ClientId[%flagId] = "";
	$TT::Flag::Timer[%flagId] = "False";
	$TT::Flag::Time[%flagId] = "";

	return;
}

function TT::Flag::Captured(%flagId, %clientId, %client)
{
	$TT::Flag::Location[%flagId] = "Home";
	$TT::Flag::ClientId[%flagId] = "";
	$TT::Flag::Timer[%flagId] = "False";
	$TT::Flag::Time[%flagId] = "";
	$TT::Team::Score[1-%flagId]++;

	return;
}

function TT::Flag::Timer(%flagId)
{
	if($TT::Flag::Timer[%flagId] == "False" || $TT::Flag::Time[%flagId] == 0)
		return;

	if($TT::Flag::Time[%flagId] < 10)
	{
		$TT::Flag::Time[%flagId] = "0"@$TT::Flag::Time[%flagId];
	}

	$TT::Flag::Time[%flagId]--;

	Event::Trigger(eventFlagTimer, %flagId);

	%tag = "TT::Flag::Timer_"@%flagId;
	Schedule::Add("TT::Flag::Timer("@%flagId@");", 1, %tag);

	return;
}
