////////////////////////////////////////////////////////////
// File:	Viking.cs 3.2
// Author:	Runar
// Credits:	Dad?
// Info:	Will load the Viking.vol file if its there.
//
////////////////////////////////////////////////////////////

// Function to load our preferences
function Viking::LoadFile(%filename)
{
	if(File::findFirst(%filename) != "")
	{
		exec(%filename);
		echo("[Viking] : " @ %filename @ " loaded..");
	}
	else
	{
		echo("[Viking] Fatal error: " @ %filename @ " not found!!");
	}
}

// Function to load our vol-file
function Viking::LoadVolume(%file)
{
	if(File::findFirst(%file) != "")
	{
		newObject("Viking", SimVolume, File::findFirst(%file));
		echo("Viking volume found and loaded!");
	}
}

// Load our preferences
Viking::LoadFile("Viking\\Preferences.cs");

// Load the vol-file
Viking::LoadVolume("Viking.vol");

// exec our scripts
Viking::LoadFile("Viking\\Support.cs");
Viking::LoadFile("Viking\\Messages.cs");
Viking::LoadFile("Viking\\TeamTrack.cs");
Viking::LoadFile("viking\\Active.cs");
Viking::LoadFile("viking\\BWclient.cs");
Viking::LoadFile("viking\\GUI.cs");
Viking::LoadFile("Viking\\Common.cs");

// Load these if enabled only
if($Viking::FlagHUD)	Viking::LoadFile("Viking\\FlagHUD.cs");
if($Viking::ItemHUD)	Viking::LoadFile("Viking\\ItemHUD.cs");
if($Viking::TeamHUD)	Viking::LoadFile("Viking\\TeamHUD.cs");
if($Viking::KillHUD)	Viking::LoadFile("Viking\\KillHUD.cs");
if($Viking::DeathHUD)	Viking::LoadFile("Viking\\DeathHUD.cs");
if($Viking::AmmoHud)	Viking::LoadFile("viking\\AmmoHud.cs");
if($Viking::ClockHud)	Viking::LoadFile("viking\\ClockHud.cs");
if($Viking::CmdView)	Viking::LoadFile("viking\\CmdView.cs");
if($Viking::RFinder)	Viking::LoadFile("viking\\RangeFinder.cs");
if($Viking::Reticle)	Viking::LoadFile("viking\\Reticle.cs");
if($Viking::RetCompass) Viking::LoadFile("Viking\\RetCompass.cs");
if($Viking::SnipeZoom)	Viking::LoadFile("Viking\\SnipeZoom.cs");
if($Viking::ChainZoom) 	Viking::LoadFile("Viking\\ChainZoom.cs");
if($Viking::Pilot) 	Viking::LoadFile("Viking\\Pilot.cs");
if($Viking::FlagPop)	Viking::LoadFile("Viking\\FlagPopUp.cs");
if($Viking::Favorites)	Viking::LoadFile("Viking\\Favorites.cs");
if($Viking::Dropper)	Viking::LoadFile("Viking\\Dropper.cs");
if($Viking::ObsTV)	Viking::LoadFile("viking\\TV.cs");
if($Viking::Popup)	Viking::LoadFile("viking\\PopUp.cs");
if($Viking::Incoming)	Viking::LoadFile("Viking\\Incoming.cs");
if($Viking::Chat)	Viking::LoadFile("Viking\\Chat.cs");
if($Viking::Waypoints)	Viking::LoadFile("Viking\\Waypoint.cs");
if($Viking::KillTrak)	Viking::LoadFile("Viking\\KillTrak.cs");