//================================================================
//Firestorm
//================================================================
$AutoUse[FSI] = False;
//================================================================
$InvList[Firestorm] = 1;
$InvList[FireAmmo] = 1;
$RemoteInvList[Firestorm] = 1;
$RemoteInvList[FireAmmo] = 1;
//================================================================
$DamageScale[larmor, $FireStormDamageType] = 1.0;
$DamageScale[lfemale, $FireStormDamageType] = 1.0;
$DamageScale[marmor, $FireStormDamageType] = 1.0;
$DamageScale[mfemale, $FireStormDamageType] = 1.0;
$DamageScale[harmor, $FireStormDamageType] = 1.0;

$ItemMax[lfemale, FireStorm] = 1;
$ItemMax[lfemale, FireStorm] = 1;
$ItemMax[mfemale, FireStorm] = 1;
$ItemMax[mfemale, FireStorm] = 1;
$ItemMax[harmor, FireStorm] = 1;

$ItemMax[larmor, FireAmmo] = 100;
$ItemMax[lfemale, FireAmmo] = 100;
$ItemMax[marmor, FireAmmo] = 350;
$ItemMax[mfemale, FireAmmo] = 350;
$ItemMax[harmor, FireAmmo] = 500;
//================================================================
SoundData SoundWPNFireStorm
{
   wavFileName = "wpn_fs.wav";
   profile = Profile3dNearLoop;
};
SoundData SoundWPNFSSpinUp
{
   wavFileName = "wpn_firestorm_up.wav";
   profile = Profile3dNear;
};
SoundData SoundWPNFSSpinDown
{
   wavFileName = "wpn_firestorm_down.wav";
   profile = Profile3dNear;
};
SoundData FireStormExplosion
{
   wavFileName = "explo4.wav";
   profile     = Profile3dFar;
};

//================================================================
ExplosionData FireStormExp
{
   shapeName = "plasmaex.dts";
   soundId   = FireStormExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;

   timeScale = 3.0;

   timeZero = 0.200;
   timeOne  = 0.950;

   colors[0]  = { 1.0, 0, 0 };
   colors[1]  = { 1.0, 0, 0 };
   colors[2]  = { 1.0, 0, 0 };
   radFactors = { 0.375, 1.0, 0.9 };
};
//================================================================
RocketData FireStormproj
{
   bulletShapeName = "proj_firestorm.dts";
   explosionTag    = FireStormExp;

   collisionRadius = 0;
   mass            = 0.5;

   damageClass      = 0;       // 0 impact, 1, radius
   damageValue      = 3.0;
   damageType       = $FireStormDamageType;

   explosionRadius  = 3.0;
   kickBackStrength = 10;

   muzzleVelocity   = 750;
   terminalVelocity = 3000;
   acceleration     = 100;

   totalTime        = 5;
   liveTime         = 3;

   lightRange       = 3;
   lightColor       = { 1, 0, 0 };

   inheritedVelocityScale = 1.0;

   // rocket specific
   trailType   = 1;
   trailLength = 75;
   trailWidth  = 0.25;
};
//================================================================

ItemData FireAmmo
{
	description = "FireStorm Cells";
	className = "Ammo";
	shapeFile = "plasammo";
   heading = "xAmmunition";
	shadowDetailMask = 4;
	price = 0;
};

ItemImageData FirestormImage 
{
 shapeFile = "chaingun";
 mountPoint = 0;
 //mountOffset = { -0.1, 0, 0 };
 //mountRotation = { 0, -1.575, 0};
 weaponType = 1;
 reloadTime = 0;
 spinUpTime = 0.48;
 spinDownTime = 0.75;
 fireTime = 0.35;
 ammoType = FireAmmo;
 accuFire = false;
 lightType = 3;
 lightRadius = 3;
 lightTime = 1;
 lightColor = { 3.0, 0, 0 };
 sfxFire = SoundWPNFireStorm;
 sfxActivate = SoundPickupWeapon;
 sfxSpinUp = SoundWPNFSSpinUp;
}; 

ItemData Firestorm
{
 description = "FireStorm";
 className = "Weapon";
 shapeFile = "chaingun";
 hudIcon = "chain";
 heading = "bWeapons";
 shadowDetailMask = 4;
 imageType = FirestormImage;
 price = 0;
 showWeaponBar = true; 
}; 

//===========================================
echo("Firestorm Loaded");