//================================================================
//Reaper
//================================================================
$AutoUse[Reaper] = False;
//================================================
$InvList[Reaper] = 1;
$InvList[ReaperAmmo] = 1;
$RemoteInvList[Reaper] = 1;
$RemoteInvList[ReaperAmmo] = 1;
//================================================================
$DamageScale[larmor, $ReaperDamageType] = 1.0;
$DamageScale[lfemale, $ReaperDamageType] = 1.0;
$DamageScale[marmor, $ReaperDamageType] = 1.0;
$DamageScale[mfemale, $ReaperDamageType] = 1.0;
$DamageScale[harmor, $ReaperDamageType] = 1.0;

$ItemMax[larmor, Reaper] = 1;
$ItemMax[lfemale, Reaper] = 1;
$ItemMax[marmor, Reaper] = 1;
$ItemMax[mfemale, Reaper] = 1;
$ItemMax[harmor, Reaper] = 1;

$ItemMax[larmor, ReaperAmmo] = 250;
$ItemMax[lfemale, ReaperAmmo] = 250;
$ItemMax[marmor, ReaperAmmo] = 250;
$ItemMax[mfemale, ReaperAmmo] = 250;
$ItemMax[harmor, ReaperAmmo] = 250;
//================================================================
SoundData SoundWhizReaper
{
   wavFileName = "wpn_Reaper.wav";
   profile = Profile3dNearLoop;
};
SoundData SoundWPNReaperSpinUp
{
   wavFileName = "wpn_reaper_up.wav";
   profile = Profile3dNear;
};
SoundData SoundWPNReaperSpinDown
{
   wavFileName = "wpn_reaper_Down.wav";
   profile = Profile3dNear;
};
SoundData SoundWPNReaperSpin
{
   wavFileName = "wpn_reaper_spin.wav";
   profile = Profile3dNear;
};
SoundData SoundHitReaper
{
   wavFileName = "hit_reaper.wav";
   profile = Profile3dMedium;
};
//================================================================
ExplosionData ReaperExp
{
   shapeName = "laserhit.dts";
   soundId   = SoundHitReaper;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 4.0;

   timeZero = 0.200;
   timeOne  = 0.950;
	
   timeScale = 3.0;

   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 0.25, 0.25, 1.0 };
   radFactors = { 0.375, 1.0, 0.9 };
};
//================================================================
RocketData Reaperproj
{
   bulletShapeName = "proj_laser_grn.dts";
   explosionTag    = ReaperExp;

   collisionRadius = 0.0;
   mass            = 5.0;

   damageClass      = 0;       // 0 impact, 1, radius
   damageValue      = 1.0;
   damageType       = $ReaperDamageType;
   muzzleVelocity   = 200.0;
   terminalVelocity = 300.0;
   acceleration     = 100.0;
   explosionRadius    = 1.0;

   totalTime        = 3.0;
   liveTime         = 3.0;

   lightRange        = 3.0;
   lightColor        = { 0.25, 0.25, 1.0 };
   isVisible          = True;
   inheritedVelocityScale = 1.0;
   soundId = SoundWhizReaper; 
  };
//================================================================
ItemData ReaperAmmo
{
        description = "Reaper Cell";
        className = "Ammo";
        shapeFile = "plasammo";
   heading = "xAmmunition";
        shadowDetailMask = 4;
        price = 0;
};

ItemImageData ReaperImage
{
        shapeFile = "wpn_Reaper";
        mountPoint = 0;

        weaponType = 1; // Spinning
        reloadTime = 0;
        spinUpTime = 1.0;
        spinDownTime = 0.5;
        fireTime = 0.125;
	
        ammoType = ReaperAmmo;
        projectileType = Reaperproj;
        accuFire = false;

        lightType = 3;  // Weapon Fire
        lightRadius = 3;
        lightTime = 1.0;
        lightColor = { 0.25, 0.25, 1.0 };

        sfxFire = SoundWPNReaperSpin;
        sfxActivate = SoundPickUpWeapon;
        sfxSpinUp = SoundWPNReaperSpinUp;
        sfxSpinDown = SoundWPNReaperSpinDown;
};

ItemData Reaper
{
        description = "Reaper";
        className = "Weapon";
        shapeFile = "wpn_reaper";
        hudIcon = "reaper";
   heading = "bWeapons";
        shadowDetailMask = 4;
        imageType = ReaperImage;
        price = 0;
        showWeaponBar = true;
   //validateShape = true;
   //validateMaterials = true;
};
//================================================================
//echo("Reaper Loaded");