// =================================================================
//  U L T R A   R E N E G A D E S   V X  E L I T E     
// =================================================================
// Copyright  2005 Armageddon. List of credits in credits.txt


//==================================-----
// Hybrid 2K5 Explosion Data
//==================================-----
ExplosionData BlazterExp
{
   shapeName = "shotgunex.dts";
   soundId   = debrisSmallExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.5;

   timeZero = 0.250;
   timeOne  = 0.650;

   colors[0]  = { 50.0, 0.0, 0.0  };
   colors[1]  = { 50.0, 0.0, 0.0 };
   colors[2]  = { 50.0, 0.0, 0.0 };
   radFactors = { 2.0, 0.0, 0.0 };
};
//#######################################
ExplosionData ElectroPlasmCannonExp
{
   shapeName = "fusionex.dts";
   soundId   = explosion4;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 4.0;

   timeZero = 0.200;
   timeOne  = 0.950;

   colors[0]  = { 0.0, 0.0,  5.0 };
   colors[1]  = { 0.0, 0.0, 5.0 };
   colors[2]  = { 0.0, 0.0, 5.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};
//#######################################
ExplosionData PulseGrenadeLauncher1Exp
{
   shapeName = "shield_large.dts";
   soundId   = shockExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 5.0;

   timeScale = 1.5;

   timeZero = 0.0;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 50.0, 0.0 };
   colors[1]  = { 0.0, 50.0, 0.0 };
   colors[2]  = { 0.0, 50.0, 0.0 };
   radFactors = { 0.0, 5.0, 0.0 };
};

ExplosionData PulseGrenadeLauncher2Exp
{
   shapeName = "shield_large.dts";
   soundId   = shockExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 5.0;

   timeScale = 1.5;

   timeZero = 0.0;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0, 50.0 };
   colors[1]  = { 0.0, 0.0, 50.0 };
   colors[2]  = { 0.0, 0.0, 50.0 };
   radFactors = { 0.0, 0.0, 5.0 };
};
//#######################################
ExplosionData mortarExp
{
   shapeName = "mortarex.dts";
   soundId   = shockExplosion;

   faceCamera = true;
   randomSpin = false;
   hasLight   = true;
   lightRange = 15.0;

   timeScale = 1.500;

   timeZero = 0.250;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 0.3, 1.0, 0.3 };
   colors[2]  = { 0.0, 0.7, 0.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};
ExplosionData MortarSplitExp
{
   shapeName = "mortartrail.dts";
   //soundId   = turretExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 1.0,  1.0,  1.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};
//#######################################
ExplosionData StormhammerExp
{
   shapeName = "bluex.dts";
   soundId   = rocketExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 3.0;

   timeScale = 1.5;

   timeZero = 0.250;
   timeOne  = 0.850;

   colors[0]  = { 0, 0, 50.0 };
   colors[1]  = { 0, 0, 50.0 };
   colors[2]  = { 0, 0, 50.0 };
   radFactors = { 0, 0, 5.0 };
};
//#######################################
ExplosionData FusionRifleExp
{
   shapeName = "enex.dts";
   soundId   = SoundBeaconUse;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;

   timeZero = 0.250;
   timeOne  = 0.650;

   colors[0]  = { 0.0, 5.0, 0.0  };
   colors[1]  = { 0.0, 5.0, 0.0 };
   colors[2]  = { 0.0, 5.0, 0.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};
//#######################################
ExplosionData ToxicExp
{
   shapeName = "dustplume.dts";

   faceCamera = false;
   randomSpin = false;
   hasLight   = false;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 1.0, 1.0,  1.0 };
   radFactors = { 1.0, 1.0,  1.0 };

   shiftPosition = true;
};
//#######################################
ExplosionData IONExp
{
   shapeName = "shield_large.dts";
   soundId   = bigexplosion4;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 3.9;
   timeScale = 1.6;
   timeZero = 0.200;
   timeOne  = 0.800;
   
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 0.0, 0.0 };
   colors[2]  = { 1.0, 0.0, 0.0 };
   
   radFactors = { 0.0, 1.0, 0.85};
};
//#######################################
ExplosionData FissionExp
{
   shapeName = "bluex.dts";
   soundId   = bigExplosion3;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeScale = 2;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};
//####################################### - Start Cybrid BOOM
ExplosionData NAfterExp
{
	shapeName = "plasmaex.dts";
	//soundId   = SoundLaserHit;
	faceCamera = true;
	randomSpin = true;
	hasLight   = true;
	lightRange = 3.0;
	timeZero = 0.450;
	timeOne  = 0.750;
	colors[0]  = { 0.25, 0.25, 1.0 };
	colors[1]  = { 0.25, 0.25, 1.0 };
	colors[2]  = { 1.0,  1.0,  1.0 };
	radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData LargeShockwave2
{
	shapeName = "shockwave_large.dts";
	soundId   = shockExplosion;
	faceCamera = true;
	randomSpin = false;
	hasLight   = true;
	lightRange = 10.0;
	timeZero = 0.100;
	timeOne  = 0.400;
	colors[0]  = { 1.0, 1.0, 1.0 };
	colors[1]  = { 1.0, 1.0, 1.0 };
	colors[2]  = { 0.0, 0.0, 0.0 };
	radFactors = { 1.0, 0.5, 0.0 };
};

ExplosionData LargeShockwave3
{
	shapeName = "shockwave_large.dts";
	//soundId   = shockExplosion; 
	faceCamera = false;
	randomSpin = true;
	hasLight   = true;
	lightRange = 10.0;
	timeZero = 0.0;
	timeOne  = 0.500;
	colors[0]  = { 1.0, 1.0, 1.0 };
	colors[1]  = { 1.0, 1.0, 1.0 };
	colors[2]  = { 0.0, 0.0, 0.0 };
	radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData KamiExplosion
{
	shapeName = "shockwave_large.dts";
	soundId   = shockExplosion;

	faceCamera = false;
	randomSpin = false;
	hasLight   = true;
	lightRange = 10.0;

	timeScale = 5.5;

	timeZero = 0.900;
	timeOne  = 0.800;

	colors[0]  = { 1.0, 1.0, 1.0 };
	colors[1]  = { 1.0, 1.0, 1.0 };
	colors[2]  = { 0.0, 0.0, 0.0 };
	radFactors = { 1.0, 0.5, 0.0 };
};

ExplosionData SmokeExp
{
   shapeName = "smoke.dts";
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 0;
   timeZero = 0.450;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 0.5 };
   colors[2]  = { 1.0, 1.0, 0.5 };
   radFactors = { 0.0, 1.0, 0.0 };
   shiftPosition = True;
};

ExplosionData SmokerExp1
{
	shapeName = "flash_large.dts";
	soundId   = shockExplosion;
	faceCamera = true;
	randomSpin = true;
	hasLight   = true;
	lightRange = 3.0;
	timeZero = 0.450;
	timeOne  = 0.750;
	colors[0]  = { 0.25, 0.25, 1.0 };
	colors[1]  = { 0.25, 0.25, 1.0 };
	colors[2]  = { 1.0,  1.0,  1.0 };
	radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData SmokerExp2
{
	shapeName = "tumult_medium.dts";
	soundId   = shockExplosion;
	faceCamera = true;
	randomSpin = true;
	hasLight   = true;
	lightRange = 3.0;
	timeZero = 0.450;
	timeOne  = 0.750;
	colors[0]  = { 0.25, 0.25, 1.0 };
	colors[1]  = { 0.25, 0.25, 1.0 };
	colors[2]  = { 1.0,  1.0,  1.0 };
	radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData SmokerExp3
{
	shapeName = "shockwave.dts";
	soundId   = shockExplosion;
	faceCamera = true;
	randomSpin = true;
	hasLight   = true;
	lightRange = 3.0;
	timeZero = 0.450;
	timeOne  = 0.750;
	colors[0]  = { 0.25, 0.25, 1.0 };
	colors[1]  = { 0.25, 0.25, 1.0 };
	colors[2]  = { 1.0,  1.0,  1.0 };
	radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData SmokerExp4
{
	shapeName = "tumult_large.dts";
	soundId   = shockExplosion;
	faceCamera = true;
	randomSpin = true;
	hasLight   = true;
	lightRange = 3.0;
	timeZero = 0.450;
	timeOne  = 0.750;
	colors[0]  = { 0.25, 0.25, 1.0 };
	colors[1]  = { 0.25, 0.25, 1.0 };
	colors[2]  = { 1.0,  1.0,  1.0 };
	radFactors = { 1.0, 1.0, 1.0 };
};
//#######################################
ExplosionData PistolExp
{
   shapeName = "rsmoke.dts";
   soundId   = SoundFlierCrash;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 0.1;

   timeZero = 0.250;
   timeOne  = 0.850;

   colors[0]  = { 0.4, 0.4,  1.0 };
   colors[1]  = { 1.0, 1.0,  1.0 };
   colors[2]  = { 1.0, 0.95, 1.0 };
   radFactors = { 0.5, 1.0, 1.0 };
};
//#######################################
ExplosionData VerminatorSmokeExp
{
   shapeName = "rsmoke.dts";
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;

   lightRange = 0;
   timeScale = 1;

   timeZero = 0.010;	//0.100;
   timeOne  = 0.035;	//0.900;

   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 0.0 };

   shiftPosition = True;
};
//#######################################
ExplosionData HavocExp
{
   shapeName = "plastrail.dts";
   soundId   = debrisLargeExplosion;

   faceCamera = true;
   randomSpin = false;
   hasLight   = false;
   lightRange = 1.0;

   timeZero = 0;
   timeOne  = 1;

   colors[0]  = { 1.0, 1.0, 1.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 0.0, 0.0, 0.0 };
   radFactors = { 1.0, 0.5, 0.3 };
};
//#######################################
ExplosionData ShotGunExp 
{	shapeName = "smoke.dts";
	soundId = ricochet3;
	faceCamera = true;
	randomSpin = true;
	hasLight = false;
	timeScale = 0.5;
	timeZero = 0.100;
	timeOne = 0.900;
	shiftPosition = false;
};
//#######################################
ExplosionData TalonRocketExp
{
   shapeName = "fiery.dts";
   soundId   = bigExplosion3;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 10.0;

   timeScale = 1.5;

   timeZero = 0.150;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};

ExplosionData TalonRocket2Exp
{
   shapeName = "tumult_large.dts";
   soundId   = bigExplosion3;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 10.0;

   timeScale = 1.5;

   timeZero = 0.150;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};
//#######################################
ExplosionData BlazeExp
{
   shapeName = "plasmabolt.dts";
   soundId   = energyExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1;

   timeScale = 0.3;


   colors[0]  = { 0.4, 0.4,  0.2 };
   colors[1]  = { 1.0, 0.0,  0.0 };
   colors[2]  = { 0.8, 0.2, 0.2 };
   radFactors = { 0.5, 1.0, 1.0 };
};
//#######################################
ExplosionData BurnerFloaterExp
{	
	shapeName = "plasmaex.dts";
	soundId = explosion4;	
	faceCamera = true;
	randomSpin = true;
	hasLight   = true;
	lightRange = 6;

	timeZero = 0.450;
	timeOne  = 0.750;

	colors[0]  = { 1.0, 0, 0 };
	colors[1]  = { 1.0, 0, 0 };
	colors[2]  = { 1.0, 0.25, 0.25 };
	radFactors = { 1.0, 1.0, 1.0 };
	shiftPosition = true;
};
//#######################################
ExplosionData RailExp
{
   shapeName = "chainspk.dts";
   soundId   = rocketExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 3.0;

   timeZero = 0.450;
   timeOne  = 0.550;

   colors[0]  = { 0.25, 0.25, 0.25 };
   colors[1]  = { 0.25, 0.25, 0.25 };
   colors[2]  = { 0.25, 0.25, 0.25 };
   radFactors = { 1.0, 1.0, 1.0 };

   shiftPosition = True;
};
//#######################################
ExplosionData HybridChainExp
{
   shapeName = "plasmabolt.dts";
   soundId   = debrisSmallExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 0.5;

   timeZero = 0.200;
   timeOne  = 0.950;

   colors[0]  = { 2.0, 1.2,  0.0 };
   colors[1]  = { 2.0, 1.2, 0.0 };
   colors[2]  = { 2.0, 1.2, 0.0 };
   radFactors = { 2.0, 1.2, 0.0 };
};
//#######################################
ExplosionData BlastExp0
{
	shapeName = "tumult_medium.dts";
	soundId = debrisMediumExplosion;
	faceCamera = true;
	randomSpin = true;
	hasLight = true;
	lightRange = 4.0;
	timeScale = 1.5;
	timeZero = 0.250;
	timeOne = 0.850;
	colors[0]  = { 0.0, 0.0,  0.0 };
   	colors[1]  = { 1.0, 0.63, 0.0 };
   	colors[2]  = { 1.0, 0.63, 0.0 };
   	radFactors = { 0.0, 1.0, 0.9 };
};
//#######################################
ExplosionData HybridmortarExp
{
   shapeName = "fiery.dts";
   soundId   = SoundPlayerDeath;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 8.0;

   timeScale = 4.5;

   timeZero = 0.250;
   timeOne  = 0.850;

   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};
//#####################################
ExplosionData ShieldExp
{
   shapeName = "shield.dts";

   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeScale = 1.6;
   timeZero = 0.200;
   timeOne  = 0.800;
   
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 0.0, 0.0 };
   colors[2]  = { 1.0, 0.0, 0.0 };
   
   radFactors = { 0.0, 1.0, 0.85};
};
//#######################################
ExplosionData RepairExp
{
   shapeName = "fiery.dts";
   soundId   = bigExplosion3;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 10.0;

   timeScale = 1.5;

   timeZero = 0.150;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};
//END===============================-----
ExplosionData WebExp
{
   shapeName = "fusionex.dts";
   soundId   = energyExplosion;

   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;

   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.0, 0.25, 1.0 };
   colors[1]  = { 0.0, 0.25, 1.0 };
   colors[2]  = { 0.0, 0.25, 1.0 };
   radFactors = { 1.0, 1.0, 1.0 };

   shiftPosition = True;
};

ExplosionData BloodExp 
{	shapeName = "shotgunex.dts";
	soundId = SoundThrowItem;
	faceCamera = true;
	randomSpin = true;
	hasLight = FALSE;
	timeScale = 0.5;
	timeZero = 0.100;
	timeOne = 0.900;
	shiftPosition = false;
   	colors[0]  = { 0.0, 0.0, 0.0 };
   	colors[1]  = { 0.0, 0.0, 0.0 };
   	colors[2]  = { 0.0, 0.0, 0.0 };
   	radFactors = { 1.0, 0.0,  0.0 };
};

ExplosionData PaintSplatExp
{
   shapeName = "laserhit.dts";
   soundId   = SoundFlierCrash;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;
   timeScale = 2.5;
   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 100.0, 0.0, 0.0 };
   colors[1]  = { 100.0, 0.0, 0.0 };
   colors[2]  = { 100.0, 0.0, 0.0 };
   radFactors = { 1.0, 0.0,  0.0 };

   shiftPosition = True;
};

ExplosionData RedPaintSplatExp
{
   shapeName = "shotgunex.dts";
   soundId   = SoundFlierCrash;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;
   timeScale = 2.5;
   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 100.0, 0.0, 0.0 };
   colors[1]  = { 100.0, 0.0, 0.0 };
   colors[2]  = { 100.0, 0.0, 0.0 };
   radFactors = { 1.0, 0.0,  0.0 };

   shiftPosition = True;
};

ExplosionData BluePaintSplatExp
{
   shapeName = "enex.dts";
   soundId   = SoundFlierCrash;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;
   timeScale = 2.5;
   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.0, 0.0, 100.0 };
   colors[1]  = { 0.0, 0.0, 100.0 };
   colors[2]  = { 0.0, 0.0, 100.0 };
   radFactors = { 0.0, 0.0,  1.0 };

   shiftPosition = True;
};

ExplosionData GreenPaintSplatExp
{
   shapeName = "paint.dts";
   soundId   = SoundFlierCrash;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;
   timeScale = 2.5;
   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 0.0, 100.0, 0.0 };
   colors[1]  = { 0.0, 100.0, 0.0 };
   colors[2]  = { 0.0, 100.0, 0.0 };
   radFactors = { 0.0, 1.0,  0.0 };

   shiftPosition = True;
};

ExplosionData OrangePaintSplatExp
{
   shapeName = "plasmatrail.dts";
   soundId   = SoundFlierCrash;

   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 1.0;
   timeScale = 2.5;
   timeZero = 0.450;
   timeOne  = 0.750;

   colors[0]  = { 1.0, 0.63, 0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };

   shiftPosition = True;
};


ExplosionData PTDExp
{
   shapeName = "tumult_small.dts";
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 7.0;
   timeZero = 0.025;
   timeOne  = 0.975;
   colors[0] = { 0.25, 0.25, 1.0 };
   colors[1] = { 0.25, 0.25, 1.0 };
   colors[2] = { 0.0, 0.0, 1.0 };
   radFactors = { 1.0, 1.0, 1.0 };
   shiftPosition = True;
};

ExplosionData ELECDExp
{
   shapeName = "fusionex.dts";
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 7.0;
   timeZero = 0.025;
   timeOne  = 0.975;
   colors[0] = { 0.0, 0.0, 1.0 };
   colors[1] = { 0.0, 0.0, 1.0 };
   colors[2] = { 0.0, 0.0, 1.0 };
   radFactors = { 1.0, 1.0, 1.0 };
   shiftPosition = True;
};

ExplosionData MiscDebExp
{
   shapeName = "shotgunex.dts";
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 7.0;
   timeZero = 0.025;
   timeOne  = 0.975;
   colors[0] = { 1.0, 0.0, 0.0 };
   colors[1] = { 1.0, 0.0, 0.0 };
   colors[2] = { 1.0, 0.0, 0.0 };
   radFactors = { 1.0, 1.0, 1.0 };
   shiftPosition = True;
};

ExplosionData VermExp
{
   shapeName = "shotgunex.dts";
   soundId   = ricochet3;
   faceCamera = true;
   randomSpin = False;
   hasLight   = false;
   lightRange = 1;
   timeScale = 0.5;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};

ExplosionData radiusmineexp
{
   shapeName = "shockwave_large.dts";
   soundId   = shockExplosion;
   faceCamera = false;
   randomSpin = false;
   hasLight   = false;
   lightRange = 1;
   timeZero = 0.100;
   timeOne  = 0.300;
   colors[0]  = { 1.0, 1.0, 1.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 0.0, 0.0, 0.0 };
   radFactors = { 1.0, 0.5, 0.0 };
};

ExplosionData FireScreenExp
{
   shapeName = "fiery.dts";
   soundId   = bigExplosion3;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeScale = 2;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};

ExplosionData ExSmScreenExp
{
   shapeName = "bluex.dts";
   soundId   = bigExplosion3;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeScale = 2;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};

ExplosionData SmScreenExp
{
   shapeName = "flash_large.dts";
   soundId   = soundwindgust;

   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;

   timeScale = 31;

   timeZero = 0.150;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 31, 31, 31 };
};

ExplosionData VXGasAttackExp
{
   shapeName = "bluex.dts";
   soundId   = soundwindgust;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeScale = 31;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 31, 31, 31 };
};

ExplosionData MiniSmokeExp
{
   shapeName = "bluex.dts";
   soundId   = soundwindgust;
   faceCamera = true;
   randomSpin = false;
   hasLight   = false;
   lightRange = 1;
   timeScale = 11;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData fireballExp
{
   shapeName = "fiery.dts";
   soundId   = SoundPlayerDeath;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeScale = 1;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};

ExplosionData rocketExp
{
   shapeName = "bluex.dts";
   soundId   = rocketExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeScale = 1.5;
   timeZero = 0.250;
   timeOne  = 0.850;
   colors[0]  = { 0.4, 0.4,  1.0 };
   colors[1]  = { 1.0, 1.0,  1.0 };
   colors[2]  = { 1.0, 0.95, 1.0 };
   radFactors = { 0.5, 1.0, 1.0 };
};

ExplosionData energyExp
{
   shapeName = "enex.dts";
   soundId   = energyExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeZero = 0.450;
   timeOne  = 0.750;
   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 1.0, 1.0,  1.0 };
   radFactors = { 1.0, 1.0,  1.0 };
   shiftPosition = True;
};

ExplosionData blasterExp
{
   shapeName = "shotgunex.dts";
   soundId   = energyExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeZero = 0.450;
   timeOne  = 0.750;
   colors[0]  = { 1.0, 0.25, 0.25 };
   colors[1]  = { 1.0, 0.25, 0.25 };
   colors[2]  = { 1.0, 0.25, 0.25 };
   radFactors = { 1.0, 1.0, 1.0 };
   shiftPosition = True;
};

ExplosionData GrblasterExp
{
   shapeName = "paint.dts";
   soundId   = energyExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 1;
   timeZero = 0.450;
   timeOne  = 0.750;
   colors[0]  = { 1.0, 0.25, 0.25 };
   colors[1]  = { 1.0, 0.25, 0.25 };
   colors[2]  = { 1.0, 0.25, 0.25 };
   radFactors = { 1.0, 1.0, 1.0 };

   shiftPosition = True;
};

ExplosionData plasmaExp
{
   shapeName = "plasmaex.dts";
   soundId   = explosion4;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.200;
   timeOne  = 0.950;
   colors[0]  = { 1.0, 1.0,  0.0 };
   colors[1]  = { 1.0, 1.0, 0.75 };
   colors[2]  = { 1.0, 1.0, 0.75 };
   radFactors = { 0.375, 1.0, 0.9 };
};

ExplosionData grenadeExp
{
   shapeName = "fiery.dts";
   soundId   = bigExplosion3;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeScale = 1.5;
   timeZero = 0.150;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0,  0.0 };
   colors[1]  = { 1.0, 0.63, 0.0 };
   colors[2]  = { 1.0, 0.63, 0.0 };
   radFactors = { 0.0, 1.0, 0.9 };
};

ExplosionData flashgrenadeExp
{
   shapeName = "flash_large.dts";
   soundId   = shockExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 20;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData BoostExp
{
   shapeName = "fiery.dts";
   soundId   = shockExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeScale = 0.5;
   timeZero = 0.0;
   timeOne  = 0.5;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData mineExp
{
   shapeName = "shockwave.dts";
   soundId   = shockExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 0;
   timeScale = 0.5;
   timeZero = 0.0;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 1.0 };
};


ExplosionData MiniFlakExp
{
   shapeName = "mortarex.dts";
   soundId   = shockExplosion;
   faceCamera = true;
   randomSpin = false;
   hasLight   = false;
   lightRange = 0;
   timeScale = 3;
   timeZero = 0.0;
   timeOne  = 0.500;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData LiLFFBExp
{
   shapeName = "mortarex.dts";
   soundId   = shockExplosion;
   faceCamera = true;
   randomSpin = false;
   hasLight   = false;
   lightRange = 0;
   timeScale = 1.5;
   timeZero = 0.0;
   timeOne  = 0.500;
   colors[0]  = { 1.0, 1.0, 0.0 };
   colors[1]  = { 1.0, 0.0, 1.0 };
   colors[2]  = { 1.0, 0.75, 0.75 };
   radFactors = { 0.375, 1.0, 0.9 };
};

ExplosionData MiniSAMExp
{
   shapeName = "bluex.dts";
   soundId   = rocketExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeScale = 1.5;
   timeZero = 0.250;
   timeOne  = 0.850;
   colors[0]  = { 0.4, 0.4,  1.0 };
   colors[1]  = { 1.0, 1.0,  1.0 };
   colors[2]  = { 1.0, 0.95, 1.0 };
   radFactors = { 0.5, 1.0, 1.0 };
};

ExplosionData turretExp
{
   shapeName = "fusionex.dts";
   soundId   = turretExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.450;
   timeOne  = 0.750;
   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 1.0,  1.0,  1.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData LiLRocketEMPExp
{
   shapeName = "fusionex.dts";
   soundId   = SoundEMPBlast;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.450;
   timeOne  = 0.750;
   colors[0]  = { 0.25, 0.25, 1.0 };
   colors[1]  = { 0.25, 0.25, 1.0 };
   colors[2]  = { 1.0,  1.0,  1.0 };
   radFactors = { 1.0, 1.0, 1.0 };
};

ExplosionData bulletExp0
{
   shapeName = "chainspk.dts";
   soundId   = ricochet3;
   validateShape = true;
   validateMaterials = true;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.100;
   timeOne  = 0.900;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 0.0 };
   shiftPosition = True;
};

ExplosionData bulletExp1
{
   shapeName = "chainspk.dts";
   soundId   = ricochet2;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.100;
   timeOne  = 0.900;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 0.5 };
   colors[2]  = { 1.0, 1.0, 0.5 };
   radFactors = { 0.0, 1.0, 0.0 };
   shiftPosition = True;
};

ExplosionData bulletExp2
{
   shapeName = "chainspk.dts";
   soundId   = ricochet3;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.100;
   timeOne  = 0.900;
   colors[0]  = { 0.0,  0.0, 0.0 };
   colors[1]  = { 0.75, 1.0, 1.0 };
   colors[2]  = { 0.75, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 0.0 };
   shiftPosition = True;
};

ExplosionData debrisExpSmall
{
   shapeName = "tumult_small.dts";
   soundId   = debrisSmallExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData debrisExpMedium
{
   shapeName = "tumult_medium.dts";
   soundId   = debrisMediumExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData debrisExpLarge
{
   shapeName = "tumult_large.dts";
   soundId   = debrisLargeExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData flashExpSmall
{
   shapeName = "flash_small.dts";
   soundId   = debrisSmallExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData flashExpMedium
{
   shapeName = "flash_medium.dts";
   soundId   = debrisMediumExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData flashExpLarge
{
   shapeName = "flash_large.dts";
   soundId   = debrisLargeExplosion;
   faceCamera = true;
   randomSpin = true;
   hasLight   = true;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData Shockwave
{
   shapeName = "shockwave.dts";
   soundId   = shockExplosion;
   faceCamera = false;
   randomSpin = false;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.250;
   timeOne  = 0.650;
   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData LargeShockwave
{
   shapeName = "shockwave_large.dts";
   soundId   = shockExplosion;
   faceCamera = false;
   randomSpin = false;
   hasLight   = false;
   lightRange = 0;
   timeZero = 0.100;
   timeOne  = 0.300;
   colors[0]  = { 1.0, 1.0, 1.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 0.0, 0.0, 0.0 };
   radFactors = { 1.0, 0.5, 0.0 };
};

ExplosionData PulseExp1
{
   shapeName = "shockwave_large.dts";
   soundId   = BigExplosion1;
   faceCamera = true;
   randomSpin = false;
   timeScale = 0.5;
   timeZero = 0.0;
   timeOne  = 0.1;
   colors[0]  = { 0.0, 0.0, 1.0 };
   colors[1]  = { 0.0, 0.0, 1.0 };
   colors[2]  = { 0.0, 0.0, 1.0 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData PulseExp2
{
   shapeName = "shockwave_large.dts";
   soundId   = BigExplosion1;
   faceCamera = true;
   randomSpin = false;
   timeScale = 0.5;
   timeZero = 0.0;
   timeOne  = 0.1;
   colors[0]  = { 0.0, 0.0, 0.0 };
   colors[1]  = { 1.0, 1.0, 1.0 };
   colors[2]  = { 1.0, 1.0, 1.0 };
   radFactors = { 0.0, 1.0, 1.0 };
};

ExplosionData DirtyBombExp
{
   shapeName = "tumult_large.dts";
   // soundId   = shockExplosion;

   faceCamera = true;
   randomSpin = false;
//   faceCamera = true;
//   randomSpin = true;
   hasLight   = true;
   lightRange = 0.0;

   timeScale = 1.0;

   timeZero = 0.0;
   timeOne  = 0.500;

   colors[0]  = { 0.0, 0.0, 0.0  };
   colors[1]  = { 1.0, 0.5, 0.16 };
   colors[2]  = { 1.0, 0.5, 0.16 };
   radFactors = { 0.0, 1.0, 1.0 };
};


ExplosionData DirtyEndExp 
{ 
	shapeName = "mortarex.dts"; 
	faceCamera = true; 
	randomSpin = true; 
	hasLight = true; 
	lightRange = 4.0; 
	timeScale = 0.3; 
	colors[0] = { 0.0, 0.0, 0.0 }; 
	colors[1] = { 0.0, 0.0, 0.0 }; 
	colors[2] = { 0.0, 0.0, 0.0 }; 
	radFactors = { 0.0, 0.0, 0.0 }; 
};
