TurretData AtgarCannon
{
	maxDamage = 1.0;
	maxEnergy = 125;
	minGunEnergy = 25;
	maxGunEnergy = 25;
	reloadDelay = 0.05;
	
	fireSound = SoundFirePlasma;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
	whirSound = SoundMissileTurretTurn;

	range = 400;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "AtgarCannon";
	shieldShapeName = "shield_medium";
	speed = 4.0;
	speedModifier = 4.0;
	projectileType = TurboLaser;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Atgar Laser Cannon";
};
function AtgarCannon::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") == 2.0)
      return "True";
   else
      return "False";
}

TurretData TurboLaserBattery
{
	maxDamage = 1.0;
	maxEnergy = 125;
	minGunEnergy = 25;
	maxGunEnergy = 25;
	reloadDelay = 0.05;
	
	fireSound = SoundFirePlasma;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
	whirSound = SoundMissileTurretTurn;

	range = 400;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "turbolaser";
	shieldShapeName = "shield_medium";
	speed = 4.0;
	speedModifier = 4.0;
	projectileType = TurboLaser;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Turbo Laser Battery";
};
function TurboLaserBattery::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") == 2.0)
      return "True";
   else
      return "False";
}

TurretData PlasmaTurret
{
	maxDamage = 1.0;
	maxEnergy = 200;
	minGunEnergy = 75;
	maxGunEnergy = 6;
	reloadDelay = 0.8;
	
	fireSound = mineExplosion;
	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
	whirSound = SoundMissileTurretTurn;

	range = 200;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "ionturret";
	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = EMPBlast;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Ion Cannon";
};
function PlasmaTurret::verifyTarget(%this,%target)
{
   if (GameBase::virtual(%target, "getHeatFactor") == 2.0)
      return "True";
   else
      return "False";
}



TurretData DeployableTurret
{
	maxDamage = 1.0;
	maxEnergy = 100;
	minGunEnergy = 0;
	maxGunEnergy = 0;
	range = 100;
	gunRange = 75;
	visibleToSensor = true;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_turret";
	debrisId = defaultDebrisLarge;
	className = "Turret";
	shapeFile = "eweb";
	

	shieldShapeName = "shield_medium";
	speed = 2.0;
	speedModifier = 2.0;
	projectileType = EwebBlast;
	reloadDelay = 0.5;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };

	fireSound = mineExplosion;

	activationSound = SoundMissileTurretOn;
	deactivateSound = SoundMissileTurretOff;
//	whirSound = SoundMissileTurretTurn;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
   targetableFovRatio = 0.5;
	explosionId = LargeShockwave;
	description = "EWEB Turret";
};

function DeployableTurret::verifyTarget(%this,%target,%object)
{
	if (GameBase::virtual(%target, "getHeatFactor") < 5)
		return "True";
	else
		return "FALSE";
}


function DeployableTurret::onAdd(%this)
{
	$AmmoTossAnim[%this] = FALSE;
	schedule("DeployableTurret::deploy(" @ %this @ ");",1,%this);
	GameBase::setRechargeRate(%this,0);
	%this.shieldStrength = 0;
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "EWEB Turret");
	}
}

function DeployableTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DeployableTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "TurretPack"]--;
}

// Override base class just in case.
function DeployableTurret::onPower(%this,%power,%generator) {}
function DeployableTurret::onEnabled(%this) 
{
	GameBase::setRechargeRate(%this,0);
	GameBase::setActive(%this,true);
}	



// =================================================================================================
TurretData CameraTurret	   
{			 
	maxDamage = 1.0;
	maxEnergy = 100;
	minGunEnergy = 0;
	maxGunEnergy = 0;
	reloadDelay = 0.03;
	
//	FireSound 	= SoundFireTargetingLaser;
//	activationSound = SoundChainTurretOn;
//	deactivateSound = SoundChainTurretOff;


	range = 350;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_Radar";
	visibleToSensor = true;
	debrisId = defaultDebrisMedium;
	className = "Turret";
	shapeFile = "eweb";
	shieldShapeName = "shield_medium";
	speed = 3.0;
	speedModifier = 2.0;
	projectileType = TargetLaser;
	damageSkinData = "objectDamageSkins";
	shadowDetailMask = 8;
	explosionId = LargeShockwave;
	description = "Radar Unit";	

};

// =================================================================================================
	
   
function CameraTurret::onAdd(%this)
{
	schedule("CameraTurret::deploy(" @ %this @ ");",1,%this);
	if (GameBase::getMapName(%this) == "") 
	{
		GameBase::setMapName (%this, "Camera");
	}
}

// =================================================================================================

function CameraTurret::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

// =================================================================================================

function CameraTurret::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

// =================================================================================================

function CameraTurret::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
  	$TeamItemCount[GameBase::getTeam(%this) @ "CameraPack"]--;
}	

// =================================================================================================

function CameraTurret::verifyTarget(%this,%target,%object)
{
	if (GameBase::virtual(%target, "getHeatFactor") >= 0.5)
		return "True";
	else
		return "FALSE";
}


// =================================================================================================
// =================================================================================================
// =================================================================================================
//---------------------------------------------------

function Turret::onAdd(%this)
{
	if (GameBase::getMapName(%this) == "") {
		GameBase::setMapName (%this, "Turret");
	}
}

function Turret::onActivate(%this)
{
	GameBase::playSequence(%this,0,power);
}

function Turret::onDeactivate(%this)
{
	GameBase::stopSequence(%this,0);
	Turret::checkOperator(%this);
}

function Turret::onSetTeam(%this,%oldTeam)
{
	if(GameBase::getTeam(%this) != Client::getTeam(GameBase::getControlClient(%this))) 
		Turret::checkOperator(%this);

}

function Turret::checkOperator(%this)
{
   %cl = GameBase::getControlClient(%this);
   if(%cl != -1) {
   	%pl = Client::getOwnedObject(%cl);
		Player::setMountObject(%pl, -1,0);
	   Client::setControlObject(%cl, %pl);
   }
	Client::setGuiMode(%cl,2);
}

function Turret::onPower(%this,%power,%generator)
{
	if (%power) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
	}
	else {
		%this.shieldStrength = 0;
		GameBase::setRechargeRate(%this,0);
		Turret::checkOperator(%this);
	}
	GameBase::setActive(%this,%power);
}

function Turret::onEnabled(%this)
{
	if (GameBase::isPowered(%this)) {
		%this.shieldStrength = 0.03;
		GameBase::setRechargeRate(%this,10);
		GameBase::setActive(%this,true);
	}
}

function Turret::onDisabled(%this)
{
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
}

function Turret::onDestroyed(%this)
{
	StaticShape::objectiveDestroyed(%this);
	%this.shieldStrength = 0;
	GameBase::setRechargeRate(%this,0);
	Turret::onDeactivate(%this);
	Turret::objectiveDestroyed(%this);
	calcRadiusDamage(%this, $DebrisDamageType, 2.5, 0.05, 25, 9, 3, 0.40, 
		0.1, 200, 100); 
}

function Turret::onDamage(%this,%type,%value,%pos,%vec,%mom,%object)
{
   if(%this.objectiveLine)
		%this.lastDamageTeam = GameBase::getTeam(%object);
	%TDS= 1;
	if(GameBase::getTeam(%this) == GameBase::getTeam(%object)) {
		%name = GameBase::getDataName(%this);
		if(%name != DeployableTurret && %name != CameraTurret )	
			%TDS = $Server::TeamDamageScale;
	}
	StaticShape::shieldDamage(%this,%type,%value * %TDS,%pos,%vec,%mom,%object);
}

function Turret::onControl (%this, %object)
{
	%client = Player::getClient(%object);
	Client::sendMessage(%client,0,"Controlling turret " @ %this);
}

function Turret::onDismount (%this, %object)
{
	%client = Player::getClient(%object);
	Client::sendMessage(%client,0,"Leaving turret " @ %this);
}
