////////////////////////////////////////////////////////////
// File:	Favorites.cs
// Version:	2.0
// Author:	Runar
// Credits:	Presto, |HH|BigBunny, Freaky, Writer
// Info:	Straightforward fast-favorites. Tnx to 
//		Freaky for letting me have a peak at yours.
//
// History:	1.2 Dont drop rep-packs on r-invs. Dont use
//		repkits in vehicle-stations.
//
//		1.1 New tables with only one global variable for
//		all the items in your loadout. Now there is
//		a separate file: Loadouts.cs for your favs.
//		Also made the buy function a bit faster at
//		the cost of dropping the (2!!) rep-packs before
//		you turn-around.
//
////////////////////////////////////////////////////////////

Event::Attach(eventEnterStation, Favorite::EnterStation);
Event::Attach(eventExitStation, Favorite::ExitStation);
Event::Attach(eventReceivedItem, Favorite::ReceivedItem);

// Load our loadout file
function Favorite::GetLoads()
{
	if(isFile("Config\\Viking\\Loadouts.cs"))
	{
		exec("Viking\\Loadouts.cs");
		echo("Loadouts found and loaded!");
	}
	else
	{
		echo("Cannot find your Loadouts.cs, verify that");
		echo("the file exists in your config dir!");	
	}
}

// Drop Rep-pack on enter inv
function Favorite::Drop()
{
	// Buy and drop Repair-pack, ie. item 30
	remoteEval(2048, buyItem, 30);
	remoteEval(2048, dropItem, 30);	
	remoteEval(2048, buyItem, 30);	
	remoteEval(2048, dropItem, 30);	

	return;
}

// Toggle drop On/Off
function Favorite::DropToggle()
{
 	$Favorite::Drop = !$Favorite::Drop;
 
	if ($Favorite::Drop)
	{
		remoteBP(2048, "<JC><F2>Favorite drop: <F1> ON", 2);
  	} 
	else
	{
  		remoteBP(2048, "<JC><F2>Favorite drop: <F0> OFF", 2);
 	}

	return;
}

// Need this to turn around in station
function Favorite::Turnaround()
{
	// Copied from Presto..
	schedule("postAction(2048, IDACTION_TURNLEFT, 0.33);", 0.01);
	schedule("postAction(2048, IDACTION_TURNLEFT, -0);", 0.31);

	return;
}

// Buy the loadout selected
function Favorite::Buy()
{
	// Buy our loadout, thanks BigBunny for the tip on eval!
	eval("remoteEval(2048, buyFavorites, " @ $Favorite::Items[$Favorite::Selected] @ ");");
	
	return;	
}

// Make the pre-selection
function Favorite::Select(%selection)
{
	// Make the global var
	$Favorite::Selected = %selection;

	// Show what we just selected
	remoteBP(2048, "<JC><F2>Currently selected loadout: <F1>" @ $Favorite::Descr[$Favorite::Selected], 5);

	// If we are in a station, lets buy it!
	if($Favorite::InStation)
		Favorite::Buy();

	return;
}

// Favorite EnterStation event, triggered in Support.cs
function Favorite::EnterStation(%stationType, %doDrop, %doHealth)
{
	// Let others know we're here..
	$Favorite::InStation = True;

	// Turn around for quick exit
	if($Favorite::Turnaround)
		Favorite::Turnaround();

	// Drop something on enter inv
	if($Favorite::Drop && %doDrop)
		Schedule::Add("Favorite::Drop();", 0.01);
	
	// Buy our selected loadout
	Schedule::Add("Favorite::Buy();", 0.02);

	// Auto-buy rep-kits if enabled (and using common.cs..)
	if($Fastrep::Auto && %doHealth)
		Schedule::Add("FastRep::Use();", 0.03);

	// Announce loadout if enabled, else local..
	if($Favorite::Announce)
	{
		say(1, "I'm " @ $Favorite::Descr[$Favorite::Selected] @ "~weapon5");
	}
	else
	{
		localMessage("eapon5");	
	}

	return;
}

// Favorite ExitStation event, triggered in Support.cs
function Favorite::ExitStation()
{
	// Let others know we have left..
	$Favorite::InStation = False;

	// Mount Disc Launcher or first weapon in loadout
	if(getItemCount("Disc Launcher"))
	{
		use("Disc Launcher");
	}
	else
	{
		remoteEval(2048, nextWeapon);
	}

	return;
}

function Favorite::ItemDrop(%item)
{
	for(%i = getItemCount(%item); %i >= 1; %i--)
	{
		remoteEval(2048, dropItem, getItemType(%item));
	}
	
	return;
}

function Favorite::HeavyDrop()
{
	Favorite::ItemDrop("Plasma Bolt");
	Favorite::ItemDrop("Mortar Ammo");
	Favorite::ItemDrop("Mine");
	
	return;
}

function Favorite::ReceivedItem(%item)
{
	if(!$Favorite::DropPeaguns)
		return;
		
	// Get the Id of the %item we just picked up
	%itemId = getItemType(%item);
	
	// These are weapons, and all we care about
	%weapons = "11, 13, 15, 17, 19, 21, 22, 24";
	
	// If it isn't a weapon, bail..
	if(string::findsubstr(%weapons, %itemId) == -1)
		return;
	
	// Is it in our loadout?
	if(string::findsubstr($Favorite::Items[$Favorite::Selected], %itemId) == -1)
	{
		// Drop it!
		remoteEval(2048, dropItem, %itemId);
		
		// Lets switch to a useful weapon!
		if(getItemCount("Disc Launcher"))
		{
			use("Disc Launcher");
		}
		else
		{
			remoteEval(2048, nextWeapon);
		}
	}
	
	return;
}

// Pea-Guns drop On/Off
function Favorite::PeaGunToggle()
{
 	$Favorite::DropPeaguns = !$Favorite::DropPeaguns;
 
	if ($Favorite::DropPeaguns)
	{
		remoteBP(2048, "<JC><F2>Scavenger mode is now: <F1>ON", 2);
  	} 
	else
	{
  		remoteBP(2048, "<JC><F2>Scavenger mode is now: <F0>OFF", 2);
 	}

	return;
}


// Exec the loadout script
Favorite::GetLoads();
