////////////////////////////////////////////////////////////
// File:	FlagHUD.cs
// Version:	3.2
// Author:	Runar
// Credits:	Mr.Poop for the Icons. Crunchy for the 
//		Target-flagpart's. Freaky for the hints on
//		how to deal with the team and flag id's.
//		Presto, BigBunny, Blaster, z0dd.
//
// Info:	CTF FlagHUD that shows score and location of
//		the flags. It has pop-up HUD that indicates
//		the location of the flags if they're not in
//		the base and closes on flag-returns. It alse
//		displays a drop-timer when the flag is
//		dropped in the field. It has built in auto-
//		target flagtaker.
//
// Version 3.2	New blue gui look. Integrated TeamSizeHud.
//
// Version 1.7	Fixed the flag-target bug.
//		Now cancels escort msg if the flag is dropped.
//
// Version 1.6	Now using Presto compatible messages, with
//		the addition of %client wich is the name of
//		client. No need to get the names twice right?
//		Also rewrote the TargetFlag parts a bit, now
//		we use the %clientId to target on flagTaken,
//		since it is a bit faster. Still stuck with
//		targetClientByname when changing target.
//
// Version 1.5	Hade to change parts of the message parsing
//		to handle the observer-mode correct.
//
// Version 1.4	Made some changes, should handle the TrakHUD
//		correct when in observer-mode. When you're
//		in obs-mode you're treated as if you were in
//		Team0, eg. if(%teamId <= 0). Tnx for the tip
//		Freaky, u the man!!
//
// Version 1.3	Rewrote the events and variable parts.
//
// Version 1.2: Major cleanup on events, Flag-tracker works!
//
// Version 1.1:	Added Highlighted Icons depending on target
//		for flagtracker.
//
////////////////////////////////////////////////////////////

// This is were we keep our "rippped-off" bitmaps :)
$Viking::BMPdir = "Viking\\BMP\\";

// Make sure we dont create by mistake
$FlagHUD::Exist = "False";

// Auto-Target-Flag parms
$FlagHUD::IdxTarget = 2;
$FlagHUD::MaxTarget = 2;

// FlagHUD "Events"
Event::Attach(eventLoadPlayGui, FlagHUD::Create);
Event::Attach(eventExit, FlagHUD::Destroy);
Event::Attach(eventMissionInfo, FlagHUD::Reset);
Event::Attach(eventClientJoin, TsizeHUD::Update);
Event::Attach(eventClientDrop, TsizeHUD::Update);
Event::Attach(eventClientChangeTeam, TsizeHUD::Update);
Event::Attach(eventClientChangeTeam, FlagHUD::onClientChangeTeam);
Event::Attach(eventFlagTaken, FlagHUD::FlagTaken);
Event::Attach(eventFlagDropped, FlagHUD::FlagDropped);
Event::Attach(eventFlagReturned, FlagHUD::FlagReturned);
Event::Attach(eventFlagCaptured, FlagHUD::FlagCaptured);
Event::Attach(eventFlagTimer, TrakHUD::Update);

// Hud creation
function FlagHUD::Create()
{
	if($FlagHUD::Exist)
	{
		FlagHUD::Update();
		return;
	}

	// Get resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Delete old objects
	FlagHUD::Destroy();
		
	// Make sure we don't double it!
	$FlagHUD::Exist = "True";

	// Here's the main container
	%hudContainer=newObject("FlagHUD_Container", SimGui::Control, 10, %y - 60, 200, 50);

	// Here's the background
	%hudBG=newObject("FlagHUD_BG", FearGuiFormattedText, 0, 0, 40, 50);

	// Here's the flagicons
	%ourFlagIcon=newObject("FlagHUD_ourFlagIcon", FearGuiFormattedText, 0, 0, 40, 25);
	%nmyFlagIcon=newObject("FlagHUD_nmyFlagIcon", FearGuiFormattedText, 0, 25, 40, 25);

	%ourFlagLocation=newObject("FlagHUD_ourFlagLocation", FearGuiFormattedText, 50, 0, 100, 25);
	%nmyFlagLocation=newObject("FlagHUD_nmyFlagLocation", FearGuiFormattedText, 50, 25, 100, 25);

	%ourIcon=newObject("FlagHUD_ourIcon", FearGuiFormattedText, 160, 0, 40, 25);
	%nmyIcon=newObject("FlagHUD_nmyIcon", FearGuiFormattedText, 160, 25, 40, 25);

	// Add icons to container
	addToSet("FlagHUD_Container", %hudBG);
	addToSet("FlagHUD_Container", %ourFlagIcon);
	addToSet("FlagHUD_Container", %nmyFlagIcon);
	addToSet("FlagHUD_Container", %ourFlagLocation);
	addToSet("FlagHUD_Container", %nmyFlagLocation);
	addToSet("FlagHUD_Container", %ourIcon);
	addToSet("FlagHUD_Container", %nmyIcon);
	
	// Add the whole container to PlayGui
	addToSet(PlayGui, %hudContainer);

	// Add the blue bitmap
	control::setValue("FlagHUD_BG", "<B0,0:"@$Viking::BMPdir@"FlagHudBG.bmp>");
	
	// Update the HUD to set values
	FlagHUD::Update();
	TrakHUD::Update();
	TsizeHUD::Update();
}

function FlagHUD::Update()
{
	%teamId = $TT::Client::Team[$myId];

	// Simulate Team0 if we are observers
	if(%teamId == "0" || %teamId == "-1")
	{
		%ourTeamId = 0;
		%nmyTeamId = 1;
	}
	else
	{
		%ourTeamId = 1;
		%nmyTeamId = 0;
	}

	if($FlagHUD::IdxTarget == %ourTeamId)
	{
		control::setValue("FlagHUD_ourFlagIcon", "<B0,0:"@$Viking::BMPdir@"OurFlagOn.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Score[%ourTeamId]@".bmp>");
		control::setValue("FlagHUD_nmyFlagIcon", "<B0,0:"@$Viking::BMPdir@"NmyFlagOff.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Score[%nmyTeamId]@".bmp>");
  	}
	else if($FlagHUD::IdxTarget == %nmyTeamId)
	{
		control::setValue("FlagHUD_ourFlagIcon", "<B0,0:"@$Viking::BMPdir@"OurFlagOff.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Score[%ourTeamId]@".bmp>");
		control::setValue("FlagHUD_nmyFlagIcon", "<B0,0:"@$Viking::BMPdir@"NmyFlagOn.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Score[%nmyTeamId]@".bmp>");
 	}
	else
	{
		control::setValue("FlagHUD_ourFlagIcon", "<B0,0:"@$Viking::BMPdir@"OurFlagOff.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Score[%ourTeamId]@".bmp>");
		control::setValue("FlagHUD_nmyFlagIcon", "<B0,0:"@$Viking::BMPdir@"NmyFlagOff.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Score[%nmyTeamId]@".bmp>");
	}

	return; 
}
	
function TrakHUD::Update()
{
	%teamId = $TT::Client::Team[$myId];

	// Simulate Team0 if we are observers
	if(%teamId == "0" || %teamId == "-1")
	{
		%ourFlagId = 0;
		%nmyFlagId = 1;
	}	
	else
	{
		%ourFlagId = 1;
		%nmyFlagId = 0;
	}

	control::setValue("FlagHUD_ourFlagLocation", "<F2>" @ $TT::Flag::Location[%ourFlagId] @ "<F2> " @ $TT::Flag::Time[%ourFlagId] @ "  ");
	control::setValue("FlagHUD_nmyFlagLocation", "<F2>" @ $TT::Flag::Location[%nmyFlagId] @ "<F2> " @ $TT::Flag::Time[%nmyFlagId] @ "  ");

	return;
}

function TsizeHUD::Update()
{
	%teamId = $TT::Client::Team[$myId];

	// Simulate Team0 if we are observers
	if(%teamId == "0" || %teamId == "-1")
	{
		%ourTeamId = 0;
		%nmyTeamId = 1;
	}
	else
	{
		%ourTeamId = 1;
		%nmyTeamId = 0;
	}

	control::setValue("FlagHUD_ourIcon", "<B0,0:"@$Viking::BMPdir@"OurIcon.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Count[%ourTeamId]@".bmp>");
	control::setValue("FlagHUD_nmyIcon", "<B0,0:"@$Viking::BMPdir@"NmyIcon.bmp><B0,5:"@$Viking::BMPdir@"Number_"@$TT::Team::Count[%nmyTeamId]@".bmp>");

	return;
}

function FlagHUD::Reset()
{
	FlagHUD::Update();
	TrakHUD::Update();
}

function FlagHUD::Destroy()
{
	HUD::Destroy("FlagHUD_");
	HUD::Destroy("FlagHUD_");
	$FlagHUD::Exist = "False";
}

// FlagHUD events
function FlagHUD::FlagTaken(%flagId, %clientId, %client)
{
	// Update the HUD		
	TrakHUD::Update();

	// Target the capper if selected
	if(%flagId == $FlagHUD::IdxTarget)
		FlagHUD::AutoTarget(%flagId);
}

function FlagHUD::FlagDropped(%flagId, %clientId, %client)
{
	// Cancel Escort-msg if enabled, dont care about Id
	if($FlagHUD::SayEscort)
		Schedule::Cancel(FlagHUD::EscortMsg);
}

function FlagHUD::FlagReturned(%flagId, %clientId, %client)
{
	TrakHUD::Update();
}

function FlagHUD::FlagCaptured(%flagId, %clientId, %client)
{
	FlagHUD::Update();
	TrakHUD::Update();
}

function FlagHUD::onClientChangeTeam(%clientId, %team)
{
	// Only update if it's you
	if(%clientId == $myId)
	{
		FlagHUD::Update();
		TrakHUD::Update();
	}
	return;
}

function FlagHUD::TargetToggle()
{
	// Add one to Index
	$FlagHUD::IdxTarget++;

	// Check if we should start over
	if($FlagHUD::IdxTarget > $FlagHUD::MaxTarget)
        	$FlagHUD::IdxTarget = 0;

	// Try to target our waypoint
	FlagHUD::AutoTarget($FlagHUD::IdxTarget);

	// Show our target on the flagicons
	FlagHUD::Update();
}

function FlagHUD::AutoTarget(%flagId)
{
	// Check which flag this is
	if(%flagId != $TT::Client::Team[$myId])
	{
		if($TT::Flag::ClientId[%flagId] != $myId)
			targetClientById($TT::Flag::ClientId[%flagId], "Escort the flag carrier " @ $TT::Flag::Location[%flagId] @ ". ~wescfr");
	}
	else
	{
		targetClientById($TT::Flag::ClientId[%flagId], "Kill the enemy flag carrier " @ $TT::Flag::Location[%flagId] @ "! ~wattway");
	}
}

function FlagHUD::TargetFlag(%flagId)
{
	// Check which flag this is
	if(%flagId != $TT::Client::Team[$myId])
	{
		// Check to se if the flag is Home, Dropped or carried by You!
		if($TT::Flag::Location[%flagId] == "Home" || $TT::Flag::Location[%flagId] == "Dropped" || $TT::Flag::Location[%flagId] == $TT::Client::Name[$myId])
		{
			return;
		}
		else
		{
			// Target our friendly capper
			targetClientById($TT::Flag::ClientId[%flagId], "Escort the flag carrier " @ $TT::Flag::Location[%flagId] @ " ~wescfr");

			// Say you are escorting if enabled
			if($FlagHUD::SayEscort)
				say(1, "Got your waypoint " @ $TT::Flag::Location[%flagId] @ ", moving to escort! ~wtgtacq");
		}
	}
	else
	{
		// Check to se if the flag is Home or Dropped
		if($TT::Flag::Location[%flagId] == "Home" || $TT::Flag::Location[%flagId] == "Dropped")
		{
			return;
		}
		else
		{
			// Target the enemy capper
			targetClientById($TT::Flag::ClientId[%flagId], "Kill the enemy flag carrier " @ $TT::Flag::Location[%flagId] @ "! ~wattway");
		}
	}
}