////////////////////////////////////////////////////////////
// File:	ItemHUD.cs
// Version:	3.2
// Author:	Runar
// Credits:	Presto, Crunchy, Mr.Poop
// Info:	This HUD is practically Crunchy's ItemHUD
//		that i just modified to work without Presto.
//
//		3.2 Background added
//
////////////////////////////////////////////////////////////

$Viking::BMPdir = "Viking\\BMP\\";
$ItemHUD::Exist = "False";

Event::Attach(eventLoadPlayGui, ItemHUD::Create);
Event::Attach(eventGuiOpen, ItemHud::playGuiOpen);
Event::Attach(eventGuiClose, ItemHud::playGuiClose);
Event::Attach(eventExit, ItemHUD::Destroy);

// Create HUD, if exists Update
function ItemHUD::Create()
{
	if($ItemHUD::Exist)
	{
		echo("ItemHUD::Exists!");
		ItemHUD::Update();
		return;
	}

	// Screen resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");
	
	// Just to make sure we delete any stale objects
	ItemHUD::Destroy();
	
	// Make sure we don't double it!
	$ItemHUD::Exist = "True";

	// Here's the main container
	%hudContainer=newObject("ItemHUD_Container", SimGui::Control, %x - 150, %y - 60, 140, 50);

	// Here's the new blue background
	%hudBG=newObject("ItemHUD_BG", FearGuiFormattedText, 0, 0, 140, 50);

	// Here's the itemicons
	%MineIcon=newObject("ItemHUD_MineIcon", FearGuiFormattedText, 5, 0, 25, 50);
	%GrenIcon=newObject("ItemHUD_GrenIcon", FearGuiFormattedText, 40, 0, 25, 50);
	%BeacIcon=newObject("ItemHUD_BeacIcon", FearGuiFormattedText, 75, 0, 25, 50);
	%RKitIcon=newObject("ItemHUD_RKitIcon", FearGuiFormattedText, 110, 0, 25, 50);

	addToSet("ItemHUD_Container", %hudBG);
	addToSet("ItemHUD_Container", %MineIcon);
	addToSet("ItemHUD_Container", %GrenIcon);
	addToSet("ItemHUD_Container", %BeacIcon);
	addToSet("ItemHUD_Container", %RKitIcon);
	
	// Add the whole container to PlayGui
	addToSet(PlayGui, %hudContainer);

	// Add the blue bitmap
	control::setValue("ItemHUD_BG", "<B0,0:"@$Viking::BMPdir@"ItemHudBG.bmp>");

	// Update the HUD to set values
	ItemHUD::Update();
}

function ItemHUD::Update()
{
	%Mine = getItemCount("Mine");
	%Gren = getItemCount("Grenade");
	%Beac = getItemCount("Beacon");
	%RKit = getItemCount("Repair Kit");

	control::setValue("ItemHUD_MineIcon", "<B0,0:"@$Viking::BMPdir@"hud_mine.bmp><B-20,30:"@$Viking::BMPdir@"Number_"@%Mine@".bmp>");
	control::setValue("ItemHUD_GrenIcon", "<B0,0:"@$Viking::BMPdir@"hud_handgren.bmp><B-20,30:"@$Viking::BMPdir@"Number_"@%Gren@".bmp>");
	control::setValue("ItemHUD_BeacIcon", "<B0,0:"@$Viking::BMPdir@"hud_beacon.bmp><B-20,30:"@$Viking::BMPdir@"Number_"@%Beac@".bmp>");
	control::setValue("ItemHUD_RKitIcon", "<B0,0:"@$Viking::BMPdir@"hud_medpack.bmp><B-20,30:"@$Viking::BMPdir@"Number_"@%RKit@".bmp>");

	// Return in 1 second!
	Schedule::Add("ItemHUD::Update();", 1, "ItemHUD");
}

function ItemHUD::playGuiOpen(%gui)
{
	if(%gui == "playGui")
		ItemHUD::Update();

}

function ItemHUD::playGuiClose(%gui)
{
	if(%gui == "playGui")
		Schedule::Cancel("ItemHUD");

}

function ItemHUD::Destroy()
{
	HUD::Destroy("ItemHUD_");
	HUD::Destroy("ItemHUD_");
	$ItemHUD::Exist = "False";
}
