////////////////////////////////////////////////////////////
// File:	KillTrak.cs
// Version:	3.3
// Author:	Runar
// Credits:	Daerid
// Info:	Message parsing killtrack
//
// History:	3.3 Initial version
//
////////////////////////////////////////////////////////////

Event::Attach(eventClientMessage, KillTrak::Parse);
Event::Attach(EventClientJoin, KillTrak::ClientJoin);
Event::Attach(EventClientDrop, KillTrak::ClientDrop);
Event::Attach(EventChangeMission, KillTrak::ResetClients);
Event::Attach(EventConnected,KillTrak::ResetClients);

////////////////////////////////////////////////////////////

function KillTrak::DeathMessage(%msg, %weapon) 
{
	// Strip out the %1,%2 so we have a base message to compare to, and store a weapon for that message
	$KillTrak::Weapon[sprintf(%msg,"","","his","his")] = %weapon;
	$KillTrak::Weapon[sprintf(%msg,"","","her","her")] = %weapon;
	$KillTrak::Weapon[sprintf(%msg,"","","his","her")] = %weapon;
	$KillTrak::Weapon[sprintf(%msg,"","","her","his")] = %weapon;

	// Check to see the format for this msg
	%pos["%1"] = String::FindSubStr(%msg, "%1");
	%pos["%2"] = String::FindSubStr(%msg, "%2");
  
	%kfirst = (%pos["%1"] < %pos["%2"]);

	$KillTrak::KillerFirst[sprintf(%msg,"","","his","his")] = 
	$KillTrak::KillerFirst[sprintf(%msg,"","","her","her")] = 
	$KillTrak::KillerFirst[sprintf(%msg,"","","his","her")] = 
	$KillTrak::KillerFirst[sprintf(%msg,"","","her","his")] = %kfirst;

	%single = (%pos["%1"] == -1);

	$KillTrak::Single[sprintf(%msg,"","","his","his")] = 
	$KillTrak::Single[sprintf(%msg,"","","her","her")] = 
	$KillTrak::Single[sprintf(%msg,"","","his","her")] = 
	$KillTrak::Single[sprintf(%msg,"","","her","his")] = %single;
}

function KillTrak::Parse(%clientId, %msg)
{
	%names = 0;

	for(%i = 1; %i <= $KillTrak::NumClients; %i++)
	{
		%name = $TT::Client::Name[$KillTrak::ClientList[%i]];

    		if((%pos = String::FindSubStr(%msg, %name))!= -1)
		{
			%names++;
			%name[%names] = %name;
			%pos[%names] = %pos;
		}
	}

	// No names found?
	if(%names == 0)
	{
		return true;
	}

	%base = String::Slice(%msg, %name1);
	%base = String::Slice(%base, %name2);

	if((%wpn = $KillTrak::Weapon[%base]) == "")
	{
		return true;
	}
  	else
	{
    		if($KillTrak::KillerFirst[%base] == (%pos1 < %pos2))
		{
			%killer = getClientByName(%name1);
			%victim = getClientByName(%name2);
		}
		else
		{
			%killer = getClientByName(%name2);
			%victim = getClientByName(%name1);
		}

		//$KillTrak::Weapon = %wpn;

    		if($KillTrak::Single[%base])
		{
			%killer = %victim;
		}

		//echo("Kill! Victim: " @ %victim @ " Killer: " @ %killer @ " Weapon: " @ %wpn);
		Event::Trigger(EventKillTrak, 2048, %victim, %killer, %wpn);
		return false;
	}

	return true;
}

function KillTrak::ClientJoin(%client)
{
	$KillTrak::NumClients++;
	$KillTrak::ClientList[$KillTrak::NumClients] = %client;
	$KillTrak::ClientIdx[%client] = $KillTrak::NumClients;

	//echo("Added Client " @ %client @ " to KillTrak.");
}

function KillTrak::ClientDrop(%client)
{
	%lastClient = $KillTrak::ClientList[$KillTrak::NumClients];
	%thisIDX = $KillTrak::ClientIdx[%client];
	$KillTrak::ClientList[%thisIdx] = %lastClient;
	$KillTrak::ClientIdx[%lastClient] = %thisIdx;
	$KillTrak::ClientIdx[%client] = "";
	$KillTrak::ClientList[$KillTrak::NumClients] = "";
	$KillTrak::NumClients--;

	//echo("Removed Client " @ %client @ " from KillTrak.");
}

function KillTrak::ResetClients()
{
	deleteVariables("KillTrak::Client*");
	$KillTrak::NumClients = 0;

	for(%clientId = 2048 ; %clientId < 2180 ; %clientId++)
	{
		if(Client::GetName(%clientId)!="")
      			KillTrak::ClientJoin(%clientId);
	}
}

function KillTrak::Reset() 
{
	deleteVariables("KillTrak::*");
	$KillTrak::NumClients = 0;
}

// Support functions
function String::len(%string)
{
	for(%length=0; String::getSubStr(%string, %length, 1) != ""; %length++) {} 
	return %length;
}

function String::Slice(%string,%substr)
{
	if ((%idx = String::FindSubStr(%string,%substr)) == -1)
		return %string;
	else
	{
		%left = String::GetSubStr(%string,0,%idx);
		%lensub = String::Len(%substr);
		%idxstart = %idx+%lensub;
		%right = String::GetSubStr(%string,%idxstart,1024);
		return %left @ %right;
	}
}

// Suicide
KillTrak::DeathMessage("%2 ends it all.", "Suicide");
KillTrak::DeathMessage("%2 takes %3 own life.", "Suicide");
KillTrak::DeathMessage("%2 kills %3 own dumb self.", "Suicide");
KillTrak::DeathMessage("%2 decides to see what the afterlife is like.", "Suicide");

// Disc Launcher
KillTrak::DeathMessage("%2 catches a Frisbee of Death thrown by %1.", "Disc Launcher");
KillTrak::DeathMessage("%1 blasts %2 with a well-placed disc.", "Disc Launcher");
KillTrak::DeathMessage("%1's spinfusor caught %2 by surprise.", "Disc Launcher");
KillTrak::DeathMessage("%2 falls victim to %1's Stormhammer.", "Disc Launcher");

// Chaingun
KillTrak::DeathMessage("%1 ventilates %2 with %3 chaingun.", "Chaingun");
KillTrak::DeathMessage("%1 gives %2 an overdose of lead.", "Chaingun");
KillTrak::DeathMessage("%1 fills %2 full of holes.", "Chaingun");
KillTrak::DeathMessage("%1 guns down %2.", "Chaingun");

// Mines and Grenades
KillTrak::DeathMessage("%1 blows %2 up real good.", "Explosives");
KillTrak::DeathMessage("%2 gets a taste of %1's explosive temper.", "Explosives");
KillTrak::DeathMessage("%1 gives %2 a fatal concussion.", "Explosives");
KillTrak::DeathMessage("%2 never saw it coming from %1.", "Explosives");

// Mortar
KillTrak::DeathMessage("%1 mortars %2 into oblivion.", "Mortar Gun");
KillTrak::DeathMessage("%2 didn't see that last mortar from %1.", "Mortar Gun");
KillTrak::DeathMessage("%1 inflicts a mortal mortar wound on %2.", "Mortar Gun");
KillTrak::DeathMessage("%1's mortar takes out %2.", "Mortar Gun");

// Teamkill
KillTrak::DeathMessage("%1 mows down %3 teammate, %2", "Teamkill");
KillTrak::DeathMessage("%1 killed %3 teammate, %2 with a mine.","Teamkill");

// Laser Rifle
KillTrak::DeathMessage("%1 adds %2 to %3 list of sniper victims.", "Laser Rifle");
KillTrak::DeathMessage("%1 fells %2 with a sniper shot.", "Laser Rifle");
KillTrak::DeathMessage("%2 becomes a victim of %1's laser rifle.", "Laser Rifle");
KillTrak::DeathMessage("%2 stayed in %1's crosshairs for too long.", "Laser Rifle");

// Turret
KillTrak::DeathMessage("%2 dies of turret trauma.", "Turret");
KillTrak::DeathMessage("%2 is chewed to pieces by a turret.", "Turret");
KillTrak::DeathMessage("%2 walks into a stream of turret fire.", "Turret");
KillTrak::DeathMessage("%2 ends up on the wrong side of a turret.", "Turret");
KillTrak::DeathMessage("%2 dies.", "Turret");

// Plasma Gun
KillTrak::DeathMessage("%2 feels the warm glow of %1's plasma.", "Plasma Gun");
KillTrak::DeathMessage("%1 gives %2 a white-hot plasma injection.", "Plasma Gun");
KillTrak::DeathMessage("%1 asks %2, 'Got plasma?'", "Plasma Gun");
KillTrak::DeathMessage("%1 gives %2 a plasma transfusion.", "Plasma Gun");

// Blaster
KillTrak::DeathMessage("%2 gets a blast out of %1.", "Blaster");
KillTrak::DeathMessage("%2 succumbs to %1's rain of blaster fire.", "Blaster");
KillTrak::DeathMessage("%1's puny blaster shows %2 a new world of pain.", "Blaster");
KillTrak::DeathMessage("%2 meets %1's master blaster.", "Blaster");

// Falling
KillTrak::DeathMessage("%2 falls to %3 death.", "Landing");
KillTrak::DeathMessage("%2 forgot to tie %3 bungie cord.", "Landing");
KillTrak::DeathMessage("%2 bites the dust in a forceful manner.", "Landing");
KillTrak::DeathMessage("%2 fall down go boom.", "Landing");

// Vehicle
KillTrak::DeathMessage("%1 makes quite an impact on %2.", "Impact");
KillTrak::DeathMessage("%2 becomes the victim of a fly-by from %1.", "Impact");
KillTrak::DeathMessage("%2 leaves a nasty dent in %1's fender.", "Impact");
KillTrak::DeathMessage("%1 says, 'Hey %2, you scratched my paint job!'", "Impact");

// ELF Gun
KillTrak::DeathMessage("%2 gets zapped with %1's ELF gun.", "ELF Gun");
KillTrak::DeathMessage("%1 gives %2 a nasty jolt.", "ELF Gun");
KillTrak::DeathMessage("%2 gets a real shock out of meeting %1.", "ELF Gun");
KillTrak::DeathMessage("%1 short-circuits %2's systems.", "ELF Gun");

// Debris
KillTrak::DeathMessage("%2 is a victim among the wreckage.", "Debris");
KillTrak::DeathMessage("%2 is killed by debris.", "Debris");
KillTrak::DeathMessage("%2 becomes a victim of collateral damage.", "Debris");
KillTrak::DeathMessage("%2 got too close to the exploding stuff.", "Debris");

// Missile
KillTrak::DeathMessage("%2 takes a missile up the keister.", "Missile");
KillTrak::DeathMessage("%2 gets shot down.", "Missile");
KillTrak::DeathMessage("%2 gets real friendly with a rocket.", "Missile");
KillTrak::DeathMessage("%2 feels the burn from a warhead.", "Missile");

// Crushed
KillTrak::DeathMessage("%2 didn't stay away from the moving parts.", "Crushed");
KillTrak::DeathMessage("%2 is crushed.", "Crushed");
KillTrak::DeathMessage("%2 gets smushed flat.", "Crushed");
KillTrak::DeathMessage("%2 gets caught in the machinery.", "Crushed");
