////////////////////////////////////////////////////////////
// File:	Messages.cs
// Version:	3.3
// Author:	Runar
// Credits:	Presto, BigBunny, Freaky Blaster, z0dd, Mr.Poop
// Info:	Message parsing to trigger stuff in events.cs
//
// History:	1.6 Added onReceiveMessage for picking up stuff.
//
//		1.5 Changed to Presto-compatible %flagId, %clientId
//		but still have the name in %client.
//
////////////////////////////////////////////////////////////

// We only want to parse Station and Flag msg's
function onClientMessage(%client, %msg)
{
	// Make sure we only check server-msg's
	if(%client)
	{
		$lastClientMessage = %client;
		return true;
	}
	else if($ActiveMode != "True")
	{
		if(String::findSubStr(%msg, "flag") != -1 )
		{
			onFlagMessage(%client, %msg);
		}
		else if(String::findSubStr(%msg, "Station Access") != -1)
		{
			onStationMessage(%client, %msg);
		}
		else if(String::findSubStr(%msg, "You received") != -1 )
		{
			onReceiveMessage(%client, %msg);
		}
		else if($BWclient != "True" && $Viking::KillTrak)
		{
			return Event::Trigger(eventClientMessage, %client, %msg);
		}
	}

	return true;
}

function onStationMessage(%client, %msg)
{
	if(%msg == "Station Access On")
	{
		Event::Trigger(eventEnterStation, 1, "True", "True");
	}
	else if(%msg == "Station Access Off")
	{
		Event::Trigger(eventExitStation, %client, %msg);
	}

	return true;
}

function onFlagMessage(%client, %msg)
{
	if(String::findSubStr(%msg, "took the") != -1 )			// client took a flag
	{
		%client = String::getSubStr(%msg, 0, String::findSubStr(%msg, "took the")-1);

		// Make sure we trade "You" for your real name
		if(%client == "You")
		{
			%clientId = $myId;
			%client = $TT::Client::Name[$myId];
		}
		else
		{
			%clientId = getClientByName(%client);
		}
		
		%flagId = 1 - $TT::Client::Team[%clientId];
		
		Event::Trigger(eventFlagTaken, %flagId, %clientId, %client);
	}

	else if(String::findSubStr(%msg, "dropped the") != -1)		// client dropped a flag
	{
		%client = String::getSubStr(%msg, 0, String::findSubStr(%msg, "dropped the")-1);

		// Make sure we trade "You" for your real name
		if(%client == "You")
		{
			%clientId = $myId;
			%client = $TT::Client::Name[$myId];
		}
		else
		{
			%clientId = getClientByName(%client);
		}
		
		%flagId = 1 - $TT::Client::Team[%clientId];
		
		Event::Trigger(eventFlagDropped, %flagId, %clientId, %client);
	}	
	else if(String::findSubStr(%msg, "returned the") != -1)		// client returned a flag
	{
		%client = String::getSubStr(%msg, 0, String::findSubStr(%msg, "returned the")-1);

		// Make sure we trade "You" for your real name
		if(%client == "You")
		{
			%clientId = $myId;
			%client = $TT::Client::Name[$myId];
		}
		else
		{
			%clientId = getClientByName(%client);
		}

		%flagId = $TT::Client::Team[%clientId];

		Event::Trigger(eventFlagReturned, %flagId, %clientId, %client);
	}
	else if(String::findSubStr(%msg, "Your flag was returned") != -1)
	{
		%flagId = $TT::Client::Team[$myId];

		Event::Trigger(eventFlagReturned, %flagId, 0, "Auto");	// "Your" flag was auto-returned
	}
	else if(String::findSubStr(%msg, "The " @ $TT::Team::Name[0] @ " flag was returned") != -1)
	{
		Event::Trigger(eventFlagReturned, 0, 0, "Auto");	// Team0 flag was auto-returned
	}
	else if(String::findSubStr(%msg, "The " @ $TT::Team::Name[1] @ " flag was returned") != -1)
	{
		Event::Trigger(eventFlagReturned, 1, 0, "Auto");	// Team1 flag was auto-returned
	}
	else if(string::findsubstr(%msg, "captured the") != -1)		// client captured a flag
	{
		%client = String::getSubStr(%msg, 0, String::findSubStr(%msg, "captured the")-1);

		if(%client == "Your team")
			return true;

		// Make sure we trade "You" for your real name
		if(%client == "You")
		{
			%clientId = $myId;
			%client = $TT::Client::Name[$myId];
		}
		else
		{
			%clientId = getClientByName(%client);
		}

		%flagId = 1 - $TT::Client::Team[%clientId];

		Event::Trigger(eventFlagCaptured, %flagId, %clientId, %client);
	}

	return true;
}

function onReceiveMessage(%client, %msg)
{
	Event::Trigger(eventReceivedItem, String::getSubStr(%msg, 15, 1024));
	
	return true;
}
