////////////////////////////////////////////////////////////
// File:	PopUp.cs
// Version:	3.3
// Author:	Runar
// Credits:	Modified centerprints
// Info:	
//
//
////////////////////////////////////////////////////////////

$Viking::BMPdir = "Viking\\BMP\\";
$PopHUD::Exist = "False";

Event::Attach(eventLoadPlayGui, PopHUD::Create);
Event::Attach(eventExit, PopHUD::Destroy);

// Create HUD, if exists Update
function PopHUD::Create()
{
	if($PopHUD::Exist)
	{
		return;
	}

	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Just to make sure we delete any stale objects
	PopHUD::Destroy();
	
	// Make sure we don't double it!
	$PopHUD::Exist = "True";

	// Here's the FPS-icon
	%myCtrl=newObject("PopUp_T_Container", SimGui::Control, %x/4, %y-170, %x/2, 70);
	%myText=newObject("PopUp_T_Text", FearGuiFormattedText, 0, 0, %x/2, 70);
	addToSet(%myCtrl, %myText);
	addToSet(PlayGui, %myCtrl);

	%myCtrl=newObject("PopUp_C_Container", SimGui::Control, %x/4, 100, %x/2, 240);
	%myText=newObject("PopUp_C_Text", FearGuiFormattedText, 0, 0, %x/2, 240);
	addToSet(%myCtrl, %myText);
	addToSet(PlayGui, %myCtrl);

	%myCtrl=newObject("PopUp_B_Container", SimGui::Control, %x/4, %y-100, %x/2, 70);
	%myText=newObject("PopUp_B_Text", FearGuiFormattedText, 0, 0, %x/2, 70);
	addToSet(%myCtrl, %myText);
	addToSet(PlayGui, %myCtrl);

	Control::SetVisible("PopUp_T_Container", "False");
	Control::SetVisible("PopUp_C_Container", "False");
	Control::SetVisible("PopUp_B_Container", "False");
}

function RemoteBP(%Id, %msg, %time)
{
	if(%Id != 2048)
		return;

	if(%time)
		Schedule::Add("Viking::PopClear(\"PopUp_B_Container\");", %time);

	Control::SetValue("PopUp_B_Text", "<JC>" @ %msg);
	Control::SetVisible("PopUp_B_Container", "True");
	
}

function RemoteCP(%Id, %msg, %time)
{
	if(%Id != 2048)
		return;

	if(%time)
		Schedule::Add("Viking::PopClear(\"PopUp_C_Container\");", %time);

	Control::SetValue("PopUp_C_Text", "<JC>" @ %msg);
	Control::SetVisible("PopUp_C_Container", "True");
	
}

function RemoteTP(%Id, %msg, %time)
{
	if(%Id != 2048)
		return;

	if(%time)
		Schedule::Add("Viking::PopClear(\"PopUp_T_Container\");", %time);

	Control::SetValue("PopUp_T_Text", "<JC>" @ %msg);
	Control::SetVisible("PopUp_T_Container", "True");
}

function Viking::PopClear(%object)
{
	Control::SetVisible(%object, "False");
}

function PopHUD::Destroy()
{
	HUD::Destroy("PopUp_");
	HUD::Destroy("PopUp_");
	$PopHUD::Exist = "False";
}
