////////////////////////////////////////////////////////////
// File:	TeamHUD.cs
// Version: 	3.2
// Author:	Runar
// Credits:	Freaky for his version
// Info:	Displays clients, teams, kills and deaths
//		Requires my TeamTrack.cs
//
// History: 	1.0 Initial version
//
////////////////////////////////////////////////////////////

// Variables we need
$TeamHUD::Team = 0;
$TeamHUD::Exist = "False";

// TeamHUD events
Event::Attach(eventLoadPlayGui, TeamHUD::Create);
Event::Attach(eventExit, TeamHUD::Destroy);
Event::Attach(eventClientJoin, TeamHUD::ClientEvent);
Event::Attach(eventClientDrop, TeamHUD::ClientEvent);
Event::Attach(eventClientChangeTeam, TeamHUD::ClientEvent);
Event::Attach(eventMissionInfo, TeamHUD::ClientEvent);
Event::Attach(eventKillTrak, TeamHUD::ClientEvent);

function TeamHUD::Create()
{
	// Don't want two of this
	if($TeamHUD::Exist)
		return;

	// Get resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Destroy old objects
	TeamHUD::Destroy();
	
	// Here's the main container
	%hudContainer=newObject("TeamHUD_Container", SimGui::Control, %x - 200, %y / 3, 200, 250);

	// Heres the background
	if($Viking::Border)
		%hudBackground=newObject("TeamHUD_BG", FearGui::FearGuiMenu, 0, 0, 200, 250);

	// Here is the actual text
	%hudText = newobject("TeamHUD_Text",FearGuiFormattedText, 0, 0, 200, 250);

	// Add our controls to the container
	if($Viking::Border)
		addToSet("TeamHUD_Container", %hudBackground);

	addToSet("TeamHUD_Container", %hudText);
	addToSet(PlayGui, %hudContainer);

	// Dont want it visible yet
	Control::setVisible(TeamHUD_Container, "False");

	// Make sure we don't double it!
	$TeamHUD::Exist = "True";
}

function TeamHUD::Update(%teamId)
{
	// No need to update if toggled Off
	if(Control::getVisible(TeamHUD_Container) != "True")
		return;

	if(%teamId == "")
		%teamId = $TeamHUD::Team;
		
	if(%teamId == -1)
	{
		%text = "<JL><F2> " @ $TT::Team::Name[%teamId] @ "\n\n";
	}
	else if(%teamId == $TT::Client::Team[$myId])
	{
		%text = "<JL><F1> " @ $TT::Team::Name[%teamId] @ "<JR><F2>" @ $TT::Team::Kills[%teamId] @ "/" @ $TT::Team::Deaths[%teamId] @ "  \n\n";
	}
	else
	{
		%text = "<JL><F0> " @ $TT::Team::Name[%teamId] @ "<JR><F2>" @ $TT::Team::Kills[%teamId] @ "/" @ $TT::Team::Deaths[%teamId] @ "  \n\n";
	}

	%clientId = 2049;
	
	while(%clientId != 2180)
	{
		if($TT::Client::Name[%clientId] != "")
		{
			if($TT::Client::Team[%clientId] == %teamId)
        		{
				%text = %text @ "<JL><F2>  " @ $TT::Client::Name[%clientId] @ "<JR><F2> " @ $TT::Client::Kills[%clientId] @ "/" @ $TT::Client::Deaths[%clientId] @ "  \n";
			}
		}
		
		%clientId++;
	}
	
	Control::setValue("TeamHUD_Text", %text);

}

function TeamHUD::ClientEvent()
{
	TeamHUD::Update($TeamHUD::Team);
}

function TeamHUD::Toggle()
{
	if(Control::getVisible(TeamHUD_Container))
	{
		Control::setVisible(TeamHUD_Container, "False");
	}
	else
	{
		Control::setVisible(TeamHUD_Container, "True");
		TeamHUD::Update($TeamHUD::Team);
	}
}

function TeamHUD::Next()
{
	$TeamHUD::Team++; 
	
	if($TeamHUD::Team == 2)
		$TeamHUD::Team = -1;
	
	if(Control::getVisible(TeamHUD_Container))
		TeamHUD::Update($TeamHUD::Team);

	remoteBP(2048, "<JC><F2>TeamTrack HUD Team set to: <F1>" @  $TT::Team::Name[$TeamHUD::Team], 2);
}

function TeamHUD::Prev()
{
	$TeamHUD::Team--; 
	
	if($TeamHUD::Team == -2)
		$TeamHUD::Team = 1;
	
	if(Control::getVisible(TeamHUD_Container))
		TeamHUD::Update($TeamHUD::Team);

	remoteBP(2048, "<JC><F2>TeamTrack HUD Team set to: <F1>" @  $TT::Team::Name[$TeamHUD::Team], 2);
}

function TeamHUD::Destroy()
{
        HUD::Destroy("TeamHUD_");
	HUD::Destroy("TeamHUD_");
        $TeamHUD::Exist = "False";
}
