////////////////////////////////////////////////////////////
// File:	ClockHUD.cs
// Version:	3.3
// Author:	Runar
// Credits:	
// Info:	Neato little clock
//
////////////////////////////////////////////////////////////

$ClockHUD::Exist = "False";

Event::Attach(eventLoadPlayGui, ClockHUD::Create);
Event::Attach(eventUpdateTime, ClockHUD::Update);
Event::Attach(eventExit, ClockHUD::Destroy);

////////////////////////////////////////////////////////////

// Create HUD, if exists Update
function ClockHUD::Create()
{
	if($ClockHUD::Exist)
	{
		return;
	}

	// Just to make sure we delete any stale objects
	ClockHUD::Destroy();

	// Calculate the position with the chathud
	%xp = getWord(Control::GetPosition("ChatHudBG_Container"), 0);
	%yp = getWord(Control::GetPosition("ChatHudBG_Container"), 1);
	%xs = getWord(Control::GetExtent("ChatHudBG_Container"), 0);
	%ys = getWord(Control::GetExtent("ChatHudBG_Container"), 1);
	%x = %xp + %xs - 45;
	%y = %yp + %ys - 20;

	// Make sure we don't double it!
	$ClockHUD::Exist = "True";

	// Here's the container
	%hudContainer=newObject("ClockHUD_Container", SimGui::Control, %x, %y, 40, 15);

	// Here's text object
	%hudText=newObject("ClockHUD_Text", FearGuiFormattedText, 0, 0, 16, 16);

	// Add text to container
	addToSet(%hudContainer, %hudText);
	
	// Add the container to PlayGui
	addToSet(PlayGui, %hudContainer);
}

function ClockHUD::Update(%min, %sec)
{
	$ClockHUD::Hours = floor(%min / 60);
	$ClockHUD::Minutes = %min % 60;
	$clockHud::Seconds = %sec;

	schedule::add("ClockHUD::Iterate();", 1);
}

function ClockHUD::Iterate()
{
	if($ClockHUD::Seconds > 0)
	{
		$ClockHUD::Seconds--;
	}
	else
	{
		$ClockHUD::Seconds = 59;
		
		if ($ClockHUD::Minutes > 0)
		{
			$ClockHUD::Minutes--;
		}
		else
		{
			$ClockHUD::Minutes = 59;
			$ClockHUD::Hours--;
		}
	}

	//echo("Clock: " @ LZero($ClockHUD::Hours) @ ":" @ LZero($ClockHUD::Minutes) @ ":" @ LZero($ClockHUD::Seconds));
	Control::setValue("ClockHUD_Text", "<F2>" @ LZero($ClockHUD::Hours) @ ":" @ LZero($ClockHUD::Minutes) @ ":" @ LZero($ClockHUD::Seconds));
	Schedule::Add("ClockHUD::Iterate();", 1);
}

function ClockHUD::Destroy()
{
	HUD::Destroy("ClockHUD_");
	HUD::Destroy("ClockHUD_");
	$ClockHUD::Exist = "False";
}


// Support function to add a zero if < 10
function LZero(%number)
{
	if(%number < 10)
		return "0" @ %number;
	else
		return %number;
}

// Tribes function override
function remoteSetTime(%serverId, %time)
{
	if(%serverId != 2048)
		return;

	setHudTimer(%time);
		
	Event::Trigger(eventUpdateTime, Time::GetMinutes((%time + 1) * -1), Time::GetSeconds((%time + 1) * -1));
}

