////////////////////////////////////////////////////////////
// File:	DeathHUD.cs
// Version:	3.3
// Author:	Runar
// Credits:	
// Info:	
//
//
////////////////////////////////////////////////////////////

$Viking::BMPdir = "Viking\\BMP\\";
$DeathHud::Exist = "False";
$DeathHud::Lines = "5";

Event::Attach(eventLoadPlayGui, DeathHud::Create);
Event::Attach(eventKillTrak, DeathHUD::KillTrak);
Event::Attach(EventConnected, DeathHUD::Reset);
Event::Attach(eventMissionInfo, DeathHUD::Reset);
Event::Attach(eventExit, DeathHud::Destroy);


////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
// Create HUD, if exists Update
function DeathHud::Create()
{
	if($DeathHud::Exist)
		return;

	// Get resolution
	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	// Just to make sure we delete any stale objects
	DeathHud::Destroy();
	
	// Make sure we don't double it!
	$DeathHud::Exist = "True";

	// Here's the main container
	%hudContainer=newObject("DeathHUD_Container", SimGui::Control, %x / 2 - 110, %y - 80, 220, 80);

	// Here's the FPS-icon
	%hudText=newObject("DeathHUD_Text", FearGuiFormattedText, 0, 0, 220, 80);

	// Add text to container
	addToSet(%hudContainer, %hudText);
	
	// Add the whole container to PlayGui
	addToSet(PlayGui, %hudContainer);
}

function DeathHud::KillTrak(%serverId, %victimId, %killerId, %damageType)
{
	if(%serverid != 2048)
		return;

	for(%i=1; %i < $DeathHud::Lines; %i++)
	{
		$DeathHud::Row[%i] = $DeathHud::Row[%i + 1];
	}

	if($TT::Client::Team[%killerId] == $TT::Client::Team[$myId])
    		%killer = "<F1>" @ $TT::Client::Name[%killerId];
  	else
    		%killer = "<F0>" @ $TT::Client::Name[%killerId];

	if($TT::Client::Team[%victimId] == $TT::Client::Team[$myId])
    		%victim = "<F1>" @ $TT::Client::Name[%victimId];
  	else
    		%victim = "<F0>" @ $TT::Client::Name[%victimId];

	$DeathHud::Row[$DeathHud::Lines] = %killer @ "<F2> --> " @ %victim @ " <F2>: " @ %damageType;

  	DeathHud::Update();
}

function DeathHud::Update()
{
	for(%i=1; %i <= $DeathHud::Lines; %i++)
		%string = %string @ escapestring($DeathHud::Row[%i]) @ "\n";

	Control::SetValue(DeathHud_Text, %string);
}

function DeathHud::Reset()
{
	for(%i=1; %i <= $DeathHud::Lines; %i++)
		$DeathHud::Row[%i] = "";

	Control::SetValue(DeathHud_Text, "");
}

function DeathHud::Destroy()
{
	HUD::Destroy("DeathHUD_");
	HUD::Destroy("DeathHUD_");
	$DeathHud::Exist = "False";
}
