////////////////////////////////////////////////////////////
// File:	Preferences.cs
// Version:	3.2
// Author:	Runar
// Credits:	Pernilla for putting up with me..
// Info:	Set all your preferences here..
//
// History:	3.2 Migrated Preferences and Bind_Keys.
//		3.0 Added MA screenie, and the new chainzoom.
//		1.1 Removed the Favorite loadouts and
//		moved them to Loadouts.cs instead for
//		easier upgrades.
//
////////////////////////////////////////////////////////////

// IMPORTANT! Every setting with a * is editable. Make sure
// you understand it before changing from it's default value.

// =========================================================
// KillTrak. Consumes cpu. May cause lag on lowend pc's
// =========================================================

// You will need this to get kill/death information on
// non Fstat/BWadmin servers. This will eliminate all
// Kill/Death information from the chathud on all non-
// Fstat/BWadmin servers.
$Viking::KillTrak = "false";

// =========================================================
// Ski, and JumpJet
// =========================================================

// * This is the "jump-delay" value. You may want to experiment
// a bit with this. z0dd use's 0.001, Poop 0.07 and BigBunny
// uses a value of 0.04. Default 0.003
$Jump:Delay = 0.003;

// Don't touch this line
editActionmap("playmap.sae");

// * Jump, as quick as we can!
bindCommand(keyboard0, make, "space", TO, "Jump::Start();");
bindCommand(keyboard0, break, "space", TO, "Jump::Stop();");

// * Auto jump when you jet, default on.
$Viking::JetJump = "true";

if($Viking::JetJump)
{
$Jet::Jump = "True";

// Don't touch this line
editActionmap("playmap.sae");

// * Jet, need this one..
bindCommand(mouse0, make, button1, TO, "Jet::Start();");
bindCommand(mouse0, break, button1, TO, "Jet::Stop();");

// * Jet & Jump Toggle, jump before you jet.
bindCommand(keyboard0, make, shift, "space", TO, "Jet::Toggle();");
bindCommand(keyboard0, break, shift, "space", TO, "");
}

// =========================================================
// Common Functions/Binds
// =========================================================

// Don't touch this line
editActionmap("playmap.sae");

// * Reposition all the gui-objects after install or res-change.
bindCommand(keyboard0, make, "f7", TO, "GUI::Position();");
bindCommand(keyboard0, break, "f7", TO, "");

// * Toss grenades with full force
//bindCommand(keyboard0, make, "g", TO, "Toss::Start(\"Grenade\");");
//bindCommand(keyboard0, break, "g", TO, "Toss::Stop(\"Grenade\");");

// * Toss mines with full force
//bindCommand(keyboard0, make, "f", TO, "Toss::Start(\"Mine\");");
//bindCommand(keyboard0, break, "f", TO, "Toss::Stop(\"Mine\");");

// * Drop Blaster and switch to Disc Launcher
//bindCommand(keyboard0, make, "x", TO, "drop(\"blaster\");");
//bindCommand(keyboard0, break, "x", TO, "use(\"Disc Launcher\");");

// * Mouse wheel to change weapon
bindCommand(mouse0, zaxis0, TO, "nextWeapon();");
bindCommand(mouse0, zaxis1, TO, "prevWeapon();");

// * Mouse wheel button to use backpack
bindCommand(mouse0, make, button2, TO, "use(\"Backpack\");");
bindCommand(mouse0, break, button2, TO, "");


// =========================================================
// Fast-Repair, auto-buy an use repkits
// =========================================================

// * Enable/Disable
$Viking::FastRepair = "false";

if($Viking::FastRepair = "false")
{
$Fastrep::Auto = "false";

// Don't touch this line
editActionmap("playmap.sae");

// * Fastrep Use, buy rep-kits and use them. 1 press is enough.
bindCommand(keyboard0, make, "capslock", TO, "Fastrep::Use();");
bindCommand(keyboard0, break, "capslock", TO, "");

// * Fastrep Toggle auto-use when entering inv.
bindCommand(keyboard0, make, shift, "capslock", TO, "Fastrep::Toggle();");
bindCommand(keyboard0, break, shift, "capslock", TO, "");
}

// =========================================================
// The CTF hud, Score, Flagcarriers, Droptimer, Waypoints
// =========================================================

// * Enable/disable
$Viking::FlagHUD = "True";

if($Viking::FlagHUD)
{
// * Announce when manual escort?
$FlagHUD::SayEscort = "True";

// Don't touch this line
editActionmap("playmap.sae");

// * Auto Waypoint/Target Your/Enemy/Off toggle
bindCommand(keyboard0, make, control, "a", TO, "FlagHUD::TargetToggle();");
bindCommand(keyboard0, break, control, "a", TO, "");

// * Manual target Enemy flag, escort capper
bindCommand(keyboard0, make, "f1", TO, "FlagHUD::TargetFlag(1 - Client::GetTeam(getManagerID()));");
bindCommand(keyboard0, break, "f1", TO, "");

// * Manual target Friendly flag, kill capper
bindCommand(keyboard0, make, "f2", TO, "FlagHUD::TargetFlag(Client::GetTeam(getManagerID()));");
bindCommand(keyboard0, break, "f2", TO, "");
}

// =========================================================
// ItemHud Preferences
// =========================================================

// * Enable/Disable
$Viking::ItemHUD = "True";

// =========================================================
// TeamHud Preferences
// =========================================================

// * Enable/disable
$Viking::TeamHUD = "True";

if($Viking::TeamHUD)
{
// Don't touch this line
editActionmap("playmap.sae");

// * Toggle TeamHUD On/Off
bindCommand(Keyboard0, make, "\\", TO, "TeamHUD::Toggle();");
bindCommand(keyboard0, break, "\\", TO, "");

// * Next TeamHUD Team
bindCommand(Keyboard0, make, "]", TO, "TeamHUD::Next();");
bindCommand(keyboard0, break, "]", TO, "");

// * Previous TeamHUD Team
bindCommand(Keyboard0, make, "[", TO, "TeamHUD::Prev();");
bindCommand(keyboard0, break, "[", TO, "");
}

// =========================================================
// DeathHud Preferences
// =========================================================

// * Enable/disable
$Viking::DeathHUD = "false";

// =========================================================
// CommanderHud Preferences
// =========================================================

// * Enable/Disable
$Viking::CmdView = "False";

if($Viking::CmdView)
{
// * Do we want the sensor range visible?
$CmdView::MapSensorRange = "True";

// * Do we want the sensor range translucent?
$CmdView::MapSensorTranslucent = "True";

// * Do we want object names on the map?
$CmdView::MapNames = "False";

// * Commander Map Filter, default "1"
// Bit 0 = Show Players
// Bit 1 = Show Turrets
// Bit 2 = Show Items
// Bit 3 = Show Objects
// Bit:  0123
// Val:  1248

$CmdView::MapFilter = "9";

// Don't touch this line
editActionMap("actionMap.sae");

// * Restore the original Commander
bindCommand(Keyboard0, make, "backspace", TO, "CmdView::Change();");
bindCommand(Keyboard0, break, "backspace", TO, "");

// Don't touch this line
editactionmap("playmap.sae");

// * Toggle the mini-commander on/off
bindCommand(keyboard0, make, "c", TO, "CmdView::Toggle();");
bindCommand(keyboard0, break, "c", TO, "");
}

// =========================================================
// AmmoHud Preferences
// =========================================================

// * Enable/Disable
$Viking::AmmoHud = "false";

// =========================================================
// ClockHud Preferences
// =========================================================

// * Enable/Disable
$Viking::ClockHud = "True";

// =========================================================
// ReticleCompass Preferences
// =========================================================

// * Enable/Disable
$Viking::RetCompass = "True";

// =========================================================
// Kills/Deaths Pop-up (Fstat and BWadmin only)
// =========================================================

// * Enable/Disable
$Viking::KillHUD = "false";

// =========================================================
// Flagevents Pop-up
// =========================================================

// * Enable/Disable
$Viking::FlagPop = "True";

// =========================================================
// Capper TV Preferences
// =========================================================

// * Enable/Disable
$Viking::ObsTV = "True";

if($Viking::ObsTV)
{
editActionmap("playmap.sae");

// Bind to obs current (or last) flagcarrier
bindCommand(keyboard0, make, "f10", TO, "TV::Carrier();");
bindCommand(keyboard0, break, "f10", TO, "TV::DeActivate();");

// Bind to activate menu to select player to obs.
bindCommand(keyboard0, make, "f11", TO, "TV::Menu();");
bindCommand(keyboard0, break, "f11", TO, "");

// Bind to re-obs last selected player
bindCommand(keyboard0, make, "f12", TO, "TV::Selected();");
bindCommand(keyboard0, break, "f12", TO, "TV::DeActivate();");
}

// =========================================================
// Pilot Mode Preferences
// =========================================================

// * Enable/Disable
$Viking::Pilot = "True";

if($Viking::Pilot)
{
// Sensitivity to use when piloting
$Pilot::pSense = 0.004;

// Flip Y controls when piloting
$pref::flipFlierY = "false";

// Don't touch this line
editActionmap("playmap.sae");

// * Pilot Mode activate/deactivate
bindCommand(keyboard0, make, "f4", TO, "Pilot::Toggle();");
bindCommand(keyboard0, break, "f4", TO, "");
}
// =========================================================
// SnipeZoom Preferences
// =========================================================

// * Enable/Disable
$Viking::SnipeZoom = "false";

if($Viking::SnipeZoom)
{
// * Switch to laser when you zoom? (Toggleable)
$Snipe::Switch = "false";

// * Sensitivity factor, 0.5 = 50%, 1.0 means no difference
$Snipe::Factor = 0.75;

// Don't touch this line
editActionmap("playmap.sae");

// * Snipe Zoom, replaces original zoom
bindCommand(keyboard0, make, "e", TO, "Snipe::Zoom();");
bindCommand(keyboard0, break, "e", TO, "Snipe::Unzoom();");

// * Toggle "switch to laser" On/Off
bindCommand(keyboard0, make, "f3", TO, "Snipe::Toggle();");
bindCommand(keyboard0, break, "f3", TO, "");
}

// =========================================================
// ChainZoom.cs Preferences
// =========================================================

// * Enable/Disable
$Viking::ChainZoom = "false";

// * Normal FOV (90 is default)
$Chain::NormFov = "90";

// * Chain FOV (I use the same as above, ie. no change..)
$Chain::ZoomFov = "90";

// * Sensitivity factor, 0.5 = 50%, 1.0 means no difference
$Chain::Factor = 0.75;

if($Viking::Chainzoom)
{
// Don't touch this line
editactionmap("playmap.sae");

// * Bind mouse button 1 to our own fire function
bindCommand(mouse0, make, button0, TO, "Viking::Fire(1);");
bindCommand(mouse0, break, button0, TO, "Viking::Fire(0);");
}

// =========================================================
// Mid-Air screenshot feature
// =========================================================

// * Take a screenshot when you do a "mid-air"?
$Viking::MAscreen = "false";

// * Delay for the screen-shot, may need some tuning.
$Viking::ScreenDelay = 0.3;

// Don't touch this line
editActionmap("playmap.sae");

// * Mid-Air screenshot Toggle
bindCommand(Keyboard0, make, "f8", TO, "MAscreen::Toggle();");
bindCommand(keyboard0, break, "f8", TO, "");


// =========================================================
// Dropper  Preferences
// =========================================================

// * Enable/Disable
$Viking::Dropper = "false";

// * Set up your Items to drop here, don't forget
// to change $Dropper::Max value to the highest no.
$Dropper::Item[0] = "Turret";
$Dropper::Item[1] = "Inventory Station";
$Dropper::Item[2] = "Repair Pack";
$Dropper::Item[3] = "Pulse Sensor";

// * Set this to the highest number in the "array"
$Dropper::Max = 3;

// * What Item do want as the default
$Dropper::Index = 0;

// * Delay between drop's. I use 0.1 for ISDN, 0.5 for modem?
$Dropper::Delay = 0.1;

if($Viking::Dropper)
{
// Don't touch this line
editActionmap("playmap.sae");

// * Dropper Next Item to drop
bindCommand(keyboard0, make, "right", TO, "Dropper::NextItem();");
bindCommand(keyboard0, break, "right", TO, "");

// * Dropper Previous Item to drop
bindCommand(keyboard0, make, "left", TO, "Dropper::PrevItem();");
bindCommand(keyboard0, break, "left", TO, "");

// * Dropper Drop! Litter the stuff!
bindCommand(keyboard0, make, "up", TO, "Dropper::Start();");
bindCommand(keyboard0, break, "up", TO, "Dropper::Stop();");
}

// =========================================================
// Local-taunts Preferences
// =========================================================

// * Enable/Disable
$Viking::Taunt = "True";

// Local cheers
$Taunt::Index = 1;
$Taunt::MaxIdx = 6;
$Taunt::Saying[1] = "taunt1";
$Taunt::Saying[2] = "taunt2";
$Taunt::Saying[3] = "taunt3";
$Taunt::Saying[4] = "taunt4";
$Taunt::Saying[5] = "taunt10";
$Taunt::Saying[6] = "dsgst2";

// Don't touch this line
editActionmap("playmap.sae");

// * Local-Taunts Toggle
bindCommand(Keyboard0, make, "f9", TO, "Taunt::Toggle();");
bindCommand(keyboard0, break, "f9", TO, "");

// =========================================================
// Modified CenterPrints
// =========================================================

// * Enable/Disable
$Viking::Popup = "True";

// =========================================================
// Modified Chatmenu
// =========================================================

// * Enable/Disable
$Viking::Chat = "True";

// =========================================================
// Incoming Enhanced chat
// =========================================================

// * Enable/Disable
$Viking::Incoming = "False";

if($Viking::Incoming)
{
// Don't touch this line
EditActionMap("PlayMap.sae");

// This is the key to activate "Incoming enemy!"
bindCommand(keyboard0, make, "NumpadEnter", TO, "Incoming::Activate();");
bindCommand(keyboard0, break, "NumpadEnter", TO, "");
}

// =========================================================
// FlagStand Waypoints
// =========================================================

// * Enable/Disable
$Viking::Waypoints = "True";

if($Viking::Waypoints)
{
// Don't touch this line
editActionmap("playmap.sae");

// * Waypoint your flag-stand
bindCommand(keyboard0, make, alt, "f", TO, "Viking::Waypoint(Client::GetTeam(getManagerID()));"); 
bindCommand(keyboard0, break, alt, "f", TO, ""); 

// * Waypoint enemy flag-stand 
bindCommand(keyboard0, make, alt, "e", TO, "Viking::Waypoint(1-Client::GetTeam(getManagerID()));"); 
bindCommand(keyboard0, break, alt, "e", TO, "");
}

// =========================================================
// Blue Translucent Mortar/Grenade rangefinders
// =========================================================

// * Enable/Disable
$Viking::RFinder = "false";

// =========================================================
// Translucent Reticles Auto or Manual change
// =========================================================

// * Enable/Disable
$Viking::Reticle = "True";

if($Viking::Reticle)
{
// * Change automatic (like mHUD..)
$Viking::AutoRet = "true";

// * Use the Fstat "active" reticle?
$Viking::ActiveRet = "True";

// Don't touch this line
editActionmap("playmap.sae");

// * Change reticle manually
bindCommand(keyboard0, make, "f5", TO, "Reticle::Change();");
bindCommand(keyboard0, break, "f5", TO, "");

// * Turn on Auto again
bindCommand(keyboard0, make, control, "f5", TO, "Reticle::Update();");
bindCommand(keyboard0, break, control, "f5", TO, "");
}

// =========================================================
// Demo functions
// =========================================================

// * Enable/Disable
$Viking::Demo = "false";

if($Viking::Demo)
{
// Don't touch this line
editActionmap("playmap.sae");

// * Demo playback Slow, Still, Normal, FF, FFx2 etc..
bindCommand(keyboard0, make, control, "1", TO, "$SimGame::Timescale=0;");
bindCommand(keyboard0, break, control, "1", TO, "");
bindCommand(keyboard0, make, control, "2", TO, "$SimGame::Timescale=0.5;");
bindCommand(keyboard0, break, control, "2", TO, "");
bindCommand(keyboard0, make, control, "3", TO, "$SimGame::Timescale=1;");
bindCommand(keyboard0, break, control, "3", TO, "");
bindCommand(keyboard0, make, control, "4", TO, "$SimGame::Timescale=2;");
bindCommand(keyboard0, break, control, "4", TO, "");
bindCommand(keyboard0, make, control, "5", TO, "$SimGame::Timescale=4;");
bindCommand(keyboard0, break, control, "5", TO, "");
bindCommand(keyboard0, make, control, "6", TO, "$SimGame::Timescale=8;");
bindCommand(keyboard0, break, control, "6", TO, "");
}

// =========================================================
// Fstat Practise Keybinds
// =========================================================

// * Enable/Disable
$Fstat::Practise = "false";

if($Fstat::Practise)
{
// Don't touch this line
editActionmap("playmap.sae");

// * Fstat Path-practise, only works on Fstat servers in practice mode.
bindCommand(keyboard0, make, control, "f1", TO, "remoteEval(2048, FstatSavePosition, 0);");
bindCommand(keyboard0, break, control, "f1", TO, "");
bindCommand(keyboard0, make, control, "f2", TO, "remoteEval(2048, FstatRestorePosition, 0);");
bindCommand(keyboard0, break, control, "f2", TO, "");
bindCommand(keyboard0, make, control, "f3", TO, "remoteEval(2048, FstatFullHealth, 0);");
bindCommand(keyboard0, break, control, "f3", TO, "");
}

// =========================================================
// Favorites Preferences (Big mofo!)
// =========================================================

// * Enable/Disable
$Viking::Favorites = "false";

// * Dont need the inv-screen so turn it off
$pref::noEnterInvStation = "false";

// * Turn around when entering station
$Favorite::Turnaround = "False";

// * Default Selection to buy by default
$Favorite::Selected = "2";

// * Do we want to drop repair-packs on enter inv?
$Favorite::Drop = "false";

// * Do we want to drop weapons we pick up
// that aren't in our current selected loadout?
$Favorite::DropPeaguns = "false";

// * Announce Loadout to team?
$Favorite::Announce="False";

if($Viking::Favorites)
{
// Don't touch this line
editActionmap("playmap.sae");

// * Toggle drop repair-kits when entering inventory
bindCommand(keyboard0, make, "down", TO, "Favorite::DropToggle();");
bindCommand(keyboard0, break, "down", TO, "");

// * Drop stuff for your HD's or when going capping
bindCommand(keyboard0, make, shift, "d", TO, "Favorite::HeavyDrop();");
bindCommand(keyboard0, break, shift, "d", TO, "");

// * Drop mines
bindCommand(keyboard0, make, shift, "f", TO, "Favorite::ItemDrop(\"Mine\");");
bindCommand(keyboard0, break, shift, "f", TO, "");

// * Drop repair-kit
bindCommand(keyboard0, make, shift, "h", TO, "Favorite::ItemDrop(\"Repair Kit\");");
bindCommand(keyboard0, break, shift, "h", TO, "");

// * Toggle the "Scavenger" feature 
bindCommand(keyboard0, make, shift, "c", TO, "Favorite::PeaGunToggle();");
bindCommand(keyboard0, break, shift, "c", TO, "");

// * Favorite Selections, add as many as you like, and edit loadouts.cs
bindCommand(keyboard0, make, "numpad0", TO, "Favorite::Select(0);");
bindCommand(keyboard0, break, "numpad0", TO, "");
bindCommand(keyboard0, make, "numpad1", TO, "Favorite::Select(1);");
bindCommand(keyboard0, break, "numpad1", TO, "");
bindCommand(keyboard0, make, "numpad2", TO, "Favorite::Select(2);");
bindCommand(keyboard0, break, "numpad2", TO, "");
bindCommand(keyboard0, make, "numpad3", TO, "Favorite::Select(3);");
bindCommand(keyboard0, break, "numpad3", TO, "");
bindCommand(keyboard0, make, "numpad4", TO, "Favorite::Select(4);");
bindCommand(keyboard0, break, "numpad4", TO, "");
bindCommand(keyboard0, make, "numpad5", TO, "Favorite::Select(5);");
bindCommand(keyboard0, break, "numpad5", TO, "");
bindCommand(keyboard0, make, "numpad6", TO, "Favorite::Select(6);");
bindCommand(keyboard0, break, "numpad6", TO, "");
bindCommand(keyboard0, make, "numpad7", TO, "Favorite::Select(7);");
bindCommand(keyboard0, break, "numpad7", TO, "");
bindCommand(keyboard0, make, "numpad8", TO, "Favorite::Select(8);");
bindCommand(keyboard0, break, "numpad8", TO, "");
bindCommand(keyboard0, make, "numpad9", TO, "Favorite::Select(9);");
bindCommand(keyboard0, break, "numpad9", TO, "");
bindCommand(keyboard0, make, shift, "numpad0", TO, "Favorite::Select(10);");
bindCommand(keyboard0, break, shift, "numpad0", TO, "");
bindCommand(keyboard0, make, shift, "numpad1", TO, "Favorite::Select(11);");
bindCommand(keyboard0, break, shift, "numpad1", TO, "");
bindCommand(keyboard0, make, shift, "numpad2", TO, "Favorite::Select(12);");
bindCommand(keyboard0, break, shift, "numpad2", TO, "");
}

// =========================================================
// Tribes Preferences I use:
// =========================================================

// * Don't want no music..
$pref::cdMusic = "False";

// * I have ISDN.. I use this when I dont need to refresh the
// GameServerList.
$pref::lanOnly = "False";

// * We dont use IPX anymore, do we? :)
$pref::noIpx = "True";

// * Skip the rain and snow..
$pref::weatherPrecipitation = "false";

// * We don't want any sky do we?
$pref::skyDetail = "1";
$pref::starDetail = "1.000000";

// * This limits the smoke, good for your fps
$pref::maxNumSmokePuffs = "1";

// * Don't use v-sync, it will probably limit your fps.
$pref::waitForVSync = "False";

// * Nevermind bad language...
$pref::filterBadWords = "False";

// * How many concurrent pings when refreshing server-list
$pref::maxConcurrentPings = "20";

// * How many concurrent queries when refreshing server-list
$pref::maxConcurrentRequests = "20";

// * Shadows change both to 1 to enable
$pref::shadowDetailMask = "1";
$pref::shadowDetailScale = "1";

$pref::animateWithTransitions = "True";