////////////////////////////////////////////////////////////
// File:	TurretHud.cs
// Version:	0.1 Beta
// Author:	Runar
// Credits:	
// Info:	Shows turrets and items status.
//		Should work with Stripped also.
//
////////////////////////////////////////////////////////////
// Don't touch this line
editActionmap("playmap.sae");

// Keybind: Toggle the TurretHud on/off
bindCommand(keyboard0, make, "f6", TO, "TeamCtrlHud::Toggle();");
bindCommand(keyboard0, break, "f6", TO, "");


////////////////////////////////////////////////////////////
Event::Attach(eventLoadPlayGui, TeamCtrlHud::Create);
Event::Attach(eventPlayGuiCreated, TeamCtrlHud::Create);
Event::Attach(eventExit, TeamCtrlHud::Destroy);
Event::Attach(eventGuiOpen, TeamCtrlHud::onGuiOpen);

////////////////////////////////////////////////////////////

function TeamCtrlHud::Create()
{
	if($TeamCtrlHud::Exist)
		return;

	%x = Viking::ScreenSize("x");
	%y = Viking::ScreenSize("y");

	TeamCtrlHud::Destroy();

	%HudContainer=newObject("TeamCtrlHud_Container", SimGui::Control, 0, %y / 2 , 256, 256);
	%HudTeamCtrl=newObject("TeamCtrlHud_TeamCtrl", FearGui::CommandTeamCtrl, 0, 0, 256, 256);

	addToSet("TeamCtrlHud_Container", %HudTeamCtrl);
	addToSet(PlayGui, %HudContainer);

	$TeamCtrlHud::Exist = "True";

	// We don't want it visible yet
	Control::setVisible(TeamCtrlHud_Container, "False");
}

function TeamCtrlHud::Toggle()
{
	if(Control::GetVisible("TeamCtrlHud_Container"))
	{
		// Make it not visible
		Control::SetVisible("TeamCtrlHud_Container", "False");

		// Return to normal playmode
		remoteEval(2048, PlayMode);

		// Restore CommandGui
		if(isObject("_TCHudCommandGui"))
			renameObject("_TCHudCommandGui", "CommandGui");
	}
	else
	{
		// Rename CommandGui to force playscreen
		if(isObject("CommandGui"))
			renameObject("CommandGui", "_TCHudCommandGui");

		// Go to CommandMode
		remoteEval(2048, CommandMode);

		// Force full bandwidth
		RemoteEval(2048, "scom", -1);

		// Turn off the cursor
		Schedule("CursorOff(mainwindow);", 0.3);

		// Make it visible
		Control::SetVisible("TeamCtrlHud_Container", "True");

		// Align the ItemCtrl with the TurretCtrl
		Control::SetPosition("TeamCtrlHud_TurretCtrl", 0, getWord(Control::GetExtent("TeamCtrlHud_ItemCtrl"), 1));
	}
}

function TeamCtrlHud::onGuiOpen(%gui)
{
	if(%gui == "playGui")
	{
		// Make it not visible
		Control::SetVisible("TeamCtrlHud_Container", "False");

		// Return to normal playmode
		remoteEval(2048, PlayMode);

		// Restore CommandGui
		if(isObject("_TCHudCommandGui"))
			renameObject("_TCHudCommandGui", "CommandGui");
	}
}

function TeamCtrlHud::Destroy()
{
	HUD::Destroy("TeamCtrlHud_");
	HUD::Destroy("TeamCtrlHud_");
	$TeamCtrlHud::Exist = "False";
}

function Viking::ScreenSize(%val)
{
	if(%val == "x")
	{
		return getWord(Control::getExtent(playGui), 0);
	}
	else
	{
		return getWord(Control::getExtent(playGui), 1);
	}
}
