//-----------------------------------------------------------
//						AAOD Chat Menu
//			Part 1 of the AAOD Client side script
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//	simply place this file (AAODC.CS) in your tribes\config 
//	directory.
//	In your player setup in Tribes under custom scripts
//	type AAODC. Thats it all there is to it. Watch our 
//	website for updates & addons.
//	- Valya[AAOD]
//----------------------------------------------------------
//						Customizing
//----------------------------------------------------------
//	Bear in mind that any sounds that you add that are not 
//	in one of our downloadable packs will be only heard by you
//	or anyone who has that sound installed on their system.
//	Now that that has been mentioned a couple of guidelines
//	for you to keep in mind.
//	1> - For non-voice specific chat use the addAAODGChat
//		 (for global)& addAAODTChat (your team only).
//		 For any of the standard 'voices' use the standard
//		 addPlayChat & addPlayTeamChat.
//	2> - SYNTAX
//		 addAAODTChat("eMenu Example","This is the Message Text.",aaodf35);
//		 Above is an example of the syntax for all the 'chat' functions
//		 The "eMenu Example" is the part that shows on the menu
//		 keep this short. The lower case letter is the key that activates
//		 the message. If you have more than one with the same key only one of them 
//		 will appear. Numbers & letters work for keys.
//		 The message Text is fairly straight forward.
//		 the aaodf35 is the name of the wav file. This can be anything
//		 if its one of the voice wavs like "I have the enemy Flag.."
//		 which is haveflg use the addPlayChat functions because these will
//		 automatically use your voice as opposed to the aaod chat functions which 
//		 simply look for the wav file.
//		(Look in the DESC File Included with the Download packs
//		 for descriptions of the WAV's in the pack)
//---------------------------------------------------------
//	Last note:
//		We want to try and keep everything as simple as possible for 
//		anyone using our scripts & mod etc. For anyone else who wants 
//		really customize them I expect you to first give credit where 
//		credit is due and second, figure out as much as you can on
//		your own. These scripts are supplied as is with no guarantees
//		the last thing I want to be doing is running a school for the 
//		code challenged.
//		-Valya[AAOD]
//-------------------------------------------------------- 


newObject(PlayChatMenu, ChatMenu, "Root Menu:");
newObject(ThemeChatMenu, ChatMenu, "StarWars:");
newObject(CommandChatMenu, ChatMenu, "Command Menu");


function addAAODGChat(%text, %msg, %sound)
{  if(%sound != "")
   {
      %msg = %msg @ "~w" @ %sound@".wav";
   }
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, Asay, 0, %msg);
}

function addAAODTChat(%text, %msg, %sound)
{  if(%sound != "")
   {
      %msg = %msg @ "~w" @ %sound@".wav";
   }
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, Asay, 1, %msg);
}

function addPlayTeamChat(%text, %msg, %sound)
{
   if(%sound != "")
   {
      %msg = %msg @ "~w" @ %sound;
   }
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, say, 1, %msg);
}

function addPlayChat(%text, %msg, %sound)
{
   if(%sound != "")
   {
      %msg = %msg @ "~w" @ %sound;
   }
   if($curPlayChatMenu != "")
   {
      %text = $curPlayChatMenu @ "\\" @ %text;
   }
   addCMCommand(PlayChatMenu, %text, say, 0, %msg);
}

function Asay(%type,%msg)
{
	remoteEval(2048,Asay,%type,%msg);
}
//----------------------------------------------------------
//	**** This Portion Added for Password Authentication ****
//	  Copy & Paste this into your AAODC Script is your have
//				Modified it from this Version
// ---------------------------------------------------------
if(isFile("config\\AAODVerify.cs") )	// Has PWD Verification Script
{	exec("AAODVerify.cs");
}
//	**** This Portion Added for Password Authentication ****
//----------------------------------------------------------

//--- This function is placed here so that if You are Hosting 
//--- a game you can try out the sound pack.. on your own.`
function remoteASay(%clientId, %team, %message)
{	%msg = %clientId @ " \"" @ escapeString(%message) @ "\"";
	%name=Client::getName(%clientId);
	%message=%name@": "@%message;
   // check for flooding if it's a broadcast OR if it's team in FFA
   if($Server::FloodProtectionEnabled && (!$Server::TourneyMode || !%team))
   {	// we use getIntTime here because getSimTime gets reset.
		// time is measured in 32 ms chunks... so approx 32 to the sec
      %time = getIntegerTime(true) >> 5;
      if(%clientId.floodMute)
      {
         %delta = %clientId.muteDoneTime - %time;
         if(%delta > 0)
         {
            Client::sendMessage(%clientId, $MSGTypeGame, "FLOOD! You cannot talk for " @ %delta @ " seconds.");
            return;
         }
         %clientId.floodMute = "";
         %clientId.muteDoneTime = "";
      }
      %clientId.floodMessageCount++;
      // funky use of schedule here:
      schedule(%clientId @ ".floodMessageCount--;", 5, %clientId);
      if(%clientId.floodMessageCount > 4)
      {
         %clientId.floodMute = true;
         %clientId.muteDoneTime = %time + 10;
         Client::sendMessage(%clientId, $MSGTypeGame, "FLOOD! You cannot talk for 10 seconds.");
         return;
      }
   }
	if($dedicated)
		echo("SAY: " @ %msg);
   if(%team)
   {	%team = Client::getTeam(%clientId);
		if($trace) echo(%message," type",$MsgTypeChat);
		for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
			if(Client::getTeam(%cl) == %team && !%cl.muted[%clientId])
				Client::sendMessage(%cl, 3, %message);
   }
   else
   {	for(%cl = Client::getFirst(); %cl != -1; %cl = Client::getNext(%cl))
			if(!%cl.muted[%clientId])
				Client::sendMessage(%cl, 2, %message);
   }
}

%gender=$PCFG::Gender;
echo("Setting Offense Chat Menu");
setPlayChatMenu("vOffense");
		addPlayTeamChat("aAttack!","Attack!", attack);
		addPlayTeamChat("wWait for signal", "Wait for my signal to attack.", waitsig);
		addPlayTeamChat("cCease fire", "Cease fire!", cease);
		addPlayTeamChat("mMove out", "Move out.", moveout);
		addPlayTeamChat("rRetreat", "Retreat!", retreat);
		addPlayTeamChat("hHit deck", "Hit the deck!", hitdeck);
		addPlayTeamChat("eRegroup", "Regroup.", regroup);
		addPlayTeamChat("vCover me", "Cover me!", coverme);
		addPlayTeamChat("gGoing offense", "Going offense.", ono);
		
		if(%gender=="MALE")
		{
		}
		else
		{	
		}
echo("Setting Target Chat Menu");
setPlayChatMenu("tTarget");
		addPlayTeamChat("aTarget acquired", "Target Acquired", tgtacq);
		addPlayTeamChat("fFire on my target", "Fire on my target", firetgt);
		addPlayTeamChat("nTarget needed", "I need a target.", needtgt);
		addPlayTeamChat("oTarget out of range", "Target out of range.", tgtout);
		addPlayTeamChat("dDestroy Enemy Generator", "Destroy the enemy genarator.", desgen);
		addPlayTeamChat("eEnemy Generator Destroyed", "Enemy generator destroyed.", gendes);
		addPlayTeamChat("tDestroy Enemy Turret", "Destroy enemy turret.", destur);
		addPlayTeamChat("sEnemy Turret Destroyed", "Enemy turret destroyed.", turdes);
		if(%gender=="MALE")
		{
		}
		else
		{	
		}
echo("Setting Defense Chat Menu");
setPlayChatMenu("dDefense");
		addPlayTeamChat("iIncoming Enemies", "Incoming enemies!", incom2);
		addPlayTeamChat("aAttacked", "We are being attacked.", basatt);
		addPlayTeamChat("eEnemy is attacking base", "The enemy is attacking our base.", basundr);
		addPlayTeamChat("nNeed more defense", "We need more defense.", needdef);
		addPlayTeamChat("bDefend our base", "Defend our base.", defbase);
		addPlayTeamChat("dDefending base", "Defending our base.", defend);
		addPlayTeamChat("tBase Taken", "Base is taken.", basetkn);
		addPlayTeamChat("cBase Clear", "Base is secured.", bsclr2);
		addPlayTeamChat("qIs Base Clear?", "Is our base clear?", isbsclr);
		if(%gender=="MALE")
		{
		}
		else
		{	addAAODTChat("hHere comes trouble...","Here comes trouble..",aaodf38);
		}
echo("Setting Flag Chat Menu");
setPlayChatMenu("fFlag");
		addPlayTeamChat("gFlag gone", "Our flag is not in the base!", flgtkn1);
		addPlayTeamChat("eEnemy has flag", "The enemy has our flag!", flgtkm2);
		addPlayTeamChat("hHave enemy flag", "I have the enemy flag.", haveflg);
		addPlayTeamChat("sFlag secure", "Our flag is secure.", flaghm);
		addPlayTeamChat("rReturn our flag", "Return our flag to base.", retflag);
		addPlayTeamChat("fGet enemy flag", "Get the enemy flag.", geteflg);
		addPlayTeamChat("mFlag mined", "Our flag is mined.", flgmine);
		addPlayTeamChat("cClear mines", "Clear the mines from our flag.", clrflg);
		addPlayTeamChat("dMines cleared", "Mines have been cleared.", mineclr);

echo("Setting Need Chat Menu");
setPlayChatMenu("rNeed");
		addPlayTeamChat("rNeed Repairs", "Need repairs.", needrep);
		addPlayTeamChat("aNeed APC Pickup", "I need an APC pickup.", needpku);
		addPlayTeamChat("eNeed Escort", "I need an escort back to base.", needesc);
		addPlayTeamChat("tNeed Ammo", "Can anyone bring me some ammo?", needamo);
		addPlayTeamChat("dNeed more defense", "We need more defense!", wneeddef);
		addPlayTeamChat("hNeed Help!!", "I Need some HELP!!!", help);
		
		if(%gender=="MALE")
		{addAAODTChat("1Medic","Medic",aaodM65);
		}
		else
		{	
		}

echo("Setting Team Chat Menu");
setPlayChatMenu("eTeam");
		addPlayTeamChat("wWatch Shooting", "Watch where your shooting!", wshoot3);
		addPlayTeamChat("dDont know", "I don't know.", dontkno);
		addPlayTeamChat("nNo", "No.", no);
		addPlayTeamChat("yYes", "Yes.", yes);
		addPlayTeamChat("tThanks", "Thanks.", thanks);
		addPlayTeamChat("aNo Problem", "No Problem.", noprob);
		addPlayTeamChat("sSorry", "Sorry.", sorry);
		addLocal("hHurry station", hurystn);
		if(%gender=="MALE")
		{	addAAODGChat("1Where is your honor?","Where is your honor dirtbag?",aaodM29);
			addAAODGChat("2What'd you do?","",aaodM15);
			addAAODGChat("3What the F###?","WHAT THE FUCK IS THIS ALL ABOUT!?",aaodM06);
			addAAODGChat("4How many Assholes...?","How Many ASSHOLES do we have here?",aaodM09);
			addAAODGChat("5What do we have here..?","What do We have here... a Fucking COMEDIAN!?",aaodM25);
		}
		else
		{	addAAODTChat("1Wait Here","Wait Here.",aaodf35);
			addAAODTChat("2What did you do that for?","What did you do that for?",aaodf36);
			addAAODTChat("3You begin to annoy me","You begin to annoy me..",aaodf52);
			addAAODTChat("4Should you become a nuisance.","If you become a nuisance I will kill you myself",aaodf56);
			addAAODTChat("5Hmmm.","Hmmm",aaodf58);
			addAAODTChat("6You little Bastard!","You little Bastard!",aaodf57);
			addAAODTChat("7Easily Amused eh?","Easily amused eh?",aaodf53);
			addAAODTChat("8You get off on annoying people..","You get off on annoying people don't you??",aaodf54);
		}

echo("Setting Global Chat Menu");

setPlayChatMenu("gGlobal");
		addPlayChat("zDoh", "Doh!", oops1);
		addPlayChat("oOops", "Oops!", oops2);
		addPlayChat("sShazbot", "Shazbot!", color2);
		addPlayChat("qDamnit", "Damnit!", color6);
		addPlayChat("cCrap", "Ah Crap!", color7);
		addPlayChat("eDuh", "Duh.", dsgst1);
		addPlayChat("xYou Idiot", "You Idiot!", dsgst2);
		addPlayChat("tThanks", "Thanks", thanks);
		addPlayChat("aNo Problem","No Problem", noprob);
		addPlayChat("bBye","Bye!",bye);
		addPlayChat("yYes","Yes",yes);
		addPlayChat("nNo","No",no);
		addPlayChat("rSorry","Sorry",sorry);
		addPlayChat("hHello","Hello",hello);
		addPlayChat("kI don't know","I don't know",dontkno);
		addPlayChat("mHmmmm","Hmmmm...",color3);
		addPlayChat("fCease FIRE!", "Cease FIRE!!", cease);
		addPlayChat("gAwwwwuuuhhhh!", "Awwuh!", dsgst5);
		addPlayChat("vHEY!", "HEY!!!", wshoot1);

		if(%gender=="MALE")
		{	addAAODGChat("1How ya doin!","How ya doin!",aaodM51);
			addAAODGChat("2Hows it goin eh?","Hows it goin eh?",aaodM52);
			addAAODGChat("3Kick Ass","Kick Ass",aaodM54);
			addAAODGChat("4Lets Play"," Lets Play",aaodM59);
			addAAODGChat("5Shit","shit",aaodM85);
			addAAODGChat("6Holy snikes","HOLY SNIKES!!",aaodM81);
			addAAODGChat("7Stupid!!"," STUPID!!! You're SO STUPID!!!",aaodM58);
			addAAODGChat("8Wiseguy!!","Oh a wiseguy EH!!",aaodM07);
			addAAODGChat("9Fool You!!","Fool You!!",aaodM38);
			addAAODGChat("uGame Over","Game Over",aaodM40);
			addAAODGChat("jGame Time","Its Game Time!",aaodM42);
			setPlayChatMenu("gGlobal\\0More...");
		}
		else
		{	addAAODGChat("1Oh Yeah","Oh Yeah",aaodf28);
			addAAODGChat("3You begin to annoy me","You begin to annoy me..",aaodf52);
			addAAODGChat("4Should you become a nuisance.","Should you become a nuisance I will kill you myself",aaodf56);
			addAAODGChat("5Hmmm.","Hmmm",aaodf58);
			addAAODGChat("6You little Bastard!","You little Bastard!",aaodf57);
		}

echo("Setting Animations Chat Menu");
setPlayChatMenu("aAnimations");
		addPlayAnim("oOver here", 0, ovrhere);
		addPlayAnim("dMove out of way", 1, outway);
		addPlayAnim("rRetreat", 2, retreat);
		addPlayAnim("sStop", 3, dsgst4);
		addPlayAnim("fSalute", 4, yes);
		addPlayAnim("zKneel Pose", 10);
		addPlayAnim("xStand Pose", 11);
		addPlayAnim("qCelebrate 1", 5, cheer1);
		addPlayAnim("eCelebrate 2", 6, cheer2);
		addPlayAnim("wCelebrate 3", 7, cheer3);
		addPlayAnim("vTaunt 1 - how'd that feel?", 8, taunt10);
		addPlayAnim("gTaunt 2 - Come get some", 9, taunt4);
		addPlayAnim("hWave - Hi", 12, hello);
		addPlayAnim("bWave - Bye", 12, bye);

echo("Setting Questions Chat Menu");
setPlayChatMenu("qGlobal Questions");
	if(%gender=="MALE")
	{	addAAODGChat("1How many Assholes(SpaceBalls?)","How many Assholes(SpaceBalls?)",aaodM09);
		addAAODGChat("2A fucking commedian??","A fucking commedian??",aaodM25);
		addAAODGChat("3Can we Stop this cruel game??","Can we Stop this cruel game??",aaodM27);
		addAAODGChat("4Where is your honor dirtbag?","Where is your honor dirtbag?",aaodM29);
		addAAODGChat("5Whatd you do???","",aaodM15);
		addAAODGChat("7What the fuck is this all about??","What the fuck is this all about??",aaodM06);
	}
	else
	{	addAAODGChat("1What are You doing?","What do you think you are doing?",aaodf16);
		addAAODGChat("2What did you do that for?","What did you do that for?",aaodf36);
		addAAODGChat("3Want some Company?","Want some company?",aaodf15);
		addAAODGChat("4Are You crazy ??","Are You Crazy??",aaodf09);
		addAAODGChat("6Was i asleep.??","Was I asleep when you turned into a big wussie???",aaodf45);
		addAAODGChat("7Easily Amused eh?","Easily amused eh?",aaodf53);
		addAAODGChat("8You get off??","You get off on annoying people don't you??",aaodf54);
	}

echo("Setting Comments Chat Menu");
setPlayChatMenu("cGlobal Comments");
	if(%gender=="MALE")
	{	addAAODGChat("1Got our asses kicked...","We just got our asses kicked pal!!",aaodM10);
		addAAODGChat("2Back Door...","Nice try guys but ... You left your back door WIDE open",aaodM11);
		addAAODGChat("3Kick ass...","I came here to chew gum and kick ass..and I'm all outta gum",aaodM12);
		addAAODGChat("4Tounge flappin ...","Tounge flappin no noise outta your big mouth",aaodM13);
		addAAODGChat("5Bless me...","Bless me I have killed a few men",aaodM14);
		addAAODGChat("6In the Corps...","Ahhh A Day in the Corps every Meal and Banquet, every formation a parade..I LOVE the CORPS",aaodM26);
		addAAODGChat("7Express Elevator...","ONE EXPRESS ELEVATOR TO HELL ..GOIN DOWN!!!",aaodM34);
		addAAODGChat("8War!?","Are YOU ready for a WAR!!!?",aaodM24);
		addAAODGChat("9Fallen","Help me Ive fallen and I can't get UP!!",aaodM36);
		addAAODGChat("aFancy Pants","Hellooo MR Fancy Pants!",aaodM37);
		addAAODGChat("sGet Away","Get Away from me..or I'll Shoot you!",aaodM41);
		addAAODGChat("dMad as Hell","I'm MAD as HELL and I'm Not going to TAKE IT ANYMORE!!",aaodM39);
		addAAODGChat("fGods Mission","We're on a mission from GOD",aaodM43);
		addAAODGChat("lI Need to take a Leak","I Gotta take a Leak!!",AAODM70);
		setPlayChatMenu("cGlobal Comments\\0More...");
			addAAODGChat("1Go Home","Go Home..Its Over.",aaodM44);
			addAAODGChat("2Toot Horn","Hate to toot my horn horn but  TOOT TOOT!",aaodM46);
			addAAODGChat("3Holdup??","Sweet Mother of GOD WHAT IS THE HOLDUP HERE!?",aaodM48);
			addAAODGChat("4Houston","Houston..We have a Problem",aaodM49);
			addAAODGChat("5Havn't heard of me?","Im surprised you haven't heard of me...cause some times I just go Nuts....Like right NOW!!",aaodM56);
			addAAODGChat("6Love at 1st","Looks like Love at first Sight..",aaodM61);
			addAAODGChat("7Love my Work","I Do Love my Work",aaodM62);
			addAAODGChat("8Warning you","I'm warning you I am SERIOUSLY STRESSED OUT HERE!!",aaodM60);
	}
	else
	{	addAAODGChat("1Lets ROCK!!","Lets ROCK!!",aaodf06);
		addAAODGChat("2Things dont always work out..","Things don't always work out the way you want.",aaodf07);
		addAAODGChat("3Go buy a clue","Heres a Quarter...go buy a Clue.",aaodf08);
		addAAODGChat("4Im not Bad","Im Not Bad..Im just drawn that way",aaodf10);
		addAAODGChat("5Brian is dried up.","My Brain is all dried up...",aaodf11);
		addAAODGChat("6Big BOOM.","Big Boom..Big Bada BOOM...",aaodf14);
		addAAODGChat("7Pretty Dumb","Pretty dumb thing You did back there",aaodf17);
		addAAODTChat("8You may have time..","You may have time to play games but I have a job to do.",aaodf51);
		addAAODGChat("9Judgement Day.","..Judgment Day...",aaodf20);
		addAAODGChat("aLifes a Bitch...","Lifes a bitch now so am I.",aaodf24);
		addAAODGChat("sDont Have to take your crap","I dont have to Take your CRAP anymore!!",aaodf26);
		addAAODGChat("dPicked the wrong woman","You picked the WRONG woman to get rough with!",aaodf29);
		addAAODGChat("fRun for your lives","Run for your miserable lives!",aaodf30);
		addAAODGChat("gYou need Therapy","You need therapy",aaodf32);
		addAAODGChat("hNever turn your back on a lady","Didn't your mother tell you..dont turn your back on a lady",aaodf33);
		addAAODGChat("zI hate univited guests","I Hate univited guests",aaodf34);
		addAAODGChat("xGirls just wanna have fun","Girls just wanna have fun..",aaodf37);
		addAAODGChat("cHere comes trouble...","Here comes trouble..",aaodf38);
		addAAODGChat("vLook at Me...","Look at me I'm your little princess!!",aaodf39);
		addAAODGChat("bGo Away..","Dont go away MAD just GO AWAY..",aaodf40);
		addAAODGChat("nSometimes you have to slap them..","Sometimes, you have to slap them!",aaodf41);
		addAAODGChat("qThey keep me cause im smart","The dont keep me around cause im pretty..they keep me around cause im smart",aaodf42);
		addAAODGChat("wI am Supreme Being","I am the SUPREME being..",aaodf59);
	}

echo("Setting APC Chat Menu");

setPLayChatMenu("pAPC Responses Comments Etc.");
	addPlayTeamChat("aNeed an APC Pickup", "I need an APC Pickup.", needpku);
	addPlayTeamChat("rAPC ready", "APC ready to go... waiting for passengers.", waitpas);
	addPlayTeamChat("gBoard the APC", "Get in the APC!!", boarda);
	addPlayTeamChat("pPilot APC to Enemy Base", "Pilot APC to enemy Base.", pilot);

	if(%gender=="MALE")
	{	addAAODTChat("1Buckle Up ","Buckle Up ",aaodM16);
		addAAODTChat("2Ah buckle this","Ah buckle this",aaodM17);
		addAAODTChat("3Everybody on Good Great","Everybody on Good Great",aaodM18);
		addAAODTChat("4Prepare ship for light speed","Prepare ship for light speed",aaodM19);
	}
	else
	{	addAAODTChat("iIn the pipe 5x5","In the Pipe 5x5",aaodf13);
		addAAODTChat("tThanks for the lift","Thanks for the lift",aaodf25);
		addAAODTChat("1Flight Attendant","The emergency exits are to the fronmt and rear of the vehicle...",aaodf46);
		addAAODTChat("2In for some chop","Buckle up boys we are in for some chop",aaodf47);
		addAAODTChat("3Destination?","Destination?",aaodf49);
	}

echo("Setting General Team Resopnse Chat Menu");

setPlayChatMenu("wGeneral Team Responses");
	addPlayTeamChat("sBase secure", "Our base is Secure", bsclr2);
	addPlayTeamChat("wWaiting...", "Waiting.", wait2);
	addPlayTeamChat("gEnemy Generator Destroyed", "Enemy Generator Destroyed.", gendes);

	if(%gender=="MALE")
	{	echo("Loading Male Gender Voice Pack Addon");
		addAAODTChat("1Coordinates Received","Coordinates Received",aaodm01);
		addAAODTChat("2Trasmit Coordinates","Transmit corrdinates.",aaodm02);
		addAAODTChat("3Reporting In","Reporting In",aaodm03);
		addAAODTChat("4Go Ahead command","Go Ahead ...command.",aaodm04);
		addAAODTChat("5Rodger","Rodger.",aaodm05);
		addAAODTChat("6Got news for you...","I got news for you pal...you ain't leadin but 2 things right now, Jack & Shit. And Jack just left town.",aaodm53);
		
	}
	else
	{	echo("Loading female Gender Voice Pack Addon");
		addAAODTChat("1I'm waitin on you","I'm waitin on YOU...",aaodf01);
		addAAODTChat("2I'm ready","I'm ready...",aaodf02);
		addAAODTChat("3I Gotcha","I Gotcha",aaodf03);
		addAAODTChat("4It would be a pleasure","It would be a pleasure.",aaodf04);
		addAAODTChat("5I read you (giggle)","I read you.",aaodf05);
		addAAODTChat("6Good Idea","Good Idea.",aaodf18);
		addAAODTChat("7Im Listening","Im listening.",aaodf48);
		addAAODTChat("fExcuse me..","Excuse me...Do I have FUCK ME written on my forehead??",aaodf50);
	}

echo("Setting SFX Chat Menu");
if(isFile("base\\voices\\AAODS1.VOL") )
{	setPlayChatMenu("sSound FX");
		addAAODGChat("aPlay Taps","(SFX) - Taps",aaods01);
		addAAODGChat("sApplause","(SFX) - Applause",aaods02);
		addAAODGChat("dShowdown","(SFX) - Draw..I win U lose",aaods03);
		addAAODGChat("fTwilight zone","(SFX) - Twilight zone",aaods04);
		addAAODGChat("gComin for Ya..","(SFX) - I'm coming for You....",aaods05);
		addAAODGChat("hHalleluja!","(SFX) - Halleluja!",aaods06);
		addAAODGChat("zPig Squeal!","(SFX) - Here Piggy Piggy!",aaods07);
		addAAODGChat("xFanfare!","(SFX) - FanFare!",aaods08);
		addAAODGChat("cMission Impossible","(SFX) - MISSION...IMPOSSIBLE!!",aaods09);
		addAAODGChat("vRevely!","(SFX) - REVELY!",aaods10);
	if(%gender=="MALE")
		{	addAAODGChat("1Laugh 1","Laugh.. :o)",aaodM21);
			addAAODGChat("2Laugh 2","Laugh.. =)",aaodM22);
			addAAODGChat("3Laugh 3","Laugh..WHEE What a Predicament!!",aaodM23);
			addAAODGChat("4Cuss","F&^&^@ (^@(*^( (*@(*^!#&($* )*&!@*!!!",aaodM28);
			addAAODGChat("5Be a Marine","Be one of the FEW the PROUD the MARINES!",aaodM64);
		}
		else
		{	addAAODGChat("1 Laugh 1","Laugh.. :o)",aaodf21);
			addAAODGChat("2 Laugh 2","Laugh.. =)",aaodf22);
		}
}


echo("Setting Global responses Chat Menu");

setPlayChatMenu("xGlobal Responses");
	if(%gender=="MALE")
	{	echo("Loading Male Gender Voice Pack Addon");
		addAAODGChat("1Coordinates Received","Coordinates Received",aaodm01);
		addAAODGChat("2Trasmit Coordinates","Transmit corrdinates.",aaodm02);
		addAAODGChat("3Reporting In","Reporting In",aaodm03);
		addAAODGChat("4Go Ahead command","Go Ahead ...command.",aaodm04);
		addAAODGChat("5Rodger","Rodger.",aaodm05);
		addAAODGChat("6Got news for you...","I got news for you pal...You aint leadin but 2 things right now. Jack & Shit. And Jack just left town.",aaodm53);
		addAAODGChat("l Leak","He's Going to Take a leak!! Get outta the way!",AAODM50);
	}
	else
	{	echo("Loading female Gender Voice Pack Addon");
		addAAODGChat("1I'm waitin","I'm waitin on YOU...",aaodf01);
		addAAODGChat("2I'm ready","I'm ready...",aaodf02);
		addAAODGChat("3I Gotcha","I Gotcha",aaodf03);
		addAAODGChat("4A pleasure","It would be a pleasure.",aaodf04);
		addAAODGChat("5I read you (giggle)","I read you.",aaodf05);
		addAAODGChat("6Your interested","I dont have to ask if your interested.",aaodf19);
		addAAODGChat("7Im not that Easy..","Im NOT that easy",aaodf27);
		addAAODGChat("8No hes not hes..","No hes not hes fat and he's stupid",aaodf31);
		addAAODGChat("9Isnt that special","Oh isnt that special.",aaodf43);
		addAAODGChat("0Bite Me!","****** Bite Me!!",aaodf12);
		addAAODGChat("lIm Listening","Im listening.",aaodf48);
		addAAODGChat("fExcuse me..","Excuse me ... Do I have FUCK ME written on my forehead??",aaodf50);
		addAAODGChat("dDoesn't take a telepath..","Doesn't take a Telepath to know what youre thinking.",aaodf55);


	}

echo("Setting Themes Chat Menu");
setPlayChatMenu("mThemes");
	if(isFile("base\\voices\\AAODT1.VOL") )	// SouthPark
	{setPlayChatMenu("mThemes\\1SouthPark");
		addAAODGChat("1I have class 4 armor","I have clas IV armor ..impenetrable to your American bullets..",AAODT101);
		addAAODGChat("2Get your bitch ass...","You get your bitch A$$ back in the kitchen and make me some pie!",aaodt102);
		addAAODGChat("3I didn't mean to fart on you","Excuse me I didn't mean to fart on you...",aaodt103);
		addAAODGChat("4Ya whatever ya FAT ...","Ya whatever Ya FAT BITCH!!",aaodt104);
		addAAODGChat("5HEY! ill blow your...","Hey! I'll blow your FRIGGIN Head OFF!!",aaodt105);
		addAAODGChat("6I AM Going to KILL U guys...","I AM GOING TO &*^!& KILL YOU GUYS...SERIOUSLY!!",aaodt106);
		addAAODGChat("7We know what you like!","Hey! We know What YOU LIKE !!! *&#(*#&*&!#&!",aaodt107);
		addAAODGChat("8Need to mellow...","Whoa dude You need to mellow out...",aaodt108);
		addAAODGChat("9I AM SO PISSED...","I AM SO PISSED OFF RIGHT NOW!",aaodt109);
		addAAODGChat("0Revenge is so ...","REVENGE is so very very SWEET!!",aaodt110);
		addAAODGChat("aHEY! you scrawny.","HEY! YOU SCRAWNY EYED F&!^@&^ WHAT THE (*&#(!#& is WRONG WITH YOU!!!",aaodt111);
		addAAODGChat("sThis Sucks","This SUCKS!",aaodt112);
		addAAODGChat("dIt will take more...","It will take more than your weak american weapons to destroy me!",aaodt113);
		addAAODGChat("fWOW! you.. ","WOW! You just kicked A$$!!",aaodt105);
	}
	if(isFile("base\\voices\\AAODT2.VOL") )	// STARWARS
	{setPlayChatMenu("mThemes\\2StarWars");
		addAAODGChat("1Wookie Yell","WOOAAARG!!",aaodt207);
		addAAODGChat("2 C3P0 Little Twerp","That Malfunctioning Little Twerp",aaodt213);
		addAAODGChat("3STAR WARS music","",aaodt214);
		addAAODGChat("4Imperial Attack Music","",aaodt217);
		addAAODGChat("5DARTHS Theme Music","",aaodt219);
		addAAODGChat("6Doomed","Were Doomed!",aaodt221);
		addAAODGChat("7Deactivate","PLEEASE DONT DEACTIVATE ME!",aaodt223);
		if(%gender=="MALE")
		{	addAAODGChat("a(DV) All too easy","All too easy..",AAODT201);
			addAAODGChat("s(DV) You are Beaten","You are Beaten...It is useless to resist.",AAODT202);
			addAAODGChat("d(DV) Give Yourself...","GIVE yourself to the DARKSIDE...",AAODT203);
			addAAODGChat("f(DV) I Have You...","I HAVE YOU NOW!!!",AAODT204);
			addAAODGChat("g(DV) Impressive","Impressive...",AAODT205);
			addAAODGChat("h(DV) You should not","You Should not have come BACK.",AAODT206);
			addAAODGChat("z(DV) Ive been waiting","I've been waiting for you...",AAODT208);
			addAAODGChat("x(HS) Dont Thank...","Don't everybody thank me at once!!",AAODT209);
			addAAODGChat("c(DV) Scanning Crew...","Send a Scanning Crew aboard...",AAODT210);
			addAAODGChat("v(OB) Learn","You must learn the ways of the force...",AAODT211);
			addAAODGChat("b(LS) Look","LOOK at THIS!!",AAODT212);
			addAAODGChat("q(DV) Plans","I Want to know what happened to the Plans.",AAODT216);
			addAAODGChat("w(DV) Underestimate","Dont Underestimate the FORCE.",AAODT220);
			addAAODGChat("e(LS) Bad Feeling","I Have a very BAD feeling about this...",AAODT224);
			addAAODGChat("r(LS) Peice of Junk","What a Peice of JUNK!",AAODT215);

		}
		else
		{	addAAODGChat("a(PL) Help me ","Help me OBI WAN...Youre our only Hope",AAODT218);
			addAAODGChat("s(PL) Dont Know","I Don't know what you are talking about",AAODT222);

		}

	}
	if(isFile("base\\voices\\AAODT3.VOL") )	// Music
	{setPlayChatMenu("mThemes\\3Music & Misc");
		addAAODGChat("1Were U Born...","Were you born an A$$HOLE?? or have you worked at it your whole life?",AAODT301);
	}
	if(isFile("base\\voices\\AAODT4.VOL") )	// Jim Carey
	{setPlayChatMenu("mThemes\\4Jim Carey");
		addAAODGChat("1Allrighty","ALLRIGHTY Then...",AAODT401);
		addAAODGChat("2I think he ...","I Think he wants to COMMUNUCATE...",AAODT402);
		addAAODGChat("3Brothers dont...","Brothers dont shake hands Brother GOTTA HUGG.",AAODT403);
		addAAODGChat("4LOOSER","Looooooser...",AAODT404);
		addAAODGChat("5Did you miss me?","Did you MISS me???",AAODT405);
		addAAODGChat("6Smokin!","SSSSMOKIN!",AAODT406);
		addAAODGChat("7Stop Me!","Oohhhh Somebody STOP me!!",AAODT407);
	}
	if(isFile("base\\voices\\AAODT5.VOL") )	// Mike Meyers
	{setPlayChatMenu("mThemes\\5Mike Meyers");
		addAAODGChat("1Aint my Bag","This Sorta thing ain my Bag Baby!",AAODT501);
		addAAODGChat("2Throw me a bone","Throw me a Friggen BONE here! I'm the BOSS need the Info!",AAODT502);
		addAAODGChat("3Dr Evil 1","Here's the plan...We hold the world Ransom for 1 Million Dollars.",AAODT503);
		addAAODGChat("4Dr Evil 2","Ok then .. we hold the world ransom for 100 billion dollars",AAODT504);
		addAAODGChat("5Groovy!","OH GROOVY Baby Yeah!!",AAODT505);
		addAAODGChat("6Makes me Angry","Thats Makes me Angry..When I get Angry mr Biggleworth get upset..When he gets upset PEOPLE DIE!!!",AAODT506);
		addAAODGChat("7Shagged","I Shagged her rotten baby YEAH!",AAODT507);
		addAAODGChat("8Subterreanean Probe","LAUNCHING the SUBTERRANEAN PROBE!!",AAODT508);
		addAAODGChat("9Are You MAD??","Are You MAD!? (as in Crazy)",AAODT509);
	}
	
	if(isFile("base\\voices\\AAODT6.VOL") )	// Tripping the RIFT SMACK PACK
	{	setPlayChatMenu("mThemes\\6Trippin the Rift");
		if(%gender=="MALE")
		{	addAAODGChat("1Get Over Here!!","I Said Get Over Here!!",AAODT602);
			addAAODGChat("2Youve had this coming!!","ARG! You've had this coming for a long Time!!",AAODT603);
			addAAODGChat("3Who Are You?","Who are YOU !?",AAODT604);
			addAAODGChat("4This is Fair","OH! This is Fair!",AAODT605);
			addAAODGChat("5Never Underestimate...","Never Underestimate the power of a dark Clown!",AAODT606);
			addAAODGChat("6Too Pissed Off..","I'm TOO pissed off to enjoy it anyway..",AAODT607);
			addAAODGChat("aWhy Dont You..","Why Dont you fight without using your faggot clown powers son?!",AAODT611);
			addAAODGChat("sBring it ON!!","Bring it ON!!",AAODT612);
			addAAODGChat("dWant a peice of me..","YOU WANT A PEICE OF ME!?!",AAODT613);
			addAAODGChat("fKill you Later..","Stay Here! I'll KILL you Later..",AAODT608);
			addAAODGChat("qWhat do I Want?","Hmmmm What do I WANT?!",AAODT614);
			addAAODGChat("wBloody Vengeance!!","OH YEAH!! BLOODY VENGEANCE!!",AAODT615);
		}
		else
		{	addAAODGChat("1Are You Shure?","Are you Shure?",AAODT601);
			addAAODGChat("2Im waiting..","I'm waiting..",AAODT609);
			addAAODGChat("3HandJob?","Awwww...Would you like a hand job??",AAODT610);
			addAAODGChat("4Hey! Mr Clown","HEY! Mr CLOWN..",AAODT616);
			addAAODGChat("5Better Ways...","I Know better ways for you to OCCUPY your time..",AAODT617);
		}

	}
	

//-------------------------------------------------------------------
//	**** These are Generic Load Codes for Future expansion Packs ****
// ------------------------------------------------------------------
if(isFile("config\\AAOD-ADMIN.cs") )	
{	echo("Found AAOD Remote Admin Script....Loading");
	exec("AAOD-ADMIN.cs");		
}

if(isFile("config\\AAOD-ADDON1.cs") )	
{	echo("Found AAOD ADDON Pack #1 .... Loading");
	exec("AAOD-ADDON1.cs");		
}

if(isFile("config\\AAOD-ADDON2.cs") )	
{	echo("Found AAOD ADDON Pack #2 .... Loading");
	exec("AAOD-ADDON2.cs");		
}
if(isFile("config\\AAOD-ADDON3.cs") )	
{	echo("Found AAOD ADDON Pack #3 .... Loading");
	exec("AAOD-ADDON3.cs");		
}
if(isFile("config\\AAOD-ADDON4.cs") )	
{	echo("Found AAOD ADDON Pack #4 .... Loading");
	exec("AAOD-ADDON4.cs");		
}
if(isFile("config\\AAOD-ADDON5.cs") )	
{	echo("Found AAOD ADDON Pack #5 .... Loading");
	exec("AAOD-ADDON5.cs");		
}
if(isFile("config\\AAOD-ADDON6.cs") )	
{	echo("Found AAOD ADDON Pack #6 .... Loading");
	exec("AAOD-ADDON6.cs");		
}
if(isFile("config\\AAOD-ADDON7.cs") )	
{	echo("Found AAOD ADDON Pack #7 .... Loading");
	exec("AAOD-ADDON7.cs");		
}
if(isFile("config\\AAOD-ADDON8.cs") )	
{	echo("Found AAOD ADDON Pack #8 .... Loading");
	exec("AAOD-ADDON8.cs");		
}
if(isFile("config\\AAOD-ADDON9.cs") )	
{	echo("Found AAOD ADDON Pack #9 .... Loading");
	exec("AAOD-ADDON9.cs");		
}
if(isFile("config\\AAOD-ADDON10.cs") )	
{	echo("Found AAOD ADDON Pack #10.... Loading");
	exec("AAOD-ADDON10.cs");		
}

setPlayChatMenu("zCommand Responses");

	addPlayCMDResponse("aAcknowledged", 1, "Command acknowledged", "acknow");
	addPlayCMDResponse("zCompleted", 0, "Objective complete", "objcomp");
	addPlayCMDResponse("uUnable to complete", 0, "Unable to complete objective", "objxcmp");

// Commander Menu

function contextIssueCommand(%action, %msg, %sound)
{	if(%sound != "")
		%msg = %msg @ "~w" @ %sound;
	setIssueCommand(%action, %msg);
}

// $CommandTarget can be one of:

// waypoint
// enemy vehicle
// enemy player
// enemy static
// enemy turret
// enemy sensor
// friendly vehicle
// friendly player
// friendly static
// friendly turret
// friendly sensor


function Commander::StarCommand(%type)
{
   if(%type == "*Attack")
   {
      if($CommandTarget == "enemy static")
			contextIssueCommand(1, "Destroy enemy equipment at waypoint", "attobj"); 
      else if($CommandTarget == "enemy turret")
			contextIssueCommand(1, "Destroy enemy turret at waypoint", "attobj"); 
      else if($CommandTarget == "enemy sensor")
			contextIssueCommand(1, "Destroy enemy sensor at waypoint", "attobj"); 
      else if($CommandTarget == "enemy player" || $CommandTarget == "enemy vehicle")
         contextIssueCommand(1, "Attack enemy " @ $CommandTargetName, "attway");
      else if($CommandTarget == "friendly player")
         contextIssueCommand(1, "Cover " @ $CommandTargetName, "escfr");
      else if($CommandTarget == "friendly vehicle")
         contextIssueCommand(1, "Board APC ", "boarda");
      else
         contextIssueCommand(1, "Attack enemy forces", "attway");
   }
   else if(%type == "*Defend")
   {
		if($CommandTarget == "friendly player")
		   contextIssueCommand(2, "Defend " @ $CommandTargetName, "escfr"); 
		else
		   contextIssueCommand(2, "Defend waypoint", "defway");
   }
   else if(%type == "*Repair")
   {
		if($CommandTarget == "friendly player")
		   contextIssueCommand(2, "Repair " @ $CommandTargetName, "repplyr"); 
		else
		   contextIssueCommand(2, "Repair " @ $CommandTargetName, "repobj");
   }
}

setCommanderChatMenu("");

   addCommand("aAttack", 1, "*Attack");
   addCommand("dDefend", 2, "*Defend");
   addCommand("rRepair", 3, "*Repair");

   setCommanderChatMenu("eDeploy");
		setCommanderChatMenu("eDeploy\\sSensor");
			addCommand("pPulse sensor", 2, "Deploy pulse sensor at waypoint", "deppuls");
			addCommand("jJammer", 2, "Deploy sensor jammer at waypoint", "depjamr");
			addCommand("mMotion sensor", 2, "Deploy motion sensor at waypoint", "depmot");
			addCommand("cCamera", 2, "Deploy camera at waypoint", "depcam");
			addCommand("dDesignator", 2, "Deploy Defender Designator at waypoint", "depcam");
			addCommand("bCounterBattery", 2, "Deploy CounterBattery Sensor at waypoint", "deppuls");
			addCommand("aAlarm System", 2, "Deploy Base Alarm System at waypoint", "");
		
		setCommanderChatMenu("eDeploy\\qPower");
			addCommand("aGenerator", 2, "Deploy Mobile Generator", "");
			addCommand("sSolar Panel", 2, "Deploy Portable Solar Panel", "");
			addCommand("dSat. System", 2, "Deploy Satelite Power System", "");
			addCommand("fPowerNode", 2, "Deploy PowerNode at waypoint", "");
			addCommand("zFabricator", 2, "Deploy a Fabrication Generator", "");
			addCommand("xSolar Fab.", 2, "Deploy a Solar Fabrication Generator", "");

		
		setCommanderChatMenu("eDeploy\\dDefense");
			addCommand("aShield Gen.", 2, "Deploy a Shield Generator", "");
			addCommand("sShield Node", 2, "Deploy a Shield Node on Item at Waypoint", "");
			addCommand("dBunker", 2, "Deploy Mobile Bunker at Waypoint", "");
			addCommand("fForceDoor", 2, "Deploy ForceDoor at Waypoint", "");
			addCommand("cForceField", 2, "Deploy ForceField at Waypoint", "");
			addCommand("xBlastShield", 2, "Deploy a BlastShield at Waypoint", "");
		
		setCommanderChatMenu("eDeploy\\aObject");
			addCommand("aAmmo", 2, "Deploy Ammo Station", "depamo");
			addCommand("iInventory", 2, "Deploy Small Inventory Station", "depinv");
			addCommand("zJumpPad", 2, "Deploy JumpPad", "");
			addCommand("tTeleporter", 2, "Deploy Teleporter at Waypoint", "");
			addCommand("bBeacon", 2, "Deploy beacon at waypoint", "depbecn");
			addCommand("xMInventory", 2, "Deploy Mobile Inventory Station", "depinv");

		setCommanderChatMenu("eDeploy\\tTurret");
			addCommand("aAP Ambusher", 2, "Deploy Anti Personell Ambusher Turret at waypoint", "deptur");
			addCommand("qAA Ambusher", 2, "Deploy AA Ambusher Turret at waypoint", "deptur");
			addCommand("sAA Turret", 2, "Deploy Anti-Air Turret at waypoint", "deptur");
			addCommand("fSAM Turret", 2, "Deploy SAM Turret at waypoint", "deptur");
			addCommand("dVelcro", 2, "Deploy Velcro Turret", "deptur");
			addCommand("iInferno", 2, "Deploy Inferno Mine at Waypoint", "deptur");
			addCommand("tTurret", 2, "Deploy deployable Turret", "deptur");
			addCommand("cChainGun", 2, "Deploy ChainGun Turret", "deptur");
			addCommand("xMort", 2, "Deploy MORT Turret at waypoint", "deptur");
		
		setCommanderChatMenu("eDeploy");
		addCommand("vA.P.C.", 2, "Pilot APC to waypoint", "pilot");

setCommanderChatMenu("kCommand Response");
	addCommandResponse("aAcknwledged", 1, "Command acknowledged", "acknow");
	addCommandResponse("cCompleted", 0, "Objective complete", "objcomp");
	addCommandResponse("uUnable to complete", 0, "Unable to complete objective", "objxcmp");
		

