// !!!!!!!!! CowboyHUD 2.3 -> EGO-BOOSTER SCRIPT <- 5/2/99 3:39pm EST !!!!!!!!!
//
// By:
//    Cowboy
//    cowboy@planetstarsiege.com
//    http://www.planetstarsiege.com/cowboy/
//    ICQ# 31184463
//
// Basically a Kill-Notification Script, the idea was from JHUD, but now that
// it's obsolete, I thought I'd do this up... I've really added a lot since
// version 1.0, this should be my last release (barring any major unknown bugs
// or the ability to use transparent bitmaps!)
//
// !!!!!!!!!!!!!!!!!!!!!!!!! NEW FEATURES / BUGFIXES !!!!!!!!!!!!!!!!!!!!!!!!!!
//
// 2.3: Purely aesthetics... I added my new email address and webpage!
//
// 2.2: Fixed problem on Multi-Team matches (more than 2 teams) that would
//      result in ocassional incorrect killer & victim team status. This is due
//      to the fact that Presto's pack assumes you are only playing in a 2-team
//      match, and therefore his Team::Enemy() function only recognizes the
//      FIRST enemy team as being the enemy. Instead of checking Team::Enemy(),
//      I now check for !Team::Friendly(). Also: Cowboy Hats! (har har har)
//
//      Included a JHUD-like display position option (down below) Check it out
//      if you liked the placement of the original JHUD Kill Tracker...
//
// 2.1: You can now adjust the duration of the messages and the last-kill-time
//      notification interval. - Good idea GrymReaper!
//
// 2.0: Now, tells and reminds you who last killed you - so you can GET
//      REVENGE! Also lets you know if YOU were Team Killed, or committed
//      suicide. HUD updates every so often and tells you how long since your
//      last kill.
//
//      Now with ANIMATED BITMAPS!   Woooo Baby!
//
// 1.0 No centerprint("",1) overlap, as this is a HUD and can be moved, also - 
//     always stays open for 4 seconds after the last kill notification (got
//     rid of that pesky schedule() function) ...and looks cool too!
//
// Requires PrestoHUD, tested with 0.92 & 0.93 and depends on his eventKillTrak
// functions, so it will only track kills or display the weapon names correctly
// if $PrestoPref::KillTrak = true (in presto\PrestoPrefs.cs) and the inventory
// tables and death messages are kept up-to-date.
//
// Installation notes:
//
// Unzip all files into \config\cowboy directory and add line:
// Include("cowboy\\cowboyhud.cs"); to your autoexec.cs file somewhere AFTER
// the exec("presto\\install.cs"); line! You'll never believe how many emails I
// got about this one!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// (c) 1999 Ben Alman, whatever... I hope you enjoy this, and all that i ask is
// that you give me props for it.. whatever... enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\KillTrak.cs");
Include("presto\\DynHud.cs");

// Where is CowboyHUD going to be displayed?
//
// PlaceX & PlaceY are coordinates of top left corner of CowboyHUD. These read
// from Presto's $PrestoPref, to position CowboyHUD 15 pixels under Presto's
// DynHUD - this is my personal default:
//
$Cowboy::PlaceX = getWord($PrestoPref::DynHudPosition, 0);
$Cowboy::PlaceY = getWord($PrestoPref::DynHudPosition, 1) + getWord($PrestoPref::DynHudPosition, 3) + 15;
//
// In Prestopack 0.93+ you can do 'relative placement' - for example, using
// these lines instead puts CowboyHUD in the exact center of the screen. 
//
// $Cowboy::PlaceX = "50%";
// $Cowboy::PlaceY = "50%";
//
// This is the default size of CowboyHUD, again, you can changes these values
// into 'relative size' like "20%" or "100%", but i can't think of why you'd
// want to...
//
$Cowboy::SizeX = 120;
$Cowboy::SizeY = 85;
//
// Or even if you liked the old JoshHUD placement, this is pretty close...
//
// $Cowboy::PlaceX = "50%";
// $Cowboy::PlaceY = "85%";
// $Cowboy::SizeX = "75%";
// $Cowboy::SizeY = 85;
//
// You get the idea, right?


// Other stuff you may want to change resides here...
//
$Cowboy::UpdateTime = 0.25;	// Time in sec. to update timer & HUD
$Cowboy::ShowTime = 4;		// Time in sec. to desplay each notice
$Cowboy::NotifyTime = 120;	// Time in sec. to wait before notifying
				// the last-kill-time

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(Cowboy,	"<jl><B5,4:cowboy\\CowboyHat.bmp>" @
		"<jr><B6,4:cowboy\\CowboyHat.bmp>" @
		"<jc><f1>CowboyHUD 2.3\n" @
		"EGO-BOOSTER SCRIPT!\n" @
		"<f0>If you commit suicide, kill\n" @
		"someone, or get killed, this\n" @
		"tells you what happened! So\n" @
		"that you can <f2>GET REVENGE!\n" @
		"<f0>Now with Animated Bitmaps!\n" @
		"<f1>Released 5/2/99 by Cowboy\n" @
		"cowboy@planetstarsiege.com");
	}

//
// Debug Mode, this enables the HUD I list my variables in, for testing. BTW,
// I run in 800x600 and this HUD is located on the right side of the screen..
// <F12> is the Toggle Key to display it.
//
$Cowboy::Debugmode = false;

//
// Parse seconds into mm:ss
//
function MinuteSeconds(%seconds) {
	%minutes = floor(%seconds / 60);
	%seconds = %seconds % 60;
	%Time = strcat(%minutes, ":");
	if (%Seconds < 10)
		%Time = strcat(%Time, "0");
	return strcat(%Time, %seconds);
	}

//
// If you're playing Deathmatch (on one big team) killing someone won't be a 'Team Kill'
//
function Cowboy::Enemy(%who) {
	if (Client::GetTeam(%who) != Team::Friendly() || $ServerMissionType == "Deathmatch")
		return true;
	else
		return false;
	}

//
// This timer is always running to keep track of the KILLS/WUSSIE/VENGEANCE
// FACTOR! (see below) also, calls the 'update HUD' function only when it
// needs to.
//
function Cowboy::Timer() {

	$Cowboy::LastKillTime = getSimTime() - $Cowboy::StartTime;

	$Cowboy::LastDeathTime = getSimTime() - $Cowboy::StartDeathTime;

	$Cowboy::LastEventTime = getSimTime() - $Cowboy::StartEventTime;

	schedule("Cowboy::Timer();", $Cowboy::UpdateTime);

	if ($Cowboy::LastEventTime < 3 * $Cowboy::ShowTime + 1 || $Cowboy::LastEventTime % $Cowboy::NotifyTime < 2 * $Cowboy::ShowTime + 1)
		HUD::Display(CowboyHUD);
	}

//
// Trying to clean up the HUD code
//
function Cowboy::DrawBitmaps(%bitmap) {
	HUD::AddText(CowboyHUD, "<jr><B7,3:"@ %bitmap @">");
	HUD::AddText(CowboyHUD, "<jl><B0,3:"@ %bitmap @">");
	HUD::AddText(CowboyHUD, "<jr><B-21,"@ $Cowboy::SizeY - 15 @":"@ %bitmap @">");
	HUD::AddText(CowboyHUD, "<jl><B-14,"@ $Cowboy::SizeY - 15 @":"@ %bitmap @">");
	}

//
// These display the correct data on the HUD, I made them into separate
// functions to simplify my complex tangled mess of 'if' statements...
//
function Cowboy::Suicide() {
	if (getSimTime()/$Cowboy::UpdateTime/2 % 2 == 0)
		Cowboy::DrawBitmaps("cowboy\\angrysmiley.bmp");
	else
		Cowboy::DrawBitmaps("skull_small.bmp");
	HUD::AddTextLine(CowboyHUD, "");
	HUD::AddTextLine(CowboyHUD, "<jc><f0>You just ");
	HUD::AddTextLine(CowboyHUD, "got yourself ");
	HUD::AddTextLine(CowboyHUD, "killed, stupid! "); 
	HUD::AddTextLine(CowboyHUD, "");
	HUD::AddTextLine(CowboyHUD, "<f1>Doh! "); 
	return $Cowboy::UpdateTime;
	}

function Cowboy::TeamKilledYou() {
	if (Client::getName($Cowboy::LastTeamKiller) == "") return 0;
	if (getSimTime()/$Cowboy::UpdateTime/2 % 2 == 0)
		Cowboy::DrawBitmaps("cowboy\\angrysmiley.bmp");
	else
		Cowboy::DrawBitmaps("cowboy\\reddot.bmp");
	HUD::AddTextLine(CowboyHUD, "<jc><f0>You were ");
	HUD::AddTextLine(CowboyHUD, "<f2>Team Killed <f0>by: ");
	HUD::AddTextLine(CowboyHUD, "<f1>"@ Client::getName($Cowboy::LastTeamKiller) @" "); 
	HUD::AddTextLine(CowboyHUD, "<f0>Teach him ");
	HUD::AddTextLine(CowboyHUD, "a lesson! ");
	return $Cowboy::UpdateTime;
	}

function Cowboy::EnemyKilledYou() {
	if (!Cowboy::Enemy($Cowboy::LastEnemyKiller) || Client::getName($Cowboy::LastEnemyKiller) == "") return 0;
	if (getSimTime()/$Cowboy::UpdateTime % 4 == 0)
		Cowboy::DrawBitmaps("cowboy\\redstar.bmp");
	else if (getSimTime()/$Cowboy::UpdateTime % 4 == 1)
		Cowboy::DrawBitmaps("cowboy\\redstar2.bmp");
	else if (getSimTime()/$Cowboy::UpdateTime % 4 == 2)
		Cowboy::DrawBitmaps("cowboy\\redstar3.bmp");
	else
		Cowboy::DrawBitmaps("cowboy\\redstar4.bmp");
	HUD::AddTextLine(CowboyHUD, "<jc><f0>You were ");
	if ($Cowboy::LastEvent <= 2 || $Cowboy::LastDeathTime > 9)
		HUD::AddText(CowboyHUD, "last ");
	HUD::AddTextLine(CowboyHUD, "killed by: ");
	HUD::AddTextLine(CowboyHUD, "<f1>"@ Client::getName($Cowboy::LastEnemyKiller) @" "); 
	HUD::AddTextLine(CowboyHUD, "<f0>Get ");
	HUD::AddTextLine(CowboyHUD, "Revenge! ");
	return $Cowboy::UpdateTime;
	}

function Cowboy::Wussie() {
	if (getSimTime()/$Cowboy::UpdateTime % 4 == 0)
		Cowboy::DrawBitmaps("cowboy\\reddot.bmp");
	else if (getSimTime()/$Cowboy::UpdateTime % 4 == 1)
		Cowboy::DrawBitmaps("cowboy\\reddot2.bmp");
	else if (getSimTime()/$Cowboy::UpdateTime % 4 == 2)
		Cowboy::DrawBitmaps("cowboy\\reddot3.bmp");
	else
		Cowboy::DrawBitmaps("");
	// Print stuff
	HUD::AddTextLine(CowboyHUD, "<jc>You haven't ");
	HUD::AddTextLine(CowboyHUD, "killed an enemy ");
	HUD::AddTextLine(CowboyHUD, "in "@ MinuteSeconds($Cowboy::LastKillTime) @" ");
	HUD::AddTextLine(CowboyHUD, "");
	HUD::AddTextLine(CowboyHUD, "<f1>Get back ");
	HUD::AddTextLine(CowboyHUD, "to work! ");
	return $Cowboy::UpdateTime;
	}

function Cowboy::YouKilled() {
	if (Client::getName($Cowboy::LastVictim) == "") return 0;
	if (Cowboy::Enemy($Cowboy::LastVictim)) {
		%Killed = "Killed";
		if (getSimTime()/$Cowboy::UpdateTime/2 % 2 == 0)
			Cowboy::DrawBitmaps("cowboy\\reddot.bmp");
		else
			Cowboy::DrawBitmaps("skull_small.bmp");
		}
	else {
		%Killed = "<f2>Team Killed";
		if (getSimTime()/$Cowboy::UpdateTime/2 % 2 == 0)
			Cowboy::DrawBitmaps("cowboy\\angrysmiley.bmp");
		else
			Cowboy::DrawBitmaps("skull_small.bmp");
		}
	// Print stuff
	HUD::AddTextLine(CowboyHUD, "");
	HUD::AddTextLine(CowboyHUD, "<jc><f0>You "@ %Killed @" ");
	HUD::AddTextLine(CowboyHUD, "<f1>" @ Client::getName($Cowboy::LastVictim) @" ");
	if ($Cowboy::LastVictim == $Cowboy::LastEnemyKiller && getSimTime() % 2 == 0) {
		HUD::AddTextLine(CowboyHUD, "<f0>and got your "); 
		HUD::AddTextLine(CowboyHUD, "<f1>REVENGE! ");
		}
	else {
		HUD::AddTextLine(CowboyHUD, "<f0>with your "); 
		HUD::AddTextLine(CowboyHUD, "<f1>" @ $Cowboy::Weapon @" ");
		}
	return $Cowboy::UpdateTime;
	}

//
// The HUD stuff, this might be messy, but gets the job done... I haven't coded
// in about 4 years, and at that, never in C++, so please bear with me...
//
// I originally had problems while displaying the kill status on the screen.
// When you take into account there are 5 possibilities: Teammate killed you,
// Enemy killed you, You team killed, You killed an enemy, You committed
// suicide - and that these can happen in any order (yes you CAN kill someone
// after you die, it happens all the time), I had to change the 'logic' below
// to first check: How long it's been since a kill event (one of the 5 above
// actions), and then, from there, determine what just happened, how to display
// it, and then, if you were killed by an enemy, tell you to GET REVENGE!
//
// So.. hopefully this is all set. I have tested EVERY POSSIBLE COMBINATION
// of kills/deaths I can imagine (the bottom 1/4 of this file is just for
// debugging - I'm leaving it in there in case you want to see how insane i've
// gotten), and it seems to work 99.44% of the time now... so, enjoy this!
//
function Cowboy::UpdateHUD() {

	%t1 = $Cowboy::ShowTime;	// I assigned these to temp. variables
	%t2 = 2 * $Cowboy::ShowTime;	// here because I didn't want to make
	%t3 = 3 * $Cowboy::ShowTime;	// my if statements any uglier! Geesh!

	%returnval = 0;
	if ($Cowboy::LastEventTime <= %t1-1) {
		if ($Cowboy::LastKillTime <= %t1-1)
			%returnval = Cowboy::YouKilled();
		}
	else if ($Cowboy::LastEventTime >= %t1 && $Cowboy::LastEventTime <= %t2-1) {
		if ($Cowboy::LastDeathTime >= %t1 && $Cowboy::LastDeathTime <= %t2-1) {
			if ($Cowboy::LastDeath == 5)
				%returnval = Cowboy::Suicide();
			else if ($Cowboy::LastDeath == 4)
				%returnval = Cowboy::TeamKilledYou();
			else
				%returnval = Cowboy::EnemyKilledYou();
			}
		else if ($Cowboy::LastKillTime >= %t1 && $Cowboy::LastKillTime <= %t2-1) {
			if ($Cowboy::LastEnemyKiller != $Cowboy::LastVictim)
				%returnval = Cowboy::EnemyKilledYou();
			}
		}
	else if ($Cowboy::LastEventTime >= %t2 && $Cowboy::LastEventTime <= %t3-1) {
		if ($Cowboy::LastDeathTime >= %t2 && $Cowboy::LastDeathTime <= %t3-1) {
			if ($Cowboy::LastDeath >= 4)
				%returnval = Cowboy::EnemyKilledYou();
			}
		}
	else if ($Cowboy::LastEventTime >= $Cowboy::NotifyTime && $Cowboy::LastEventTime % $Cowboy::NotifyTime >= 0 && $Cowboy::LastEventTime % $Cowboy::NotifyTime <= %t1-1)
		%returnval = Cowboy::Wussie();
	else if ($Cowboy::LastEventTime >= $Cowboy::NotifyTime && $Cowboy::LastEventTime % $Cowboy::NotifyTime >= %t1+1 && $Cowboy::LastEventTime % $Cowboy::NotifyTime <= %t2)
		%returnval = Cowboy::EnemyKilledYou();
	else {
		%returnval = 0;	// Stop updating HUD
		}

	HUD::Display(CowboyHUD, %returnval);
	return %returnval;
	}

//
// On kill, check to see if we killed or were killed, and how
//
function Cowboy::Killed(%killer, %victim, %weapon) {

	%me = getManagerId();
	if (%killer != %me && %victim != %me)
		return;
	else if (%killer != %me && %victim == %me) {	// I got killed by someone!
		$Cowboy::LastKiller = %killer;
		if (Cowboy::Enemy(%killer)) {		// Enemy killed you
			$Cowboy::LastEvent = 3;
			$Cowboy::LastDeath = 3;
			$Cowboy::LastEnemyKiller = %killer;
			}
		else {					// Team killed you
			$Cowboy::LastEvent = 4;
			$Cowboy::LastDeath = 4;
			$Cowboy::LastTeamKiller = %killer;
			}
		$Cowboy::StartDeathTime = getSimTime();
		$Cowboy::LastDeathTime = getSimTime() - $Cowboy::StartDeathTime;
		}
	else if (%killer == %me && %victim != %me) {	// I killed someone!
		$Cowboy::LastVictim = %victim;
		if (Cowboy::Enemy(%victim)) {		// I killed an enemy
			$Cowboy::LastEvent = 1;
			$Cowboy::LastKill = 1;
			$Cowboy::LastEnemyVictim = %victim;
			}
		else {					// I Team killed
			$Cowboy::LastEvent = 2;
			$Cowboy::LastKill = 2;
			$Cowboy::LastTeamVictim = %victim;
			}
		$Cowboy::Weapon = %weapon;
		$Cowboy::StartTime = getSimTime();
		$Cowboy::LastKillTime = getSimTime() - $Cowboy::StartTime;
		}
	else if (%killer == %me && %victim == %me) {	// I committed suicide!
		$Cowboy::LastEvent = 5;
		$Cowboy::LastDeath = 5;
		$Cowboy::StartDeathTime = getSimTime();
		$Cowboy::LastDeathTime = getSimTime() - $Cowboy::StartDeathTime;
		}

	$Cowboy::StartEventTime = getSimTime();
	$Cowboy::LastEventTime = getSimTime() - $Cowboy::StartEventTime;
	}

//
// Reset CowboyHUD variables, counters, timers...
//
function Cowboy::Reset() {
	HUD::Display(CowboyHUD, false);	// Shut HUD off if it was left open

	$Cowboy::LastEnemyKiller = "";	
	$Cowboy::LastTeamKiller = "";
	$Cowboy::LastEnemyVictim = "";
	$Cowboy::LastTeamVictim = "";
	$Cowboy::LastVictim = "";
	$Cowboy::LastKiller = "";
	$Cowboy::LastEvent = false;
	$Cowboy::LastKill = false;
	$Cowboy::LastDeath = false;

	$Cowboy::StartDeathTime = getSimTime();
	$Cowboy::LastDeathTime = getSimTime() - $Cowboy::StartDeathTime;

	$Cowboy::StartTime = getSimTime();
	$Cowboy::LastKillTime = getSimTime() - $Cowboy::StartTime;

	$Cowboy::StartEventTime = getSimTime();
	$Cowboy::LastEventTime = getSimTime() - $Cowboy::StartEventTime;

	}

//
// Make sure all of this stuff actually displays...
//
HUD::New(CowboyHUD, Cowboy::UpdateHUD, $Cowboy::PlaceX, $Cowboy::PlaceY, $Cowboy::SizeX, $Cowboy::SizeY);

Event::Attach(eventKillTrak, Cowboy::Killed);
Event::Attach(eventConnected, Cowboy::Reset);
Event::Attach(eventChangeMission, Cowboy::Reset);
Event::Attach(eventConnected, Cowboy::Timer);


//
// The rest of the file is only for debugging, not for normal screen display!
//
function CowboyDebug::Update () {
	HUD::AddText(CowboyDebugHUD, "<jl>");

	HUD::AddTextLine(CowboyDebugHUD, "<f2>Last Times:");
	HUD::AddText(CowboyDebugHUD, "<f0>Kill: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ MinuteSeconds($Cowboy::LastKillTime) @", "@ $Cowboy::LastKillTime);
	HUD::AddText(CowboyDebugHUD, "<f0>Death: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ MinuteSeconds($Cowboy::LastDeathTime) @", "@ $Cowboy::LastDeathTime);
	HUD::AddText(CowboyDebugHUD, "<f0>Event: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ MinuteSeconds($Cowboy::LastEventTime) @", "@ $Cowboy::LastEventTime);
	HUD::AddTextLine(CowboyDebugHUD, "");
	HUD::AddTextLine(CowboyDebugHUD, "<f2>Variables:");

	HUD::AddText(CowboyDebugHUD, "<f0>L_E: <f1>" @ $Cowboy::LastEvent);
	if ($Cowboy::LastEvent == 1)
		HUD::AddTextLine(CowboyDebugHUD, ", You Killed Enemy");
	else if ($Cowboy::LastEvent == 2)
		HUD::AddTextLine(CowboyDebugHUD, ", You Team Killed");
	else if ($Cowboy::LastEvent == 3)
		HUD::AddTextLine(CowboyDebugHUD, ", Enemy Killed You");
	else if ($Cowboy::LastEvent == 4)
		HUD::AddTextLine(CowboyDebugHUD, ", Team Killed You");
	else if ($Cowboy::LastEvent == 5)
		HUD::AddTextLine(CowboyDebugHUD, ", You Committed Suicide");
	else
		HUD::AddTextLine(CowboyDebugHUD, ", "@ $Cowboy::LastEvent);

	HUD::AddText(CowboyDebugHUD, "<f0>L_D: <f1>" @ $Cowboy::LastDeath);
	if ($Cowboy::LastDeath == 1)
		HUD::AddTextLine(CowboyDebugHUD, ", You Killed Enemy");
	else if ($Cowboy::LastDeath == 2)
		HUD::AddTextLine(CowboyDebugHUD, ", You Team Killed");
	else if ($Cowboy::LastDeath == 3)
		HUD::AddTextLine(CowboyDebugHUD, ", Enemy Killed You");
	else if ($Cowboy::LastDeath == 4)
		HUD::AddTextLine(CowboyDebugHUD, ", Team Killed You");
	else if ($Cowboy::LastDeath == 5)
		HUD::AddTextLine(CowboyDebugHUD, ", You Committed Suicide");
	else
		HUD::AddTextLine(CowboyDebugHUD, ", "@ $Cowboy::LastDeath);

	HUD::AddText(CowboyDebugHUD, "<f0>L_K: <f1>" @ $Cowboy::LastKill);
	if ($Cowboy::LastKill == 1)
		HUD::AddTextLine(CowboyDebugHUD, ", You Killed Enemy");
	else if ($Cowboy::LastKill == 2)
		HUD::AddTextLine(CowboyDebugHUD, ", You Team Killed");
	else if ($Cowboy::LastKill == 3)
		HUD::AddTextLine(CowboyDebugHUD, ", Enemy Killed You");
	else if ($Cowboy::LastKill == 4)
		HUD::AddTextLine(CowboyDebugHUD, ", Team Killed You");
	else if ($Cowboy::LastKill == 5)
		HUD::AddTextLine(CowboyDebugHUD, ", You Committed Suicide");
	else
		HUD::AddTextLine(CowboyDebugHUD, ", "@ $Cowboy::LastKill);

	HUD::AddTextLine(CowboyDebugHUD, "");
	HUD::AddText(CowboyDebugHUD, "<f0>LEK: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ $Cowboy::LastEnemyKiller @", "@ Client::getName($Cowboy::LastEnemyKiller));
	HUD::AddText(CowboyDebugHUD, "<f0>LTK: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ $Cowboy::LastTeamKiller @", "@Client::getName($Cowboy::LastTeamKiller));
	HUD::AddText(CowboyDebugHUD, "<f0>LEV: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ $Cowboy::LastEnemyVictim @", "@Client::getName($Cowboy::LastEnemyVictim));
	HUD::AddText(CowboyDebugHUD, "<f0>LTV: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ $Cowboy::LastTeamVictim @", "@Client::getName($Cowboy::LastTeamVictim));
	HUD::AddTextLine(CowboyDebugHUD, "");
	HUD::AddText(CowboyDebugHUD, "<f0>Killer: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ $Cowboy::LastKiller @", "@Client::getName($Cowboy::LastKiller));
	HUD::AddText(CowboyDebugHUD, "<f0>Victim: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ $Cowboy::LastVictim @", "@Client::getName($Cowboy::LastVictim));
	HUD::AddTextLine(CowboyDebugHUD, "");
	HUD::AddText(CowboyDebugHUD, "<f0>You Are: ");
	HUD::AddTextLine(CowboyDebugHUD, "<f1>"@ getManagerId() @", "@Client::getName(getManagerId()));
	return $Cowboy::UpdateTime;
	}	

if ($Cowboy::Debugmode) {
	HUD::New(CowboyDebugHUD, CowboyDebug::Update, 544, 85, 250, 300);

	EditActionMap("playMap.sae"); 

	bindCommand(keyboard0, make, "f12", TO, "HUD::ToggleDisplay(CowboyDebugHUD);");
	bindCommand(keyboard0, break, "f12", TO, "");
	}
