//
// ReticleCompass 2.01
// By Tim 'Zear' Hammock
//

function RetComp::init()
{
    $RetComp::on = FALSE;
    
    HUD::NewHud(XHairCompass, FearGui::CompassHud, playGui, "50%-31 50%-31 1 1");
    HUD::Display(XHairCompass, TRUE);

    %hoff = $RetComp::prefs::dhOffset+1;
    %voff = $RetComp::prefs::dvOffset;
    
    if(%hoff > -1)
        %hoff = "+"@%hoff;
    if(%voff > -1)
        %voff = "+"@%voff;
    
    %pos = "50%"@%hoff@" 50%"@%voff@" 19 10";
    HUD::NewHud("XHairDist", SimGui::Control, playGui, %pos);
    %dist1 = NewOpts::getIdFromSet("NamedGuiSet", "HUD::XHairDist");
    %dist2 = newObject("XHairDist2", FearGui::CompassHud, -23, -27, 64, 64);
    addToSet(%dist1, %dist2);
}

function RetComp::setupEvent(%gui)
{
    if(%gui == PlayGui)
        schedule("RetComp::init();", 0.1);
}
Event::Attach(eventGuiOpen, RetComp::setupEvent, RetCompInit);

function RetComp::toggleMake()
{
    if($RetComp::prefs::toggle == TRUE)
        $RetComp::on = !$RetComp::on;
    else
        $RetComp::on = TRUE;
        
    HUD::Display(XHairDist, $RetComp::on);
    HUD::Display(XHairCompass, !$RetComp::on);
}    

function RetComp::toggleBreak()
{
    if($RetComp::prefs::toggle != TRUE)
    {
        $RetComp::on = FALSE;
        HUD::Display(XHairDist, $RetComp::on);
        HUD::Display(XHairCompass, !$RetComp::on);
    }
}

function RetComp::prefsInit()
{
    Control::setValue(RetComp::hOff, $RetComp::prefs::dhOffset);
    Control::setValue(RetComp::vOff, $RetComp::prefs::dvOffset);
}

function RetComp::prefsClose()
{
    if($RetComp::prefs::dhOffset == "")
        $RetComp::prefs::dhOffset = 0;
    if($RetComp::prefs::dvOffset == "")
        $RetComp::prefs::dvOffset = 0;

    export("$RetComp::prefs*", "config\\ReticleCompassPrefs.cs");
}

if ($Presto::version < 0.94 && $HUD::NewHud::installed != TRUE)
{
    $HUD::NewHud::installed = TRUE;
    
    function HUD::NewHud(%hud, %type, %gui, %x, %y, %width, %height)
    {
	    if (%y == "")
		    %pos = %x;
	    else
	        %pos = %x @" "@ %y @" "@ %width @" "@ %height;

	    if (HUD::Exists(%hud))
		    HUD::Delete(%hud);
	    HUD::SetPosition(%hud, %pos);
	    HUD::SetUpdateFunc(%hud, "");

	    %pos = HUD::InterpCoords(%hud, %pos);
	    %x = getWord(%pos, 0);
	    %y = getWord(%pos, 1);
	    %width = getWord(%pos, 2);
	    %height = getWord(%pos, 3);
	    if (%width == 0)
	    {
		    echo("Zero width in HUD::NewHud()");
		    return;
	    }
	    HUD::SetGuiObject(%hud, frame, newObject("HUD::"@%hud, %type, %x, %y, %width, %height));

	    Control::SetVisible("HUD::"@%hud, false);  // invisible by default
	    HUD::SetAttached(%hud, false);
	    HUD::SetGui(%hud, %gui);
	    HUD::SetGuiObjectCount(%hud, 0);
	    $HUD::[%hud, schedule] = "";

	    // Reuse a slot when possible.
	    %numHUDs = $HUD::numHUDs;
	    if (%numHUDs == "")
		    %numHUDs = 0;
	    for (%i = 0; %i < %numHUDs; %i++)
		    if ($HUD::name[%i] == %hud)
			    return;
	    $HUD::name[%numHUDs] = %hud;
	    $HUD::numHUDs = %numHUDs + 1;
    }
}

if(isFile("config\\ReticleCompassPrefs.cs"))
    exec("ReticleCompassPrefs.cs");

if($RetComp::prefs::dhOffset == "")
    $RetComp::prefs::dhOffset = 0;
if($RetComp::prefs::dvOffset == "")
    $RetComp::prefs::dvOffset = 0;
if($RetComp::prefs::toggle == "")
    $RetComp::prefs::toggle = FALSE;

NewOpts::register("ReticleCompass", "Zear\\RetCompGui\\RetComp.gui", "RetComp::prefsInit();", "RetComp::prefsClose();", true);
exec("Zear\\RetCompGui\\RetCompHelp.cs");
