// 
// VariFOV
// Written by Tim "Zear" Hammock
//
// Requires Tribes 1.3 or better
// and the Presto Pack
// 

//  set these 9 to whatever you like or feels comfortable
$VariFov::zoomInKey = "up";     // this is the key to be bound to zoom in
$VariFov::zoomOutKey = "down";  // this is the key to be bound to zoom out
$VariFov::defaultFov = 90;      // 'normal' FOV for you (TRIBES default is 90)
$VariFov::maxFov = 90;          // 'max' FOV for you (TRIBES won't render > 120)
$VariFov::minFov = 5;           // 'min' FOV for you (TRIBES won't render < 5)
$VariFov::increment = 1;        // degrees of FOV to change each increment
$VariFov::delay = 0.02;         // basis for time between FOV increments (the actual varies)
$VariFov::sensitMax = 0.003;    // sensitivity at maxFov
$VariFov::sensitMin = 0.002;    // sensitivity at minFov


// leave these alone: trust me
$pref::PlayerFov = $VariFov::defaultFov;
EditActionMap("playMap.sae");
bindCommand(keyboard0, make, $VariFov::zoomInKey, TO, "VariFov::VariFov(\"in\");");
bindCommand(keyboard0, break, $VariFov::zoomInKey, TO, "VariFov::VariFovRelease(\"in\");");
bindCommand(keyboard0, make, $VariFov::zoomOutKey, TO, "VariFov::VariFov(\"out\");");
bindCommand(keyboard0, break, $VariFov::zoomOutKey, TO, "VariFov::VariFovRelease(\"out\");");

function VariFov::VariFov(%delta)
{
    $VariFov::direction = %delta;
    
    if($VariFov::dblClick == %delta)
    {
        $VariFov::dblClick = "";
        $VariFov::direction = "";
        VariFov::setSensitivity($VariFov::defaultFov);
        $pref::PlayerFov = $VariFov::defaultFov;
    }
    else
    {
        $VariFov::dblClick = %delta;
        schedule("$VariFov::dblClick = \"\";", 0.3);
        VariFov::setFov();
    }
}

function VariFov::VariFovRelease(%delta)
{
    $VariFov::direction = "";
} 

function VariFov::setFov()
{
    if($VariFov::direction == "")
        return;

    %fov = $pref::PlayerFov;
    if($VariFov::direction == "out")
    {
        %fov += $VariFov::increment;
        if(%fov > $VariFov::maxFov)
            %fov = $VariFov::maxFov;
    }
    else if ($VariFov::direction == "in")
    {
        %fov -= $VariFov::increment;
        if(%fov < $VariFov::minFov)
            %fov = $VariFov::minFov;
    }
    %sens = VariFov::setSensitivity(%fov);
    $pref::PlayerFov = %fov;
    %delay = $VariFov::delay * ((($VariFov::sensitMax - %sens) * 100) + 0.7);
    if(%fov < 30)
        %delay *= 1.2;
    else if(%fov < 16)
        %delay *= 1.4;
    schedule("VariFov::setFov();", %delay);
}

function VariFov::setSensitivity(%fov)
{
    %sensitivity = ($VariFov::sensitMin + ((%fov - $VariFov::minFov) * $VariFov::sensitInc));

    EditActionMap("playMap.sae");
    bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);
    bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sensitivity);
    
    return %sensitivity;
}

function VariFov::presetIntervals()
{
    %fRange = $VariFov::maxFov - $VariFov::minFov;
    %sRange = $VariFov::sensitMax - $VariFov::sensitMin;
    $VariFov::sensitInc = %sRange / %fRange;
}
VariFov::presetIntervals();
