// ---------------------------------------------------------------------------
// version.cs -- Version 1.6 -- April 15, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


// To use this feature in your own scripts, use:
//
// include("writer\\version.cs");
// version("<script filename>", "<version.revision>", "<author>", "<description>");
//
// Note that you should put the version number in quotes like "1.1" -- this will
// be parsed and stored internally as a version and a revision.  Note that this
// means 1.12 is "version 1, revision 12" and is larger than 1.9!
//
// -- See bottom of this script for an example of a version call


//
// Get or set some version information for a script
//
// version(%file)
//
// ...returns the version number as a string
//
// version(%file, %version)
//
// ...returns true if %version is newer than the version of %file
//
// version(%file, %version, %author)
// version(%file, %version, %author, %description)
//
// ...both set the version info, and return the previous version for that file
//
// Pass 'debug' as the last argument to echo some debug information to the console.
//
function version(%file, %version, %author, %description, %debug)
{
    //
    // Check for debug arg
    //
    if(%version == "debug")
    {
        %version = "";  %debug = true;
    }
        
    if(%author == "debug")
    {
        %author = "";   %debug = true;
    }

    if(%description == "debug")
    {
        %description = "";   %debug = true;
    }

    if( (%debug == "debug") || $Debug::echo || $PrestoPrefs::StringNoise )
        %debug = true;


    // Automatically add the .cs extention if it's missing
    if( String::findSubStr(%file, ".cs") == -1)
        %file = %file @ ".cs";

    if(%version == "")
    {
        %version = $Version::number[%file];

        if(%debug)
            echo(%file @ " version " @ %version @ " by " @ %author @ " " @ $Version::string[%file]);

        return %version;
    }
    else if(%author == "") // compare versions
    {
        if(Version::compare(%file, %version) > 0)
        {
            if(%debug)
                echo(%version @ " is newer than " @ $Version::number[%file]);

            return true;
        }
        else
        {
            if(%debug)
                echo(%version @ " is not newer than " @ $Version::number[%file]);

            return false;
        }
    }
    else // set new version info
    {
        // Check what version was in use before ("" if none)
        %replaces = $Version::number[%file];

        $Version::number[%file] = %version;
        $Version::author[%file] = %author;
        $Version::description[%file] = %description;

        if(%debug)
            echo("setting " @ %file @ " version " @ %version @ " by " @ %author @ " " @ %description);

        if( (%replaces != "") && (%replaces != %version) )
        {
            if(%debug)
                echo("...replacing version " @ %replaces);
        }

        return %replaces;
    }
}


//
// Compare a version number string to a loaded file's version number
//
// Returns -1 if %version is smaller, 0 if same, 1 if larger
//
function Version::compare(%file, %version)
{
    %file_version = %file_revision = %test_version = %test_revision = 0;

    if($Version::number[%file] == "")
        return true; // any version is newer than no version :)

    if(%version  == "")
        return false; // no version isn't newer than anything :)
    
    if( (%decimalPos = String::findSubStr($Version::number[%file], ".")) != -1 )
    {
        // Get version & revision of file
        %file_version = String::getSubStr($Version::number[%file], 0, %decimalPos); 
        %file_revision = String::getSubStr($Version::number[%file], %decimalPos + 1, 1024);
    }
    else
    {
        // no revision number?
        %file_version = $Version::number[%file];
        %file_revision = 0;
    }

    if( (%decimalPos = String::findSubStr(%version, ".")) != -1 )
    {
        %test_version = String::getSubStr(%version, 0, %decimalPos);
        %test_revision = String::getSubStr(%version, %decimalPos + 1, 1024);
    }
    else
    {
        // no revision number?
        %test_version = %version;
        %test_revision = 0;
    }

    if(%file_version > %test_version)
        return -1;
    else if(%file_version < %test_version)
        return 1;
    else // %file_version == %test_version
    {
        if(%file_revision > %test_revision)
            return -1;
        else if(%file_revision < %test_revision)
            return 1;
        else // %file_revision == %test_revision
            return 0;
    }
}


//
// Update version info if it's newer than the loaded file's version info.
//
// Returns true if info provided is newer and was updated.
//
// Use this to update and test the version info at the same time. :)
//
function Version::update(%file, %version, %author, %description)
{
    if(version(%file, %version))
    {
        version(%file, %version, %author, %description);
        return true;
    }
    return false;
}


//
// Return the author of a given file
//
function Version::author(%file)
{
    return $Version::author[%file];
}


//
// Return the version string for a given file
//
function Version::description(%file)
{
    return $Version::description[%file];
}


version("writer\\version.cs", "1.6", "Lorne Laliberte", "- April 15, 1999 - provides version functions - www.planetstarsiege.com/lorne/");
