// FILE:		z0dd_Elfer.cs
// VERSION:		1.01
// DATE:		1/20/01
// AUTHOR:		Paul "z0dd" Paella
// EMAIL:		z0dd@adelphia.net
// WEBPAGE:		http://home.adelphia.net/~z0dd/
//                           
//
// DESCRIPTION:
//	Holding down a single button will automatically switch your weapon to
//	the Elf and fire it until you let go of the button. Upon relelase,
//      you'll switch back to the weapon you held before you pressed the Elfer
//      key.
//
// INSTALLATION:
//	Put z0dd_Elfer.cs into your:
//		...\tribes\config
// 	directory and insert this line into your autoexec.cs:
//		exec("z0dd_elfer.cs");
//
// 	This script is configured by editing the area labeled:
//	USER CONFIGURATION SECTION
//
// VERSION HISTORY:
//	1.01	- Added: editActionMap("playMap.sae"); to prevent config.cs
//                problems.
//
//////////////////////////////////////////////////////////////////////////////                                                      

// Don't edit the following line
editActionMap("playMap.sae");
                                                               
//////////////////////////////////////////////////////////////////////////////
//////////////////////// USER CONFIGURATION SECTION //////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
bindCommand(keyboard0, make, "n", TO, "z0ddElfer::doElfer();");
bindCommand(keyboard0, break, "n", TO, "z0ddElfer::unDoElfer();");


// ----------------------- Previous Weapon Auto-Switch -----------------------
//                          
// Set this to 1 if you want to automatically switch back to the weapon you
// were holding prior to pressing the "elf" key
//
// Set this to 0 to turn off Previous weapon Auto-Switching
$z0ddElfer::switchBackToWpn = 1;
                                                                                              

//////////////////////////////////////////////////////////////////////////////
///////////////////// END OF USER CONFIGURATION SECTION //////////////////////
//////////////////////////////////////////////////////////////////////////////

                                                                
//////////////////////////////////////////////////////////////////////////////
//  SCRIPT SECTION. DON'T EDIT PAST THIS LINE UNLESS YOU WHAT YOU'RE DOING  //
//////////////////////////////////////////////////////////////////////////////
function z0ddElfer::getCurrentWpn()
{
	%wpn = getMountedItem(0);

	if (%wpn == 21)
		return "Disc Launcher";
	else if (%wpn == 11)
		return "Blaster";
	else if (%wpn == 13)
		return "Chaingun";
	else if (%wpn == 15)
		return "Plasma Gun";
	else if (%wpn == 17)
		return "Grenade Launcher";
	else if (%wpn == 24)
		return "ELF Gun";
	else if (%wpn == 23)
		return "Targeting Laser";
	else
		return "";
}

   
function z0ddElfer::doElfer()
{
	if($z0ddElfer::switchBackToWpn)
		$z0ddElfer::prevWpn = z0ddElfer::getCurrentWpn();

	use("Elf gun");
	postAction(2048, IDACTION_FIRE1, 1.000000);
}
 
function z0ddElfer::unDoElfer()
{
	postAction(2048, IDACTION_BREAK1, 1.000000);
	if($z0ddelfer::switchBackToWpn)
		use($z0ddElfer::prevWpn);
}
